/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.web.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebContractSearchModule;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebContractSearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebContractSearchParamType;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebContractSearchResult;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public abstract class WebContractSearchModuleBase
implements WebContractSearchModule {
    protected Connection connection;
    protected WebContractSearchParam title = new WebContractSearchParam("title", WebContractSearchParamType.STRING);
    protected WebContractSearchParam useForAccessRestore = new WebContractSearchParam("use.for.access.restore", WebContractSearchParamType.BOOLEAN);
    protected WebContractSearchParam useForPayment = new WebContractSearchParam("use.for.payment", WebContractSearchParamType.BOOLEAN);
    protected WebContractSearchParam searchTextComment = new WebContractSearchParam("search.text.comment", WebContractSearchParamType.STRING);
    protected WebContractSearchParam searchTextPlaceHolder = new WebContractSearchParam("search.text.place.holder", WebContractSearchParamType.STRING);
    protected WebContractSearchParam searchByCustomer = new WebContractSearchParam("search.by.customer", WebContractSearchParamType.BOOLEAN);
    protected WebContractSearchParam searchByContractParamId = new WebContractSearchParam("search.by.contract.parameter.id", WebContractSearchParamType.STRING);
    protected WebContractSearchParam popupHintCount = new WebContractSearchParam("popup.hint.count", WebContractSearchParamType.STRING);
    protected WebContractSearchParam verifyByCustomerFIO = new WebContractSearchParam("verify.by.customer.fio", WebContractSearchParamType.BOOLEAN);
    protected WebContractSearchParam verifyByCustomerEmail = new WebContractSearchParam("verify.by.customer.email", WebContractSearchParamType.BOOLEAN);
    protected WebContractSearchParam verifyByCustomerPhone = new WebContractSearchParam("verify.by.customer.phone", WebContractSearchParamType.BOOLEAN);
    protected WebContractSearchParam verifyByContractParameterEmailId = new WebContractSearchParam("verify.by.contract.parameter.email.id", WebContractSearchParamType.STRING);
    protected WebContractSearchParam verifyByContractParameterPhoneId = new WebContractSearchParam("verify.by.contract.parameter.phone.id", WebContractSearchParamType.STRING);
    protected List<WebContractSearchParam> contractSearchParams = null;

    @Override
    public void init(Connection connection) {
        this.connection = connection;
        if (this.contractSearchParams != null) {
            JSONObject jsonObject = new JSONObject(ServerUtils.getSetupValue(connection, this.getClass().getName(), "{}"));
            for (WebContractSearchParam webContractSearchParam : this.contractSearchParams) {
                String defValue = "";
                if (this.searchTextPlaceHolder.equals(webContractSearchParam)) {
                    defValue = this.getSearchTextPlaceHolderText();
                } else if (this.searchTextComment.equals(webContractSearchParam)) {
                    defValue = this.getSearchTextCommentText();
                } else if (this.title.equals(webContractSearchParam)) {
                    defValue = this.getTitleText();
                } else if (this.popupHintCount.equals(webContractSearchParam)) {
                    defValue = this.getPopupHintCount();
                }
                webContractSearchParam.setValue(jsonObject.optString(webContractSearchParam.getKey(), defValue));
            }
        }
    }

    @Override
    public List<IdTitle> doHintSearch(String searchText) throws BGException {
        return null;
    }

    @Override
    public List<WebContractSearchResult> doSearch(String searchText) throws BGException {
        return new ArrayList<WebContractSearchResult>();
    }

    @Override
    public boolean useHintSerach() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.title.getValue();
    }

    @Override
    public boolean useForAccessRestore() {
        return Utils.parseBoolean((String)this.useForAccessRestore.getValue(), (boolean)false);
    }

    @Override
    public boolean useForPayment() {
        return Utils.parseBoolean((String)this.useForPayment.getValue(), (boolean)false);
    }

    @Override
    public List<WebContractSearchParam> getParameters() {
        return this.contractSearchParams;
    }

    @Override
    public String getSearchTextPlaceHolder() {
        return this.searchTextPlaceHolder.getValue();
    }

    @Override
    public String getSearchTextComment() {
        return this.searchTextComment.getValue();
    }

    protected String getSearchTextPlaceHolderText() {
        return "";
    }

    protected String getSearchTextCommentText() {
        return "";
    }

    protected String getTitleText() {
        return "";
    }

    protected String getPopupHintCount() {
        return "5";
    }

    protected void verifyByContractParameterEmail(List<WebContractSearchResult> results, int paramId) {
        if (results == null || results.isEmpty()) {
            return;
        }
        List<Integer> list = results.stream().filter(a -> a.getVerifyTitle() == null).map(a -> a.getContractId()).toList();
        if (list.isEmpty()) {
            return;
        }
        String query = "SELECT cid, email FROM contract_parameter_type_3 WHERE pid=? AND cid IN ( " + Utils.toString(list) + " )";
        try (PreparedStatement psSelect = this.connection.prepareStatement(query);){
            psSelect.setInt(1, paramId);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    String email = rs.getString("email").split("\n")[0];
                    if (!Utils.notBlankString((String)email)) continue;
                    int contractId = rs.getInt("cid");
                    results.stream().filter(a -> a.getContractId() == contractId).forEach(a -> {
                        a.setVerifyTitle("E-mail");
                        a.setVerifyValue(Utils.maskEmail((String)email.replaceAll("^.*\\<", "").replaceAll("\\>.*$", "")));
                    });
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void verifyByContractParameterPhone(List<WebContractSearchResult> results, int paramId) {
        if (results == null || results.isEmpty()) {
            return;
        }
        List<Integer> list = results.stream().filter(a -> a.getVerifyTitle() == null).map(a -> a.getContractId()).toList();
        if (list.isEmpty()) {
            return;
        }
        String query = "SELECT cid, phone FROM contract_parameter_type_phone_item WHERE pid=? AND n=1 AND cid IN ( " + Utils.toString(list) + " )";
        try (PreparedStatement psSelect = this.connection.prepareStatement(query);){
            psSelect.setInt(1, paramId);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    String phone = rs.getString("phone");
                    if (!Utils.notBlankString((String)phone)) continue;
                    int contractId = rs.getInt("cid");
                    results.stream().filter(a -> a.getContractId() == contractId).forEach(a -> {
                        a.setVerifyTitle("\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430");
                        a.setVerifyValue(Utils.maskPhoneNumber((String)phone, (int)4, (int)2));
                    });
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void verifyByCustomerEmail(List<WebContractSearchResult> results) {
        this.verifyByCustomerField(results, "email_", "E-mail");
    }

    protected void verifyByCustomerPhone(List<WebContractSearchResult> results) {
        this.verifyByCustomerField(results, "phone_", "\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430");
    }

    protected void verifyByCustomerField(List<WebContractSearchResult> results, String fieldName, String verifyTitle) {
        if (results == null || results.isEmpty()) {
            return;
        }
        List<Integer> list = results.stream().filter(a -> a.getVerifyTitle() == null).map(a -> a.getContractId()).toList();
        if (list.isEmpty()) {
            return;
        }
        String query = "SELECT contract_id, data from customer_link AS cl LEFT JOIN customer AS c ON c.id=cl.customer_id WHERE cl.date_to IS NULL AND cl.contract_id IN ( " + Utils.toString(list) + " )";
        try (Statement statement = this.connection.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                String name;
                JSONObject json = new JSONObject(rs.getString("data"));
                JSONObject contact = (JSONObject)json.optQuery("/customer/contact");
                if (contact == null || (name = (String)contact.keySet().stream().filter(a -> a.startsWith(fieldName)).findFirst().orElse(null)) == null) continue;
                int contractId = rs.getInt("contract_id");
                results.stream().filter(a -> a.getContractId() == contractId).forEach(a -> {
                    a.setVerifyTitle(verifyTitle);
                    if ("email_".equals(fieldName)) {
                        a.setVerifyValue(Utils.maskEmail((String)contact.optString(name)));
                    } else if ("phone_".equals(fieldName)) {
                        a.setVerifyValue(Utils.maskPhoneNumber((String)contact.optString(name), (int)4, (int)2));
                    } else {
                        a.setVerifyValue(contact.optString(name));
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

