/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;

public class GateFilterPanel
extends BGPanel {
    private BGComboBox<ComboBoxItem> type = new BGComboBox();
    private BGUComboBox<IdTitle> cityComboBox = new BGUComboBox();
    private BGUComboBox<IdTitle> areaComboBox = new BGUComboBox();
    private BGUComboBox<IdTitle> streetComboBox = new BGUComboBox();
    private BGUComboBox<IdTitle> quarterComboBox = new BGUComboBox();
    private IntTextField podField = new IntTextField();
    private IntTextField houseField = new IntTextField();
    private IntTextField floorField = new IntTextField();
    private JTextField host = new JTextField();
    private JTextField comment = new JTextField();
    private JTextField fracField = new JTextField();
    private boolean filterWasInit = false;
    private BGPanel parentPanel = null;

    public GateFilterPanel(BGPanel parentPanel) {
        this.initGUI();
        this.parentPanel = parentPanel;
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        JPanel addressFilter = this.createAddressPanel();
        JPanel gateFilterPanel = this.createGateFilterPanel();
        JButton applyButton = new JButton();
        applyButton.setText("\u041d\u0430\u0439\u0442\u0438");
        applyButton.addActionListener(e -> this.parentPanel.setData());
        JButton reserButton = new JButton();
        reserButton.setText("\u0421\u0431\u0440\u043e\u0441");
        reserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GateFilterPanel.this.cityComboBox.setSelectedIndex(0);
                GateFilterPanel.this.streetComboBox.setSelectedIndex(0);
                GateFilterPanel.this.quarterComboBox.setSelectedIndex(0);
                GateFilterPanel.this.areaComboBox.setSelectedIndex(0);
                GateFilterPanel.this.houseField.setText(null);
                GateFilterPanel.this.fracField.setText(null);
                GateFilterPanel.this.houseField.setText(null);
                GateFilterPanel.this.podField.setText(null);
                GateFilterPanel.this.floorField.setText(null);
                GateFilterPanel.this.host.setText(null);
                GateFilterPanel.this.comment.setText(null);
                GateFilterPanel.this.type.setSelectedIndex(0);
            }
        });
        this.add(gateFilterPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(addressFilter, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(applyButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(reserButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel createGateFilterPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)new JLabel(" \u0425\u043e\u0441\u0442: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        result.add((Component)this.host, new GridBagConstraints(0, 1, 1, 1, 0.1, 1.0, 17, 1, new Insets(2, 5, 0, 5), 0, 0));
        result.add((Component)new JLabel(" \u0422\u0438\u043f: "), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        result.add((Component)this.type, new GridBagConstraints(1, 1, 1, 1, 0.1, 1.0, 17, 1, new Insets(2, 5, 0, 5), 0, 0));
        result.add((Component)new JLabel(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        result.add((Component)this.comment, new GridBagConstraints(2, 1, 1, 1, 0.8, 1.0, 17, 1, new Insets(2, 5, 0, 5), 0, 0));
        return result;
    }

    private JPanel createAddressPanel() {
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.setBorder((Border)new BGTitleBorder("\u0410\u0434\u0440\u0435\u0441"));
        this.fracField.setCaretColor(Color.black);
        this.fracField.setEditable(true);
        this.fracField.setHorizontalAlignment(0);
        this.fracField.setColumns(7);
        this.fracField.setMaximumSize(new Dimension(70, 25));
        this.houseField.setColumns(7);
        this.houseField.setMaximumSize(new Dimension(70, 25));
        JLabel houseLabel = new JLabel(" \u0414\u043e\u043c / \u0414\u0440\u043e\u0431\u044c: ");
        JLabel podLabel = new JLabel(" \u041f\u043e\u0434\u044a\u0435\u0434 ");
        JLabel floorLabel = new JLabel(" \u042d\u0442\u0430\u0436 ");
        this.cityComboBox.setMaximumSize(new Dimension(120, 24));
        this.cityComboBox.setPreferredSize(new Dimension(120, 24));
        this.streetComboBox.setMaximumSize(new Dimension(120, 24));
        this.streetComboBox.setPreferredSize(new Dimension(120, 24));
        filterPanel.add((Component)new JLabel(" \u0413\u043e\u0440\u043e\u0434: "), new GridBagConstraints(0, 0, 1, 1, 0.4, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.cityComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)new JLabel(" \u0420\u0430\u0439\u043e\u043d: "), new GridBagConstraints(1, 0, 2, 1, 0.3, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.areaComboBox, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)new JLabel(" \u041a\u0432\u0430\u0440\u0442\u0430\u043b: "), new GridBagConstraints(3, 0, 2, 1, 0.3, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.quarterComboBox, new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)new JLabel(" \u0423\u043b\u0438\u0446\u0430: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.streetComboBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)houseLabel, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.houseField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)this.fracField, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)podLabel, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.podField, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)floorLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.floorField, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.cityComboBox.addActionListener(e -> this.setAddressToFilter());
        return filterPanel;
    }

    public void initFilter() {
        if (!this.filterWasInit) {
            try {
                this.setComboBoxItems(this.cityComboBox, this.getContext().getDirectory(City.class, 0).list().stream().map(IdTitle::toIdTitle).toList());
                this.setAddressToFilter();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.filterWasInit = true;
            Request req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAction("GateTypeList");
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.buildComboBox(this.type, (Node)XMLUtils.getElement((Document)doc, (String)"list"), (String)"");
                this.type.insertItemAt((Object)new ComboBoxItem((Object)"0", "\u041f\u0430\u043f\u043a\u0430"), 0);
                this.type.insertItemAt((Object)new ComboBoxItem((Object)"-1", "\u041b\u044e\u0431\u043e\u0439"), 0);
                this.type.setSelectedIndex(0);
                this.filterWasInit = true;
            }
        }
    }

    private void setAddressToFilter() {
        int cityid = ((IdTitle)this.cityComboBox.getSelectedItem()).getId();
        try {
            this.setComboBoxItems(this.areaComboBox, this.getContext().getDirectory(Area.class, 0).list().stream().filter(a -> a.getCityId() == cityid).map(IdTitle::toIdTitle).toList());
            this.setComboBoxItems(this.quarterComboBox, this.getContext().getDirectory(Quarter.class, 0).list().stream().filter(a -> a.getCityId() == cityid).map(IdTitle::toIdTitle).toList());
            this.setComboBoxItems(this.streetComboBox, this.getContext().getDirectory(Street.class, 0).list().stream().filter(a -> a.getCityId() == cityid).map(IdTitle::toIdTitle).toList());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void setComboBoxItems(BGUComboBox<IdTitle> comboBox, List<IdTitle> items) {
        ArrayList<IdTitle> idTitles = new ArrayList<IdTitle>();
        idTitles.add(new IdTitle(-1, "\u043b\u044e\u0431\u043e\u0439"));
        idTitles.addAll(items);
        comboBox.setData(idTitles);
        comboBox.setSelectedIndex(0);
    }

    public void setData() {
        this.initFilter();
    }

    public void addFilterParams(Request request) {
        request.setAttribute("host", this.host.getText());
        ComboBoxItem item = (ComboBoxItem)this.type.getSelectedItem();
        request.setAttribute("type", ((ComboBoxItem)this.type.getSelectedItem()).getObject());
        request.setAttribute("comment", this.comment.getText());
        request.setAttribute("cityId", (Object)this.cityComboBox.optSelectedItem().map(a -> a.getId()).orElse(-1));
        request.setAttribute("streetId", (Object)this.streetComboBox.optSelectedItem().map(a -> a.getId()).orElse(-1));
        request.setAttribute("areaId", (Object)this.areaComboBox.optSelectedItem().map(a -> a.getId()).orElse(-1));
        request.setAttribute("quarterId", (Object)this.quarterComboBox.optSelectedItem().map(a -> a.getId()).orElse(-1));
        request.setAttribute("house", this.houseField.getValue());
        request.setAttribute("frac", this.fracField.getText());
        request.setAttribute("pod", this.podField.getValue());
        request.setAttribute("floor", this.floorField.getValue());
    }
}

