/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import bitel.billing.module.common.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLink;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLinkRule;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.IpField;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceInterfaceService;

public class TrafficTypeLinkPanel
extends BGUPanel {
    private BGEditor editor = new BGEditor("table");
    private InetServService inetServService = null;
    private InetDeviceService inetDeviceService = null;
    private TrafficTypeLinkTableModel model = new TrafficTypeLinkTableModel();

    public TrafficTypeLinkPanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent((Component)((Object)this));
    }

    private InetServService getInetServService() {
        if (this.inetServService == null) {
            this.inetServService = (InetServService)((ClientContext)this.getContext()).getPort(InetServService.class);
        }
        return this.inetServService;
    }

    private InetDeviceService getInetDeviceService() {
        if (this.inetDeviceService == null) {
            this.inetDeviceService = (InetDeviceService)((ClientContext)this.getContext()).getPort(InetDeviceService.class);
        }
        return this.inetDeviceService;
    }

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.setSelectionMode(0);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.setName("table");
        tablePanel.add((Component)BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), "Center");
        this.editor.addForm((JComponent)tablePanel, (Object)"table");
        this.editor.addForm((JComponent)((Object)new TrafficTypeLinkForm()));
        this.add((Component)this.editor, "Center");
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this.editor);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(this.getInetServService().trafficTypeLinkList())));
    }

    private class TrafficTypeLinkTableModel
    extends BGTableModel<TrafficTypeLink> {
        public TrafficTypeLinkTableModel() {
            super(TrafficTypeLinkTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class TrafficTypeLinkForm
    extends BGUPanel {
        private BGTextField title;
        private Map<Integer, TrafficType> trafficTypes;
        private BGUTable linkTable;
        private TrafficTypeLink current;
        private BGEditor linkEditor;
        private TrafficTypeLinkRuleTableModel linkModel;

        public TrafficTypeLinkForm() {
            super((LayoutManager)new GridBagLayout());
            this.linkEditor = new BGEditor();
            this.linkModel = new TrafficTypeLinkRuleTableModel();
        }

        protected void jbInit() {
            BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 ");
            this.title = new BGTextField();
            this.linkTable = new BGUTable((TableModel)((Object)this.linkModel));
            BGDialogToolBar toolBar = new BGDialogToolBar();
            this.linkEditor.setVisible(false);
            this.add(new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.title, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 0, 5, 0), 0, 0));
            this.add((Component)toolBar, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.add(new JScrollPane((Component)this.linkTable), new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.linkEditor, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.linkEditor.addForm((JComponent)((Object)new TrafficTypeLinkRuleForm()));
            BGSwingUtilites.buildToolBar((BGDialogToolBar)toolBar, (JComponent)this.linkEditor);
            toolBar.compact();
            BGSwingUtilites.handleEdit((JTable)this.linkTable, (AbstractBGUPanel)this.linkEditor);
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                this.current = new TrafficTypeLink();
                this.current.setId(-1);
                this.current.setTrafficTypeLinkRuleList(new ArrayList());
                this.title.setText("");
                this.trafficTypes = Id.newMap((List)TrafficTypeLinkPanel.this.getInetServService().trafficTypeList());
                this.linkModel.setData(this.current.getTrafficTypeLinkRuleList());
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                this.current = (TrafficTypeLink)TrafficTypeLinkPanel.this.model.getSelectedRow();
                if (this.current != null) {
                    this.title.setText(this.current.getTitle());
                    this.trafficTypes = Id.newMap((List)TrafficTypeLinkPanel.this.getInetServService().trafficTypeList());
                    this.linkModel.setData(this.current.getTrafficTypeLinkRuleList());
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    TrafficTypeLinkForm.this.current.setTitle(TrafficTypeLinkForm.this.title.getText());
                    TrafficTypeLinkForm.this.current.setTrafficTypeLinkRuleList(TrafficTypeLinkForm.this.linkModel.getRows());
                    int id = TrafficTypeLinkPanel.this.getInetServService().trafficTypeLinkUpdate(TrafficTypeLinkForm.this.current);
                    TrafficTypeLinkForm.this.performActionClose();
                    TrafficTypeLinkPanel.this.performAction("refresh");
                    TrafficTypeLinkPanel.this.model.setSelectedRow(id);
                }
            };
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                this.current = (TrafficTypeLink)TrafficTypeLinkPanel.this.model.getSelectedRow();
                if (this.current != null && BGSwingUtilites.confirmDelete((String)"\u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c", (Object)this.current)) {
                    TrafficTypeLinkPanel.this.getInetServService().trafficTypeLinkDelete(this.current.getId());
                    this.performActionClose();
                    TrafficTypeLinkPanel.this.performAction("refresh");
                }
            });
        }

        class TrafficTypeLinkRuleTableModel
        extends BGTableModel<TrafficTypeLinkRule> {
            public TrafficTypeLinkRuleTableModel() {
                super(TrafficTypeLinkRuleTableModel.class.getName());
            }

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u0422\u0438\u043f", 160, 160, 250, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 160, 160, 250, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u0422\u0438\u043f \u0442\u0440\u0430\u0444\u0438\u043a\u0430", 160, 250, 320, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 160, 250, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            }

            public Object getValue(TrafficTypeLinkRule val, int column) throws BGException {
                switch (column) {
                    case 1: {
                        switch (val.type) {
                            case 1: {
                                return "RADIUS";
                            }
                        }
                        return "\u041a\u043e\u043b\u043b\u0435\u043a\u0442\u043e\u0440";
                    }
                    case 2: {
                        return TimeUtils.formatPeriod((Date)val.dateFrom, (Date)val.dateTo);
                    }
                    case 3: {
                        return Optional.ofNullable(TrafficTypeLinkForm.this.trafficTypes.get(val.trafficTypeId)).map(a -> a.getGuiTitle()).orElse("??? [#" + val.trafficTypeId + "]");
                    }
                }
                return super.getValue((Object)val, column);
            }
        }

        class TrafficTypeLinkRuleForm
        extends BGUPanel {
            private BGControlPanelPeriodNoB period;
            private BGUComboBox<IdTitle> typeCombo;
            private JPanel radiusPanel;
            private JPanel collectorPanel;
            private BGTextField radiusRealm;
            private BGTextField radiusService;
            private IntTextField radiusVendor;
            private IntTextField radiusAttribute;
            private BGTextField radiusPrefix;
            private BGUComboBox<IdTitle> destination;
            private BGUComboBox<InetDevice> source;
            private BGUComboBox<DeviceInterface> iface;
            private IpField ipFrom;
            private IpField ipTo;
            private IntTextField portFrom;
            private IntTextField portTo;
            private BGTextField diffServ;
            private BGUComboBox<TrafficType> trafficType;
            private JTextArea comment;
            private int currentLinkPos;

            public TrafficTypeLinkRuleForm() {
                super((LayoutManager)new GridBagLayout());
                this.currentLinkPos = -1;
            }

            protected void jbInit() {
                BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 ");
                this.period = new BGControlPanelPeriodNoB();
                this.destination = new BGUComboBox();
                this.source = new BGUComboBox(false);
                this.iface = new BGUComboBox();
                this.ipFrom = new IpField();
                this.ipTo = new IpField();
                this.portFrom = new IntTextField();
                this.portTo = new IntTextField();
                this.diffServ = new BGTextField();
                this.trafficType = new BGUComboBox();
                this.comment = new JTextArea();
                ArrayList<IdTitle> data = new ArrayList<IdTitle>();
                data.add(new IdTitle(0, "\u043b\u044e\u0431\u043e\u0435"));
                data.add(new IdTitle(1, "\u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0435\u0435"));
                data.add(new IdTitle(2, "\u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0435"));
                this.destination.setData(data);
                JPanel panel = new JPanel(new GridBagLayout());
                panel.add((Component)this.period, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                JPanel leftPanel = new JPanel(new GridBagLayout());
                this.typeCombo = new BGUComboBox();
                ArrayList<IdTitle> typeData = new ArrayList<IdTitle>();
                typeData.add(new IdTitle(1, "RADIUS"));
                typeData.add(new IdTitle(2, "\u041a\u043e\u043b\u043b\u0435\u043a\u0442\u043e\u0440"));
                this.typeCombo.setData(typeData);
                this.typeCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        switch (((IdTitle)TrafficTypeLinkRuleForm.this.typeCombo.getSelectedItem()).getId()) {
                            case 1: {
                                BGSwingUtilites.setEnabled((Component)TrafficTypeLinkRuleForm.this.collectorPanel, (boolean)false);
                                BGSwingUtilites.setEnabled((Component)TrafficTypeLinkRuleForm.this.radiusPanel, (boolean)true);
                                break;
                            }
                            default: {
                                BGSwingUtilites.setEnabled((Component)TrafficTypeLinkRuleForm.this.radiusPanel, (boolean)false);
                                BGSwingUtilites.setEnabled((Component)TrafficTypeLinkRuleForm.this.collectorPanel, (boolean)true);
                            }
                        }
                    }
                });
                panel.add((Component)this.typeCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
                leftPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)panel, (String)" \u0422\u0438\u043f "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.radiusPanel = panel = new JPanel(new GridBagLayout());
                this.radiusRealm = new BGTextField();
                this.radiusService = new BGTextField();
                this.radiusVendor = new IntTextField();
                this.radiusVendor.setMinValue(-2L);
                this.radiusAttribute = new IntTextField();
                this.radiusPrefix = new BGTextField();
                panel.add((Component)new JLabel("\u0420\u0435\u0430\u043b\u043c:"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 5), 0, 0));
                panel.add((Component)this.radiusRealm, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 3, 5), 0, 0));
                panel.add((Component)new JLabel("ServiceName:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
                panel.add((Component)this.radiusService, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
                panel.add((Component)new JLabel("\u041a\u043e\u0434 \u0432\u0435\u043d\u0434\u043e\u0440\u0430:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 5), 0, 0));
                panel.add((Component)this.radiusVendor, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 3, 5), 0, 0));
                panel.add((Component)new JLabel("\u041a\u043e\u0434 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430:"), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 5), 0, 0));
                panel.add((Component)this.radiusAttribute, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 3, 5), 0, 0));
                panel.add((Component)new JLabel("\u041f\u0440\u0435\u0444\u0438\u043a\u0441:"), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
                panel.add((Component)this.radiusPrefix, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
                leftPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)panel, (String)" RADIUS "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.collectorPanel = panel = new JPanel(new GridBagLayout());
                panel.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 5), 0, 0));
                panel.add((Component)this.destination, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 3, 5), 0, 0));
                panel.add((Component)new JLabel("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 5), 0, 0));
                JPanel ipPanel = new JPanel(new GridBagLayout());
                ipPanel.add((Component)this.ipFrom, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                ipPanel.add((Component)new JLabel("-"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                ipPanel.add((Component)this.ipTo, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                panel.add((Component)ipPanel, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
                panel.add((Component)new JLabel("DiffServ/ToS:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 5), 0, 0));
                panel.add((Component)this.diffServ, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 3, 5), 0, 0));
                panel.add((Component)new JLabel("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043f\u043e\u0440\u0442\u043e\u0432:"), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 5), 0, 0));
                JPanel portPanel = new JPanel(new GridBagLayout());
                portPanel.add((Component)this.portFrom, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                portPanel.add((Component)new JLabel("-"), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                portPanel.add((Component)this.portTo, new GridBagConstraints(2, 3, 1, 1, 0.5, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                panel.add((Component)portPanel, new GridBagConstraints(1, 3, 3, 1, 0.5, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
                JPanel sourcePanel = new JPanel(new GridBagLayout());
                sourcePanel.add((Component)new JLabel("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 5), 0, 0));
                sourcePanel.add((Component)this.source, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
                sourcePanel.add((Component)new JLabel("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
                sourcePanel.add((Component)this.iface, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                panel.add((Component)sourcePanel, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
                leftPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)panel, (String)" \u041a\u043e\u043b\u043b\u0435\u043a\u0442\u043e\u0440 "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                panel = new JPanel(new GridBagLayout());
                panel.add((Component)this.trafficType, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                leftPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)panel, (String)" \u0422\u0438\u043f \u0442\u0440\u0430\u0444\u0438\u043a\u0430 "), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                panel = new JPanel(new GridBagLayout());
                panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
                panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add(leftPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add(panel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
                BGSwingUtilites.setEnabled((Component)this.collectorPanel, (boolean)false);
                this.source.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            InetDevice device = (InetDevice)TrafficTypeLinkRuleForm.this.source.getSelectedItem();
                            List ifaceList = device.getId() > 0 ? ((DeviceInterfaceService)((ClientContext)TrafficTypeLinkRuleForm.this.getContext()).getPort(DeviceInterfaceService.class)).devicePortList(device.getInvDeviceId(), false) : new ArrayList();
                            DeviceInterface any = new DeviceInterface();
                            any.setPort(-1);
                            any.setTitle("\u043b\u044e\u0431\u043e\u0439 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
                            ifaceList.add(0, any);
                            DeviceInterface serv = new DeviceInterface();
                            serv.setPort(-2);
                            serv.setTitle("\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u0441\u0435\u0440\u0432\u0438\u0441\u0430");
                            ifaceList.add(1, serv);
                            if (ifaceList.size() > 2) {
                                DeviceInterface separator = new DeviceInterface();
                                separator.setPort(-1);
                                separator.setTitle("-----");
                                ifaceList.add(2, separator);
                            }
                            TrafficTypeLinkRuleForm.this.iface.setData(ifaceList);
                        }
                        catch (BGException ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                });
            }

            protected void initActions() {
                new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                    List souceList = TrafficTypeLinkPanel.this.getInetDeviceService().deviceSourceList();
                    InetDevice anySource = new InetDevice();
                    anySource.setId(0);
                    anySource.setTitle("\u043b\u044e\u0431\u043e\u0439");
                    souceList.add(0, anySource);
                    if (souceList.size() > 1) {
                        InetDevice separator = new InetDevice();
                        separator.setId(0);
                        separator.setTitle("-----");
                        souceList.add(1, separator);
                    }
                    this.source.setData(souceList);
                    List trafficTypeList = TrafficTypeLinkPanel.this.getInetServService().trafficTypeList();
                    trafficTypeList.remove(TrafficType.TIME);
                    TrafficType trafficTypeNull = new TrafficType(-1000, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0442\u0440\u0430\u0444\u0438\u043a\u0430...", 0);
                    trafficTypeList.add(0, trafficTypeNull);
                    this.trafficType.setData(trafficTypeList);
                    this.currentLinkPos = -1;
                    this.clearFields();
                    this.performActionOpen();
                });
                new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                    List souceList = TrafficTypeLinkPanel.this.getInetDeviceService().deviceSourceList();
                    InetDevice anySource = new InetDevice();
                    anySource.setId(0);
                    anySource.setTitle("\u043b\u044e\u0431\u043e\u0439");
                    souceList.add(0, anySource);
                    if (souceList.size() > 1) {
                        InetDevice separator = new InetDevice();
                        separator.setId(0);
                        separator.setTitle("-----");
                        souceList.add(1, separator);
                    }
                    this.source.setData(souceList);
                    List trafficTypeList = TrafficTypeLinkPanel.this.getInetServService().trafficTypeList();
                    trafficTypeList.remove(TrafficType.TIME);
                    TrafficType trafficTypeNull = new TrafficType(-1000, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0442\u0440\u0430\u0444\u0438\u043a\u0430...", 0);
                    trafficTypeList.add(0, trafficTypeNull);
                    this.trafficType.setData(trafficTypeList);
                    this.clearFields();
                    this.currentLinkPos = TrafficTypeLinkForm.this.linkTable.getSelectedRow();
                    TrafficTypeLinkRule current = (TrafficTypeLinkRule)TrafficTypeLinkForm.this.linkModel.getSelectedRow();
                    if (current == null) {
                        return;
                    }
                    this.typeCombo.setSelectedItem((Object)current.type);
                    if (current.type == 1) {
                        this.radiusRealm.setText(Utils.maskNull((String)current.counterRealm));
                        this.radiusService.setText(Utils.maskNull((String)current.counterService));
                        this.radiusVendor.setValue((long)current.counterVendor);
                        this.radiusAttribute.setValue((long)current.counterType);
                        this.radiusPrefix.setText(current.counterPrefix);
                    } else {
                        this.destination.setSelectedItem((Object)current.direction);
                        if (current.addressFrom != null && current.addressFrom.address != null) {
                            this.ipFrom.setText(current.addressFrom.toString());
                        } else {
                            this.ipFrom.setText("");
                        }
                        if (current.addressTo != null && current.addressFrom.address != null) {
                            this.ipTo.setText(current.addressTo.toString());
                        } else {
                            this.ipTo.setText("");
                        }
                        this.portFrom.setValue((long)current.portFrom);
                        this.portTo.setValue((long)current.portTo);
                        this.diffServ.setText(current.diffServString);
                        this.source.setSelectedItem((Object)current.sourceId);
                        DeviceInterface selectedIface = new DeviceInterface();
                        selectedIface.setDeviceId(current.sourceId);
                        selectedIface.setPort(current.interfaceId);
                        this.iface.setSelectedItem((Object)selectedIface);
                    }
                    this.trafficType.setSelectedItem((Object)current.trafficTypeId);
                    this.period.setDateCalendar1(TimeUtils.convertDateToCalendar((Date)current.dateFrom));
                    this.period.setDateCalendar2(TimeUtils.convertDateToCalendar((Date)current.dateTo));
                    this.comment.setText(current.getComment());
                    this.performActionOpen();
                });
                new AbstractBGUPanel.DefaultAction("ok", "Ok"){

                    public void actionPerformedImpl(ActionEvent e) throws Exception {
                        TrafficTypeLinkRule rule;
                        if (TrafficTypeLinkRuleForm.this.trafficType.getSelectedItem() == null) {
                            BGSwingUtilites.error((String)"\u0417\u0430\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0438\u043f\u044b \u0442\u0440\u0430\u0444\u0438\u043a\u0430!");
                            return;
                        }
                        if (((TrafficType)TrafficTypeLinkRuleForm.this.trafficType.getSelectedItem()).getId() == -1000) {
                            BGSwingUtilites.error((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0442\u0440\u0430\u0444\u0438\u043a\u0430!");
                            return;
                        }
                        int type = ((IdTitle)TrafficTypeLinkRuleForm.this.typeCombo.getSelectedItem()).getId();
                        Date dateFrom = TrafficTypeLinkRuleForm.this.period.getDateFrom();
                        Date dateTo = TrafficTypeLinkRuleForm.this.period.getDateTo();
                        int trafficType = ((TrafficType)TrafficTypeLinkRuleForm.this.trafficType.getSelectedItem()).getId();
                        String comment = TrafficTypeLinkRuleForm.this.comment.getText();
                        if (type == 1) {
                            Pattern patternPattern;
                            Matcher m;
                            String counterRealm = TrafficTypeLinkRuleForm.this.radiusRealm.getText().trim();
                            String counterService = TrafficTypeLinkRuleForm.this.radiusService.getText().trim();
                            int counterVendor = (int)TrafficTypeLinkRuleForm.this.radiusVendor.getValue();
                            int counterType = (int)TrafficTypeLinkRuleForm.this.radiusAttribute.getValue();
                            String counterPrefix = TrafficTypeLinkRuleForm.this.radiusPrefix.getText();
                            if (Utils.notBlankString((String)counterService) && (m = (patternPattern = Pattern.compile("^\\s*/(.+)/\\s*$")).matcher(counterService)).matches()) {
                                try {
                                    Pattern.compile(m.group(1));
                                }
                                catch (PatternSyntaxException ex) {
                                    throw new BGMessageException(ex.getMessage());
                                }
                            }
                            rule = new TrafficTypeLinkRule(dateFrom, dateTo, counterRealm, counterService, counterVendor, counterType, counterPrefix, trafficType, comment);
                        } else {
                            int sourceId = ((InetDevice)TrafficTypeLinkRuleForm.this.source.getSelectedItem()).getId();
                            int interfaceId = ((DeviceInterface)TrafficTypeLinkRuleForm.this.iface.getSelectedItem()).getPort();
                            int direction = ((IdTitle)TrafficTypeLinkRuleForm.this.destination.getSelectedItem()).getId();
                            IpAddress addressFrom = TrafficTypeLinkRuleForm.this.ipFrom.getAddress();
                            IpAddress addressTo = TrafficTypeLinkRuleForm.this.ipTo.getAddress();
                            if (addressFrom == null || addressTo == null) {
                                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0438\u043b\u0438 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0435 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432");
                                return;
                            }
                            int portFrom = (int)TrafficTypeLinkRuleForm.this.portFrom.getValue();
                            int portTo = (int)TrafficTypeLinkRuleForm.this.portTo.getValue();
                            String diffServString = TrafficTypeLinkRuleForm.this.diffServ.getText();
                            rule = new TrafficTypeLinkRule(dateFrom, dateTo, sourceId, interfaceId, direction, addressFrom, addressTo, portFrom, portTo, diffServString, trafficType, comment);
                        }
                        if (TrafficTypeLinkRuleForm.this.currentLinkPos >= 0) {
                            rule.setId(TrafficTypeLinkForm.this.linkModel.getSelectedRow() != null ? ((TrafficTypeLinkRule)TrafficTypeLinkForm.this.linkModel.getSelectedRow()).getId() : 0);
                            TrafficTypeLinkForm.this.linkModel.setRow(TrafficTypeLinkRuleForm.this.currentLinkPos, rule);
                        } else {
                            TrafficTypeLinkForm.this.linkModel.addRow(rule);
                        }
                        TrafficTypeLinkRuleForm.this.performActionClose();
                    }
                };
                new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                    TrafficTypeLinkForm.this.linkModel.deleteSelectedRows();
                    this.performActionClose();
                });
                new AbstractBGUPanel.DefaultAction("move_up", "\u0412\u0432\u0435\u0440\u0445"){

                    public void actionPerformedImpl(ActionEvent e) throws Exception {
                        if (TrafficTypeLinkForm.this.linkModel.getSelectedRow() != null) {
                            TrafficTypeLinkForm.this.linkModel.upSelectedRow();
                        }
                    }
                };
                new AbstractBGUPanel.DefaultAction("move_down", "\u0412\u043d\u0438\u0437"){

                    public void actionPerformedImpl(ActionEvent e) throws Exception {
                        if (TrafficTypeLinkForm.this.linkModel.getSelectedRow() != null) {
                            TrafficTypeLinkForm.this.linkModel.downSelectedRow();
                        }
                    }
                };
            }

            protected void clearFields() {
                this.radiusService.setText("");
                this.radiusVendor.setText("");
                this.radiusAttribute.setText("");
                this.radiusPrefix.setText("");
                this.ipFrom.setText("");
                this.ipTo.setText("");
                this.portFrom.setText("");
                this.portTo.setText("");
                this.diffServ.setText("");
            }
        }
    }
}

