/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action.web;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;

public class ActionDownloadTopic
extends ActionBase {
    public void doAction() throws BGException {
        Topic topic = new TopicManager(this.con, this.plugin).getTopic(this.getIntParameter("id", -1));
        if (topic.getContractId() == this.cid) {
            StringBuilder topicData = new StringBuilder();
            topicData.append("\u0422\u0435\u043c\u0430: ");
            topicData.append(topic.getTitle());
            String lineSeparator = System.getProperty("line.separator");
            topicData.append(lineSeparator);
            DateFormat df = DateFormat.getDateTimeInstance(2, 2);
            int k = 1;
            List messageList = topic.getMessages();
            for (Message m : messageList) {
                String[] lines = m.getBody().split(lineSeparator);
                for (int i = 0; i < lines.length; ++i) {
                    if (k < 0) {
                        topicData.append("\t");
                    }
                    if (i == 0) {
                        topicData.append("[ ");
                        topicData.append(df.format(m.getDateFrom().getTime()));
                        topicData.append(" ] ");
                    }
                    topicData.append(lines[i]);
                    topicData.append(lineSeparator);
                }
                k = (byte)(k * -1);
            }
            this.request.setAttribute("contentType", (Object)"binary");
            String contentType = "application/txt;charset=UTF-8";
            this.response.setContentType(contentType);
            this.response.setHeader("Content-Disposition", "attachment;filename=\"topic" + topic.getId() + ".log");
            try {
                ServletOutputStream responseStream = this.response.getOutputStream();
                responseStream.write(topicData.toString().getBytes());
                responseStream.flush();
                responseStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

