/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.hd.server.bean.Zone;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ZoneManager {
    private Connection con;
    private String tableName;

    public ZoneManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "hd_zone_" + mid;
    }

    public List<Zone> getZoneList(boolean hostOnly, boolean domainOnly) {
        ArrayList<Zone> result = new ArrayList<Zone>();
        try {
            String query = "SELECT * FROM " + this.tableName;
            if (hostOnly) {
                query = query + " WHERE host ";
            } else if (domainOnly) {
                query = query + " WHERE domain ";
            }
            query = query + " ORDER BY name";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getZoneFromRs(rs));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Zone getZone(int id) {
        Zone result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getZoneFromRs(rs);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Zone getZoneFromRs(ResultSet rs) throws SQLException {
        Zone result = new Zone();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setDomain(rs.getBoolean("domain"));
        result.setHost(rs.getBoolean("host"));
        result.setMasterNsId(rs.getInt("ns_id"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    public void updateZone(Zone zone) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (zone.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (name, domain, host, ns_id, comment) VALUES (?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query);
            } else {
                query = "UPDATE " + this.tableName + " SET name=?, domain=?, host=?, ns_id=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(6, zone.getId());
            }
            ps.setString(1, zone.getName());
            ps.setBoolean(2, zone.isDomain());
            ps.setBoolean(3, zone.isHost());
            ps.setInt(4, zone.getMasterNsId());
            ps.setString(5, zone.getComment());
            ps.executeUpdate();
            if (zone.getId() <= 0) {
                zone.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteZone(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

