/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.hd.client.DnsZoneEditor;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;

public class ServicePropertiesPanel
extends ServicePanel {
    private DNSTableModel dnsTableModel = new DNSTableModel();
    private HostTableModel hostingTableModel = new HostTableModel();
    private BGTabbedPane tabbedPane = new BGTabbedPane();
    private CardLayout dnsCardLayout = new CardLayout();
    private CardLayout hostingCardLayout = new CardLayout();
    private JPanel dnsPanel = new JPanel(this.dnsCardLayout);
    private JPanel hostingPanel = new JPanel(this.hostingCardLayout);
    private DnsZoneEditor zoneEditor = new DnsZoneEditor();

    public ServicePropertiesPanel() {
        this.jbInit();
    }

    private void jbInit() {
        BGUTable dnsTable = new BGUTable((TableModel)((Object)this.dnsTableModel));
        dnsTable.setSelectionMode(0);
        dnsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServicePropertiesPanel.this.editItem();
                }
            }
        });
        BGUTable hostingTable = new BGUTable((TableModel)((Object)this.hostingTableModel));
        hostingTable.setSelectionMode(0);
        this.dnsPanel.add((Component)new JScrollPane((Component)dnsTable), "table");
        this.dnsPanel.add((Component)((Object)this.zoneEditor), "editor");
        this.hostingPanel.add((Component)new JScrollPane((Component)hostingTable), "table");
        this.tabbedPane.add("\u0414\u041d\u0421", (Component)this.dnsPanel);
        this.tabbedPane.add("\u0425\u043e\u0441\u0442\u0438\u043d\u0433", (Component)this.hostingPanel);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void init(int cid, int mid) {
        super.init(cid, mid);
        this.zoneEditor.init(this.module, mid);
        this.zoneEditor.setContractId(cid);
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        ArrayList dataRows = new ArrayList();
        if (this.tabbedPane.getSelectedIndex() == 0) {
            request.setAction("GetContractZoneTable");
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                for (Element rowElement : XMLUtils.selectElements((Node)doc, (String)"//table/data/row")) {
                    HashMap<String, Object> rowMap = new HashMap<String, Object>();
                    rowMap.put("id", Utils.parseInt((String)rowElement.getAttribute("id")));
                    rowMap.put("zone", rowElement.getAttribute("zone"));
                    rowMap.put("period", rowElement.getAttribute("period"));
                    rowMap.put("comment", rowElement.getAttribute("comment"));
                    dataRows.add(rowMap);
                }
                this.dnsTableModel.setData(dataRows);
            }
        } else if (this.tabbedPane.getSelectedIndex() == 1) {
            request.setAction("GetContractHostTable");
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                for (Element rowElement : XMLUtils.selectElements((Node)doc, (String)"//table/data/row")) {
                    HashMap<String, Object> rowMap = new HashMap<String, Object>();
                    rowMap.put("id", Utils.parseInt((String)rowElement.getAttribute("id")));
                    rowMap.put("title", rowElement.getAttribute("title"));
                    rowMap.put("type", rowElement.getAttribute("type"));
                    rowMap.put("period", rowElement.getAttribute("period"));
                    rowMap.put("comment", rowElement.getAttribute("comment"));
                    dataRows.add(rowMap);
                }
                this.hostingTableModel.setData(dataRows);
            }
        }
    }

    public void newItem() {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            this.zoneEditor.setId(String.valueOf(0));
            this.zoneEditor.setData();
            this.dnsCardLayout.show(this.dnsPanel, "editor");
            this.zoneEditor.setTabbedPaneIndex(0);
        } else if (this.tabbedPane.getSelectedIndex() == 1) {
            this.hostingCardLayout.show(this.hostingPanel, "editor");
        }
    }

    public void editItem() {
        Map rowMap = null;
        if (this.tabbedPane.getSelectedIndex() == 0) {
            rowMap = (Map)this.dnsTableModel.getSelectedRow();
        } else if (this.tabbedPane.getSelectedIndex() == 1) {
            rowMap = (Map)this.hostingTableModel.getSelectedRow();
        }
        if (rowMap != null) {
            this.id = ((Integer)rowMap.get("id")).toString();
            if (this.id == null) {
                return;
            }
        }
        if (this.tabbedPane.getSelectedIndex() == 0) {
            this.zoneEditor.setId(this.id);
            this.zoneEditor.initEditor();
            this.zoneEditor.setData();
            this.dnsCardLayout.show(this.dnsPanel, "editor");
            this.zoneEditor.setTabbedPaneIndex(0);
        } else if (this.tabbedPane.getSelectedIndex() == 1) {
            this.hostingCardLayout.show(this.hostingPanel, "editor");
        }
    }

    public void deleteItem() {
        Map rowMap = null;
        if (this.tabbedPane.getSelectedIndex() == 0) {
            rowMap = (Map)this.dnsTableModel.getSelectedRow();
            if (rowMap == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043e\u043d\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                Request request = new Request();
                request.setModule(this.module);
                request.setAction("DeleteZone");
                request.setModuleId(this.getModuleId());
                request.setAttribute("id", rowMap.get("id"));
                if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                    this.setData();
                }
            }
        }
    }

    class DNSTableModel
    extends BGTableModel<Map<String, Object>> {
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_ZONE = "zone";
        public static final String COLUMN_PERIOD = "period";
        public static final String COLUMN_COMMENT = "comment";

        public DNSTableModel() {
            super("hdContractDNSRecord");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0417\u043e\u043d\u0430", 50, 120, -1, COLUMN_ZONE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, COLUMN_PERIOD, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, COLUMN_COMMENT, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }
    }

    class HostTableModel
    extends BGTableModel<Map<String, Object>> {
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_TYPE = "type";
        public static final String COLUMN_PERIOD = "period";
        public static final String COLUMN_COMMENT = "comment";

        public HostTableModel() {
            super("hdContractHostRecord");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 120, 120, -1, COLUMN_TITLE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0422\u0438\u043f", 120, 120, -1, COLUMN_TYPE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, COLUMN_PERIOD, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, COLUMN_COMMENT, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }
    }
}

