/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.service;

import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.House;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.Street;
import ru.bitel.bgbilling.plugins.fias.common.service.FiasHouseService;
import ru.bitel.bgbilling.plugins.fias.server.bean.HouseLoadManager;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.fias.common.service.FiasHouseService")
public class FiasHouseServiceImpl
extends AbstractService
implements FiasHouseService {
    static final int STATUS_IN_PROCESS = 0;
    static final int STATUS_OK = 1;
    static final int STATUS_FREE = -1;

    public Result<House> startHouseSync(House house, boolean start, boolean addHouse) throws BGMessageException, BGException {
        Result result = new Result();
        Connection con = this.getConnection();
        HouseLoadManager hm = new HouseLoadManager(con);
        result.setAttribute("streetCount", (Object)hm.getStreetCountWithoutSync());
        int streetId = -1;
        if (start) {
            Street street = hm.getNonSyncStreet();
            if (street.getId() == -1) {
                result.setAttribute("endOfStreet", (Object)"true");
                return result;
            }
            streetId = street.getId();
            hm.createNewTempTable(street);
            hm.updateStreetStatus(streetId, 0);
        } else if (house != null) {
            hm.updateHouse(house);
            streetId = house.getStreetId();
        }
        List<House> find = null;
        House nextHouse = null;
        while (true) {
            if ((nextHouse = hm.getNextHouse(streetId)) == null) {
                if (addHouse) {
                    hm.addAllHouse();
                }
                hm.updateStreetStatus(streetId, 1);
                result.setAttribute("house", null);
                try {
                    con.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return result;
            }
            find = hm.findHouseInFias(nextHouse);
            if (find.size() != 1) break;
            House fiasHouse = find.get(0);
            nextHouse.setHouse(fiasHouse);
            hm.updateHouse(nextHouse);
        }
        result.setList(find);
        result.setAttribute("house", (Object)nextHouse);
        return result;
    }
}

