/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgent;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgentStatus;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebTariff;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebTariffDAO;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class DrwebAgentDAO
extends AbstractIdDao<DrwebAgent> {
    private String statusTableName = null;
    private Map<Integer, DrwebTariff> tariffMap = null;

    public DrwebAgentDAO(Connection con, int mid) {
        super(con, mid, "drweb_contract_agent");
        this.statusTableName = this.getTableName("drweb_contract_agent_status", mid, null);
        try (DrwebTariffDAO tariffManager = new DrwebTariffDAO(con, mid);){
            this.tariffMap = tariffManager.getTariffMap();
        }
        catch (BGException e) {
            this.getLogger().error((Object)e);
        }
    }

    protected DrwebAgent getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, "");
    }

    private DrwebAgent getFromRS(ResultSet rs, String prefix) throws SQLException {
        prefix = Utils.isEmptyString((String)prefix) ? "" : (String)prefix + ".";
        DrwebAgent result = new DrwebAgent();
        result.setId(rs.getInt((String)prefix + "id"));
        result.setCid(rs.getInt((String)prefix + "cid"));
        result.setAgentUUID(rs.getString((String)prefix + "agent_uuid"));
        result.setName(rs.getString((String)prefix + "description"));
        result.setStatus(rs.getInt((String)prefix + "status"));
        result.setTariffId(rs.getInt((String)prefix + "tariff_id"));
        result.setStatusDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp((String)prefix + "status_date")));
        result.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp((String)prefix + "date_from")));
        result.setTariffTitle(this.tariffMap.get(result.getTariffId()).getTitle());
        return result;
    }

    protected void newAgent(DrwebAgent agent) throws BGException {
        try {
            int id;
            PreparedStatement ps;
            if (agent.getId() <= 0) {
                ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (cid, agent_uuid, description, status , tariff_id, date_from,status_date) VALUES (?, ?, ?, ?, ?, ?, ? )", 1);
                int index = 1;
                ps.setInt(index++, agent.getCid());
                ps.setString(index++, agent.getAgentUUID());
                ps.setString(index++, agent.getName());
                ps.setInt(index++, agent.getStatus());
                ps.setInt(index++, agent.getTariffId());
                Timestamp dt = TimeUtils.convertDateToTimestampSeconds((Date)new Date());
                ps.setTimestamp(index++, dt);
                ps.setTimestamp(index++, dt);
                ps.executeUpdate();
                id = -1;
                ResultSet rs = ps.getGeneratedKeys();
                if (rs.last()) {
                    id = rs.getInt(1);
                }
            } else {
                throw new BGException("DrwebAgent not editable.. ");
            }
            agent.setId(id);
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void updateAgentState(int id, int status) throws BGException {
        String query = "UPDATE " + this.tableName + " SET status=?, status_date=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, status);
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            ps.setInt(index++, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected void updateImpl(DrwebAgent agent) throws BGException, SQLException {
        throw new BGException("DrwebAgent not editable.. ");
    }

    public List<DrwebAgent> getAgentListByCid(int cid) throws BGException {
        return super.list("cid=?", null, new Object[]{cid});
    }

    public List<DrwebAgent> getAgentListAll() throws BGException {
        return super.list(null, null, new Object[0]);
    }

    protected int getAgentCount(int cid) throws BGException, SQLException {
        int res = 0;
        PreparedStatement ps = this.con.prepareStatement("SELECT count(*) FROM " + this.tableName + " WHERE cid =?");
        int index = 1;
        ps.setInt(index++, cid);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            res = rs.getInt(1);
        }
        rs.close();
        ps.close();
        return res;
    }

    public int getActualAgentCount(int cid) throws BGException {
        int res = 0;
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT count(*) FROM " + this.tableName + " WHERE cid =? AND status <>3");
            int index = 1;
            ps.setInt(index++, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                res = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            this.getLogger().error((Object)e);
        }
        return res;
    }

    private DrwebAgentStatus getAgentStatusFromRs(ResultSet rs) throws SQLException {
        DrwebAgentStatus status = new DrwebAgentStatus();
        status.setId(rs.getInt("st.id"));
        status.setDt(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("st.dt")));
        status.setAgentId(rs.getInt("st.agent_id"));
        status.setStatus(rs.getInt("st.status"));
        status.setStatusDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("st.status_date")));
        status.setTariffId(rs.getInt("st.tariff_id"));
        status.setTariffTitle(this.tariffMap.get(status.getTariffId()).getTitle());
        status.setUserId(rs.getInt("st.user_id"));
        return status;
    }

    public List<DrwebAgentStatus> getStatusList(int agentId) throws SQLException {
        ArrayList<DrwebAgentStatus> list = new ArrayList<DrwebAgentStatus>();
        PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.statusTableName + " AS st WHERE agent_id =? order by status_date , id");
        int index = 1;
        ps.setInt(index++, agentId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            DrwebAgentStatus log = this.getAgentStatusFromRs(rs);
            list.add(log);
        }
        rs.close();
        ps.close();
        return list;
    }

    public void updateStatus(DrwebAgentStatus status, int userId, boolean rewrite) throws BGException {
        try {
            if (rewrite) {
                try (Statement st = this.con.createStatement();){
                    st.executeUpdate("DELETE FROM " + this.statusTableName + " WHERE status_date >= '" + TimeUtils.formatSQLDate((Date)status.getStatusDate()) + "'");
                }
            }
            String query = "INSERT INTO " + this.statusTableName + " (dt,agent_id, status, status_date, tariff_id,  user_id) VALUES (?, ?, ?, ?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            int index = 1;
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)status.getDt()));
            ps.setInt(index++, status.getAgentId());
            ps.setInt(index++, status.getStatus());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)status.getStatusDate()));
            ps.setInt(index++, status.getTariffId());
            ps.setInt(index++, status.getUserId());
            ps.executeUpdate();
            if (status.getId() <= 0) {
                status.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            this.getLogger().error((Object)e);
            throw new BGException();
        }
    }

    public List<AgentDayItem> getActualAgent(Calendar day) throws SQLException {
        ArrayList<AgentDayItem> result = new ArrayList<AgentDayItem>();
        PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " AS agentt LEFT JOIN " + this.statusTableName + " AS st ON agentt.id = st.agent_id AND agentt.status IN (1,3) AND st.status_date >= CURDATE()  AND st.status_date < (CURDATE() +1)WHERE agentt.status =1 OR st.id IS NOT NULL");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            AgentDayItem item = new AgentDayItem();
            item.agent = this.getFromRS(rs, "agentt");
            item.status = this.getAgentStatusFromRs(rs);
            result.add(item);
        }
        rs.close();
        ps.close();
        return result;
    }

    public class AgentDayItem {
        public DrwebAgent agent;
        public DrwebAgentStatus status;
    }
}

