/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class RejectToAccept {
    private static RejectToAccept rejectToAccept = null;
    private static final Logger log = LogManager.getLogger((String)"processor");
    private Set<Integer> nases = new HashSet<Integer>();
    private String rejectToAcceptTableName;
    private ThreadPoolExecutor pool;

    public static void initRejectToAccept(int moduleId) {
        if (rejectToAccept != null) {
            rejectToAccept.correctStop();
        }
        rejectToAccept = new RejectToAccept(moduleId);
    }

    public static RejectToAccept getRejectToAccept() {
        return rejectToAccept;
    }

    private RejectToAccept(int moduleId) {
        ModuleSetup setup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        ParameterMap records = setup.sub("reject_to_accept.");
        for (Map.Entry me : records.entrySet()) {
            String key = (String)me.getKey();
            String value = (String)me.getValue();
            if (key.equals("nas")) {
                StringTokenizer st = new StringTokenizer(value, ",");
                while (st.hasMoreTokens()) {
                    int code = Utils.parseInt((String)st.nextToken().trim());
                    this.nases.add(code);
                }
                continue;
            }
            if (!key.equals("db.write") || !value.equals("1")) continue;
            this.rejectToAcceptTableName = "dialup_reject_to_accept_" + moduleId;
            this.pool = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
    }

    public void correctStop() {
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    public boolean modifyResponse(int errorCode, RadiusPacket packet, DialUpNas nasInfo) {
        String attributes;
        boolean result = false;
        if (packet.getCode() == 3 && (this.nases.size() == 0 || this.nases.contains(nasInfo.getId())) && Utils.notBlankString((String)(attributes = nasInfo.getRejectToAcceptErrorAtributes().get(errorCode)))) {
            packet.setCode((byte)2);
            packet.addAttributes(RadiusAttributeSet.newRadiusAttributeSet((String)attributes));
            result = true;
        }
        return result;
    }

    public void insertErrorInBase(final int cid, final int errorCode, final RadiusPacket packet) {
        if (Utils.notBlankString((String)this.rejectToAcceptTableName)) {
            Runnable insertThread = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Connection con = Setup.getSetup().getDBTrashOrMasterConnectionFromPool(RejectToAccept.this.rejectToAcceptTableName);
                    try {
                        if (!ServerUtils.tableExists((Connection)con, (String)RejectToAccept.this.rejectToAcceptTableName)) {
                            String query = "CREATE TABLE IF NOT EXISTS " + RejectToAccept.this.rejectToAcceptTableName + " (time TIMESTAMP,ip BIGINT NOT NULL, cid INT NOT NULL,code INT NOT NULL, params VARCHAR(250) NOT NULL,UNIQUE(ip),KEY time(time) ) ENGINE=Memory";
                            Statement st = con.createStatement();
                            st.executeUpdate(query);
                            st.close();
                        }
                        int timeOut = packet.getIntAttribute(-1, 27, Integer.valueOf(0));
                        long ipAddress = Utils.unsignedIntToLong((int)packet.getIntAttribute(-1, 8, Integer.valueOf(0)));
                        if (timeOut > 0 && ipAddress > 0L) {
                            String query = "UPDATE " + RejectToAccept.this.rejectToAcceptTableName + " SET cid=?, code=? WHERE ip=?";
                            PreparedStatement psUpdate = con.prepareStatement(query);
                            psUpdate.setInt(1, cid);
                            psUpdate.setInt(2, errorCode);
                            psUpdate.setLong(3, ipAddress);
                            if (psUpdate.executeUpdate() == 0) {
                                query = "INSERT INTO " + RejectToAccept.this.rejectToAcceptTableName + " (ip, cid, code, params) VALUES (?, ?, ?, '')";
                                PreparedStatement psInsert = con.prepareStatement(query);
                                psInsert.setLong(1, ipAddress);
                                psInsert.setInt(2, cid);
                                psInsert.setInt(3, errorCode);
                                psInsert.executeUpdate();
                                psInsert.close();
                            }
                            psUpdate.close();
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        ServerUtils.closeConnection((Connection)con);
                    }
                }
            };
            this.pool.execute(insertThread);
        }
    }
}

