/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import bitel.billing.server.call.bean.Login;
import bitel.billing.server.call.bean.Session;
import bitel.billing.server.call.bean.busevent.LoginChangedEvent;
import bitel.billing.server.call.bean.busevent.LoginDeleteEvent;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.tariff.TariffModuleTree;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedTopicEvent;
import ru.bitel.bgbilling.kernel.event.events.system.SystemLimitChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.ContractTariffOptionChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.modules.dialup.server.event.bus.DialUpLoginIpChangedEvent;
import ru.bitel.bgbilling.modules.dialup.server.event.bus.DialupSessionBreakEvent;
import ru.bitel.bgbilling.modules.dialup.server.event.bus.DialupSessionDropEvent;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpRadiusProcessor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class EventBusListener {
    private static final Logger log = LogManager.getLogger();
    private DialUpRadiusProcessor processor;
    private final int moduleId;
    private final StatusCache statusCache = StatusCache.getInstance();

    public EventBusListener(DialUpRadiusProcessor processor, int moduleId) throws BGException {
        this.processor = processor;
        this.moduleId = moduleId;
        EventProcessor.getInstance().addListener((EventListener)new EventListener<DialupSessionBreakEvent>(){

            public void notify(DialupSessionBreakEvent e, EventListenerContext ctx) {
                EventBusListener.this.breakSession(e);
            }
        }, DialupSessionBreakEvent.class, moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<DialupSessionDropEvent>(){

            public void notify(DialupSessionDropEvent e, EventListenerContext ctx) {
                EventBusListener.this.dropSession(e);
            }
        }, DialupSessionDropEvent.class, moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<LoginDeleteEvent>(){

            public void notify(LoginDeleteEvent e, EventListenerContext ctx) {
                EventBusListener.this.loginRemoved(e);
            }
        }, LoginDeleteEvent.class, moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<LoginChangedEvent>(){

            public void notify(LoginChangedEvent e, EventListenerContext ctx) {
                EventBusListener.this.loginChanged(e);
            }
        }, LoginChangedEvent.class, moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<DialUpLoginIpChangedEvent>(){

            public void notify(DialUpLoginIpChangedEvent e, EventListenerContext ctx) {
                EventBusListener.this.loginIpsChanged(e);
            }
        }, DialUpLoginIpChangedEvent.class, moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<SystemLimitChangedEvent>(){

            public void notify(SystemLimitChangedEvent e, EventListenerContext ctx) {
                EventBusListener.this.changeLimit(e);
            }
        }, SystemLimitChangedEvent.class);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<ContractStatusChangedTopicEvent>(){

            public void notify(ContractStatusChangedTopicEvent e, EventListenerContext ctx) {
                EventBusListener.this.statusChanged(e);
            }
        }, ContractStatusChangedTopicEvent.class);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<ContractTariffChangedEvent>(){

            public void notify(ContractTariffChangedEvent e, EventListenerContext ctx) {
                EventBusListener.this.tariffChanged(e);
            }
        }, ContractTariffChangedEvent.class);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<ContractTariffOptionChangedEvent>(){

            public void notify(ContractTariffOptionChangedEvent e, EventListenerContext ctx) {
                EventBusListener.this.tariffOptionChanged((Event)e);
            }
        }, ContractTariffOptionChangedEvent.class);
    }

    private void loginRemoved(final LoginDeleteEvent delEvent) {
        this.processor.processConnections(new DialUpRadiusProcessor.ConnectionIterator(){

            public boolean processConnection(DialUpNas nas, DialUpNasConnection con) {
                if (((DialUpSessionRealtime)con.getSession()).getLogin().getId() == delEvent.getLoginId()) {
                    ((DialUpSessionRealtime)con.getSession()).addLogInfo("Killing session, because login was removed");
                    con.kill(nas);
                }
                return true;
            }
        });
    }

    private void changeLimit(SystemLimitChangedEvent lcEvent) {
        for (DialUpNasConnection con : this.processor.connections()) {
            Session session = (Session)con.getSession();
            if (session.getContract().getId() != lcEvent.getContractId()) continue;
            session.getContract().setBalanceLimit(lcEvent.getNewLimit());
            session.addLogInfo("Changing limit on " + Utils.formatBigDecimalSumm((BigDecimal)lcEvent.getNewLimit()));
        }
    }

    private void breakSession(final DialupSessionBreakEvent sbEvent) {
        this.processor.processConnections(new DialUpRadiusProcessor.ConnectionIterator(){

            public boolean processConnection(DialUpNas nas, DialUpNasConnection con) {
                if (((DialUpSessionRealtime)con.getSession()).getLogRecordId() == sbEvent.getLogRecordId()) {
                    ((DialUpSessionRealtime)con.getSession()).addLogInfo("Killing connection by user request");
                    con.kill(nas);
                    return false;
                }
                return true;
            }
        });
    }

    private void dropSession(final DialupSessionDropEvent dEvent) {
        this.processor.processConnections(new DialUpRadiusProcessor.ConnectionIterator(){

            public boolean processConnection(DialUpNas nas, DialUpNasConnection nasCon) {
                if (((DialUpSessionRealtime)nasCon.getSession()).getLogRecordId() == dEvent.getLogRecordId()) {
                    ((DialUpSessionRealtime)nasCon.getSession()).addLogInfo("Droping connection by user request");
                    nas.dropConnection(((DialUpSessionRealtime)nasCon.getSession()).getNasPort());
                    return false;
                }
                return true;
            }
        });
    }

    private void statusChanged(final ContractStatusChangedTopicEvent scEvent) {
        boolean canWork = this.statusCache.isModuleActiveStatus(this.moduleId, scEvent.getStatus().getStatus());
        if (canWork) {
            return;
        }
        this.processor.processConnections(new DialUpRadiusProcessor.ConnectionIterator(){

            public boolean processConnection(DialUpNas nas, DialUpNasConnection con) {
                if (((DialUpSessionRealtime)con.getSession()).getContract().getId() == scEvent.getContractId()) {
                    ((DialUpSessionRealtime)con.getSession()).addLogInfo("Killing connection by status change");
                    con.kill(nas);
                }
                return true;
            }
        });
    }

    private void loginChanged(final LoginChangedEvent lcEvent) {
        final boolean needBreak = !lcEvent.getNewStatus() || lcEvent.getDateTo() != null && TimeUtils.dateBefore((Date)lcEvent.getDateTo(), (Date)new Date());
        this.processor.processConnections(new DialUpRadiusProcessor.ConnectionIterator(){

            public boolean processConnection(DialUpNas nas, DialUpNasConnection con) {
                Login login = ((DialUpSessionRealtime)con.getSession()).getLogin();
                if (login.getId() == lcEvent.getLoginId()) {
                    if (needBreak) {
                        con.kill(nas);
                        ((DialUpSessionRealtime)con.getSession()).addLogInfo("Killing by LoginChange event");
                    } else {
                        login.setDate1(lcEvent.getDateFrom());
                        login.setDate2(lcEvent.getDateTo());
                        ((DialUpSessionRealtime)con.getSession()).addLogInfo("Changing login period on " + TimeUtils.formatPeriod((Date)lcEvent.getDateFrom(), (Date)lcEvent.getDateTo()));
                    }
                }
                return true;
            }
        });
    }

    private void loginIpsChanged(DialUpLoginIpChangedEvent ipChangedEvent) {
        this.processor.staticAddressMonitor.addrSetChanged(ipChangedEvent.getLoginId(), ipChangedEvent.getAddrList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tariffChanged(final ContractTariffChangedEvent tariffChanged) {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try (final ContractManager contractManager = new ContractManager(con);){
            this.processor.processConnections(new DialUpRadiusProcessor.ConnectionIterator(){

                public boolean processConnection(DialUpNas nas, DialUpNasConnection con) {
                    DialUpSessionRealtime session = (DialUpSessionRealtime)con.getSession();
                    int contractId = tariffChanged.getContractId();
                    if (session.getContract().getId() == contractId) {
                        TariffTreeSet tts = contractManager.getRealtimeTariffTreeSet(contractId, session.getStartTime().getTime(), "dialup", EventBusListener.this.moduleId, true);
                        TariffModuleTree newTariffModuleTree = tts.getTree(session.getCalculatedStopTime().getTime());
                        TariffTreeSet currentTts = session.getContract().getTts();
                        TariffModuleTree currentTree = currentTts.getTree(session.getCalculatedStopTime().getTime());
                        session.addLogInfo("Tariff set was changed!");
                        if (newTariffModuleTree == null) {
                            session.addLogInfo("Not found current tariff in current tree");
                            con.kill(nas);
                        } else if (newTariffModuleTree.getTreeId() != currentTree.getTreeId()) {
                            session.addLogInfo("Current contract tariff was changed");
                            con.kill(nas);
                        } else if (newTariffModuleTree.getTimeAtInit() != currentTree.getTimeAtInit()) {
                            session.addLogInfo("Tariff tree was changed");
                            con.kill(nas);
                        } else {
                            session.addLogInfo("Reinit connection tree set");
                            session.getContract().setTts(tts);
                        }
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tariffOptionChanged(Event tariffOptionChanged) {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try (ContractTariffOptionDao ctom = new ContractTariffOptionDao(con);){
            for (DialUpNasConnection nasCon : this.processor.connections()) {
                DialUpSessionRealtime session = (DialUpSessionRealtime)nasCon.getSession();
                int contractId = tariffOptionChanged.getContractId();
                if (session.getContract().getId() != contractId) continue;
                ContractTariffOptionList tariffOptionList = ctom.getContractRealtimeTariffOptionList(contractId, session.getCalculatePeriodStart().getTime());
                session.getContract().setTariffOptions(tariffOptionList);
                session.addLogInfo("Tariff options was changed!");
                session.addLogInfo(tariffOptionList.toString());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }
}

