/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.client;

import bitel.billing.module.common.IntTextField;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.dba.client.ConfigureTree;
import ru.bitel.bgbilling.modules.dba.client.ConfigureTreeNode;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ServiceConfigConfigure
extends ServiceConfigTabbedPanel {
    private ConfigureTree tree = new ConfigureTree(this);

    public ServiceConfigConfigure() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane(this.tree.getViewableTree()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("TableConfigTree");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.tree.loadTree(doc);
        }
    }

    public void editItem() {
        TreePath path = this.tree.getViewableTree().getSelectionPath();
        if (path == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u0443!");
            return;
        }
        ConfigureTreeNode node = (ConfigureTreeNode)path.getLastPathComponent();
        if (node.getType() != 4) {
            ClientUtils.showErrorMessageDialog((String)"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0442\u0430\u0431\u043b\u0438\u0446!");
            return;
        }
        new EditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", node).open();
    }

    class EditorDialog
    extends BGEditorDialog<ConfigureTreeNode> {
        private BGTextField tableName;
        private IntTextField storeMonth;
        private JCheckBox save;

        public EditorDialog(String title, ConfigureTreeNode data) {
            super(title, (Object)data);
            this.tableName = new BGTextField(40);
            this.storeMonth = new IntTextField();
            this.save = new JCheckBox("\u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u043f\u0435\u0440\u0435\u0434 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u043c");
        }

        public void doDialogPanel() {
            this.tableName.setEnabled(false);
            this.panel.add((Component)new JLabel("\u0418\u043c\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.tableName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u0425\u0440\u0430\u043d\u0438\u0442\u044c \u043c\u0435\u0441\u044f\u0446\u0435\u0432:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.storeMonth, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.save, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 10, 5), 0, 0));
            ParameterMap dataMap = ((ConfigureTreeNode)this.data).getData();
            this.tableName.setText(((ConfigureTreeNode)this.data).getRef().getAttribute("name"));
            this.storeMonth.setText(dataMap.get("store_month"));
            this.save.setSelected(Utils.maskNull((String)dataMap.get("save_before_delete")).equals("true"));
        }

        public boolean doApply() throws Exception {
            String config = null;
            String storeMonthValue = this.storeMonth.getText();
            if (Utils.notBlankString((String)storeMonthValue)) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("store_month", storeMonthValue);
                data.put("save_before_delete", String.valueOf(this.save.isSelected()));
                config = Utils.pairHashToString(data);
            }
            Request request = new Request();
            request.setModule(ServiceConfigConfigure.this.module);
            request.setAction("UpdateTreeConfig");
            request.setModuleId(ServiceConfigConfigure.this.getModuleId());
            request.setAttribute("table_mid", ((ConfigureTreeNode)this.data).getModuleId());
            request.setAttribute("table_id", ((ConfigureTreeNode)this.data).getTableId());
            request.setAttribute("data", config);
            if (!ClientUtils.checkStatus((Document)ServiceConfigConfigure.this.getDocument(request))) {
                return false;
            }
            ((ConfigureTreeNode)this.data).setConfig(config);
            ServiceConfigConfigure.this.tree.getViewableTree().repaint();
            return true;
        }
    }
}

