/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.server.action.apps;

import bitel.billing.server.contract.bean.ContractModuleManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsAbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.alfabank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.alfabank.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;

public class ActionDoPayment
extends AppsAbstractAction {
    public void execute() throws BGException {
        block14: {
            int moduleId = this.getIntParameter("module_id", -1);
            if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(moduleId)) {
                throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d.");
            }
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            BigDecimal sum = this.getBigDecimal("amount", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
            BigDecimal sumMin = moduleSetup.getBigDecimal("alfabank.sum.min", new BigDecimal(100));
            BigDecimal sumMax = moduleSetup.getBigDecimal("alfabank.sum.max", new BigDecimal(5000));
            if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
            }
            String adress = this.getParameter("customerAddress");
            ContractUtils.saveCustomerAddress((Connection)this.con, (int)moduleId, (int)this.contractId, (String)adress);
            try (TransactionManager transactionManager = new TransactionManager(this.con, moduleId);
                 ContractDao contractDao = new ContractDao(this.con, -1);){
                Contract contract = (Contract)contractDao.get(this.contractId);
                if (contract == null) {
                    throw new BGMessageException("Contract don't finde !");
                }
                HashMap<String, Object> payData = new HashMap<String, Object>();
                String urlSuccess = "http://mobileapp.redirect.url.ru";
                Transaction tr = transactionManager.registerOrder(this.contractId, contract.getTitle(), adress, sum, payData, false, false, urlSuccess);
                Object formUrl = payData.get("formUrl");
                if (formUrl != null) {
                    this.actionMap.put("urlRedirect", formUrl);
                    this.actionMap.put("urlSuccess", urlSuccess + "/?orderId=" + tr.getTransactionId() + "&lang=ru");
                    break block14;
                }
                throw new BGMessageException(this.dataMap.get("errorMessage") + " [errorCode=" + this.dataMap.get("errorCode") + "]");
            }
        }
    }
}

