#!/bin/bash

if [ "$EUID" -ne 0 ]; then
  echo "no root"
  exit
fi

SERVICE_FILE=$1

if [ -z "$SERVICE_FILE" ]; then
    SERVICE_LIST=`ls *.service`
    LEN=$(wc -w <<< "$SERVICE_LIST")
    if [ "$LEN" -lt 1 ]; then
        echo "not found unit-service?"
        exit
    fi
    if [ "$LEN" -gt 1 ]; then
        echo "more than 1 unit-service (specify in the parameter): $SERVICE_LIST"
        exit
    fi
    SERVICE_FILE=$SERVICE_LIST
fi

echo "uninstall unit-service: $SERVICE_FILE"

systemctl disable $SERVICE_FILE

# пока из /etc/systemd/system/ не удаляем деактивированный юнит

systemctl daemon-reload
