/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.api.flussonicwatcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.json.JSONObject;
import ru.bitel.bgbilling.modules.smarthouse.server.api.SmarthouseManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.flussonicwatcher.FlussonicWatcherData;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;

public class FlussonicWatcherManager
extends SmarthouseManager {
    private String serverUrl = null;
    private String apiKey = null;
    private int connectTimeout;
    private int readTimeout;
    private Map<String, String> requestProperties = null;
    private FlussonicWatcherData flussonicWatcherData;
    private static Map<Integer, FlussonicWatcherData> moduleLoginData = new HashMap<Integer, FlussonicWatcherData>();

    public FlussonicWatcherManager(int moduleId) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.serverUrl = moduleSetup.get("flussonicwatcher.server.url");
        this.apiKey = moduleSetup.get("flussonicwatcher.api.key");
        this.readTimeout = moduleSetup.getInt("flussonicwatcher.request.timeout.read", 10000);
        this.connectTimeout = moduleSetup.getInt("flussonicwatcher.request.timeout.connect", 10000);
        this.flussonicWatcherData = moduleLoginData.get(moduleId);
        if (this.flussonicWatcherData == null) {
            String login = moduleSetup.get("flussonicwatcher.server.login");
            String password = moduleSetup.get("flussonicwatcher.server.password");
            try {
                FlussonicWatcherData flussonicWatcherData;
                String loginResult = this.login(login, password);
                JSONObject jsonObject = new JSONObject(loginResult);
                this.flussonicWatcherData = flussonicWatcherData = new FlussonicWatcherData().setLoginResult(jsonObject).setSession(jsonObject.optString("session"));
                moduleLoginData.put(moduleId, flussonicWatcherData);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public String login(String login, String password) throws Exception {
        JSONObject data = new JSONObject().put("login", (Object)login).put("password", (Object)password);
        return this.doStringRequest("GET", "/vsaas/api/v2/auth/login", data.toString());
    }

    public String getOrganizationUsers(int organizationId) throws Exception {
        return this.doStringRequest("GET", "/watcher/client-api/v3/organizations/" + organizationId + "/users", null);
    }

    public String getUsers() throws Exception {
        return this.doStringRequest("GET", "/vsaas/api/v2/users", null);
    }

    public String getUserByName(String name) throws Exception {
        String uri = "/watcher/client-api/v3/users?name=" + URLEncoder.encode(name, StandardCharsets.UTF_8);
        return this.doStringRequest("GET", uri, null);
    }

    public String getOrganizations() throws Exception {
        return this.doStringRequest("GET", "/vsaas/api/v2/organizations", null);
    }

    public String getOrganization(int organizationId) throws Exception {
        return this.doStringRequest("GET", "/watcher/client-api/v3/organizations/" + organizationId, null);
    }

    public String getPresets(int organizationId) throws Exception {
        String uri = "/watcher/admin-api/v3/presets?" + (String)(organizationId > 0 ? "organization_id=" + organizationId : "");
        return this.doStringRequest("GET", uri, null);
    }

    public String updateOrganizationPreset(int organizationId, int presetId) throws Exception {
        JSONObject json = new JSONObject().put("preset_id", presetId);
        return this.doStringRequest("PUT", "/watcher/admin-api/v3/organizations/" + organizationId + "/presets", json.toString());
    }

    public String deleteOrganizationPreset(int organizationId, int presetId) throws Exception {
        return this.doStringRequest("DELETE", "/watcher/admin-api/v3/organizations/" + organizationId + "/presets/" + presetId, null);
    }

    public String getOrganizationCameras(int organizationId) throws Exception {
        String uri = "/watcher/admin-api/v3/streams?" + (String)(organizationId > 0 ? "organization_id=" + organizationId : "");
        return this.doStringRequest("GET", uri, null);
    }

    public String getCameras() throws Exception {
        return this.doStringRequest("GET", "/vsaas/api/v2/cameras", null);
    }

    protected String doStringRequest(String method, String uri, String output) throws Exception {
        if (this.serverUrl == null) {
            this.getLogger().error("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"flussonicwatcher.server.url=\"");
            return null;
        }
        if ("GET".equals(method)) {
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.serverUrl + uri)).header("Authorization", "Bearer " + this.apiKey).GET().build();
            return this.getHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString()).body();
        }
        if ("PUT".equals(method)) {
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.serverUrl + uri)).header("Authorization", "Bearer " + this.apiKey).setHeader("Content-Type", "application/json").PUT(HttpRequest.BodyPublishers.ofString(output)).build();
            return this.getHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString()).body();
        }
        if ("DELETE".equals(method)) {
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.serverUrl + uri)).header("Authorization", "Bearer " + this.apiKey).DELETE().build();
            return this.getHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString()).body();
        }
        URLConnection urlConnection = URI.create(this.serverUrl + uri).toURL().openConnection();
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setRequestMethod(method);
        if (this.requestProperties != null && !this.requestProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.requestProperties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        connection.setRequestProperty("x-vsaas-api-key", this.apiKey);
        if (this.flussonicWatcherData != null && this.flussonicWatcherData.getSession() != null) {
            connection.setRequestProperty("x-vsaas-session", this.flussonicWatcherData.getSession());
        }
        connection.setDoOutput(output != null);
        connection.setDoInput(true);
        if (output != null) {
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));){
                bw.write(output.toCharArray());
            }
        }
        connection.connect();
        StringBuilder result = null;
        InputStream inputStream = connection.getResponseCode() == 200 ? connection.getInputStream() : connection.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        if (reader.ready()) {
            String line = null;
            result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        reader.close();
        connection.disconnect();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 Flussonic Watcher: " + result.toString());
        }
        return result.toString();
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        this.requestProperties = requestProperties;
    }

    private HttpClient getHttpClient() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(this){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        return HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).sslContext(sc).build();
    }
}

