/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.modules.kernel;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.modules.reports.client.ReportParams;
import ru.bitel.bgbilling.modules.reports.client.include.BGHidingPanel;
import ru.bitel.bgbilling.modules.reports.client.include.RFAddress;
import ru.bitel.bgbilling.modules.reports.client.include.RFCashcheckKkmList;
import ru.bitel.bgbilling.modules.reports.client.include.RFChargeTypes;
import ru.bitel.bgbilling.modules.reports.client.include.RFCheckbox;
import ru.bitel.bgbilling.modules.reports.client.include.RFCheckedList;
import ru.bitel.bgbilling.modules.reports.client.include.RFCombo;
import ru.bitel.bgbilling.modules.reports.client.include.RFContract;
import ru.bitel.bgbilling.modules.reports.client.include.RFContractGroups;
import ru.bitel.bgbilling.modules.reports.client.include.RFContractLabels;
import ru.bitel.bgbilling.modules.reports.client.include.RFContractStatuses;
import ru.bitel.bgbilling.modules.reports.client.include.RFDate;
import ru.bitel.bgbilling.modules.reports.client.include.RFDealers;
import ru.bitel.bgbilling.modules.reports.client.include.RFHours;
import ru.bitel.bgbilling.modules.reports.client.include.RFInetDevices;
import ru.bitel.bgbilling.modules.reports.client.include.RFList;
import ru.bitel.bgbilling.modules.reports.client.include.RFListParams;
import ru.bitel.bgbilling.modules.reports.client.include.RFModule;
import ru.bitel.bgbilling.modules.reports.client.include.RFMonth;
import ru.bitel.bgbilling.modules.reports.client.include.RFMonthAndDays;
import ru.bitel.bgbilling.modules.reports.client.include.RFNases;
import ru.bitel.bgbilling.modules.reports.client.include.RFPaymentTypes;
import ru.bitel.bgbilling.modules.reports.client.include.RFPeriod;
import ru.bitel.bgbilling.modules.reports.client.include.RFPeriodWithTime;
import ru.bitel.bgbilling.modules.reports.client.include.RFRegisterCategoryList;
import ru.bitel.bgbilling.modules.reports.client.include.RFRegisterExecutors;
import ru.bitel.bgbilling.modules.reports.client.include.RFRegisterGroups;
import ru.bitel.bgbilling.modules.reports.client.include.RFRegisterTaskType;
import ru.bitel.bgbilling.modules.reports.client.include.RFServices;
import ru.bitel.bgbilling.modules.reports.client.include.RFTariffGroups;
import ru.bitel.bgbilling.modules.reports.client.include.RFTariffOptions;
import ru.bitel.bgbilling.modules.reports.client.include.RFTariffPlan;
import ru.bitel.bgbilling.modules.reports.client.include.RFTextField;
import ru.bitel.bgbilling.modules.reports.client.include.RFUsers;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilter;
import ru.bitel.bgbilling.modules.reports.client.include.SetData;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ReportParams_Default
extends ReportParams {
    private List<ReportFilter> params = new ArrayList<ReportFilter>();

    @Override
    protected void putReportParams(Map<String, Object> _reportParams) {
        for (ReportFilter p : this.params) {
            p.putParams(_reportParams);
        }
    }

    public void setData() {
        for (ReportFilter p : this.params) {
            if (!(p instanceof SetData)) continue;
            SetData s = (SetData)((Object)p);
            s.setData(this);
        }
    }

    public Document getDocument(Request req) {
        return super.getDocument(req);
    }

    public ReportParams_Default() {
        this.setLayout(new GridBagLayout());
    }

    @Override
    public void setReportInfo(Element e) throws Exception {
        FilterParserDoc p = new FilterParserDoc();
        p.process(e);
        p.end();
        for (ReportFilter param : this.params) {
            if (!(param instanceof BGPanel)) continue;
            BGPanel panel = (BGPanel)param;
            panel.init(this.module, this.getModuleId());
        }
    }

    public void init(String module, int mid) {
        super.init(module, mid);
    }

    public Iterable<Element> getItemElementsFromSql(String sql) {
        Request request = new Request();
        request.setModule("reports");
        request.setModuleId(this.getModuleId());
        request.setAction("GetListFromSql");
        request.setAttribute("sql", sql);
        Document doc = TransferManager.getDocument((Request)request);
        if (ClientUtils.checkStatus((Document)doc)) {
            try {
                return XMLUtils.selectElements((Node)doc, (String)"/data/items/item");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        return null;
    }

    private int getAnchor(Element a) {
        String anchorString = a.getAttribute("anchor");
        int anchor = 18;
        switch (anchorString.toUpperCase()) {
            case "CENTER": {
                anchor = 10;
                break;
            }
            case "NORTH": {
                anchor = 11;
                break;
            }
            case "NORTHEAST": {
                anchor = 12;
                break;
            }
            case "EAST": {
                anchor = 13;
                break;
            }
            case "SOUTHEAST": {
                anchor = 14;
                break;
            }
            case "SOUTH": {
                anchor = 15;
                break;
            }
            case "SOUTHWEST": {
                anchor = 16;
                break;
            }
            case "WEST": {
                anchor = 17;
                break;
            }
            case "NORTHWEST": {
                anchor = 18;
            }
        }
        return anchor;
    }

    private int getFill(Element a) {
        String resizeString = a.getAttribute("fill");
        int fill = 2;
        switch (resizeString.toUpperCase()) {
            case "BOTH": {
                fill = 1;
                break;
            }
            case "HORIZONTAL": {
                fill = 2;
                break;
            }
            case "VERTICAL": {
                fill = 3;
                break;
            }
            case "NONE": {
                fill = 0;
            }
        }
        return fill;
    }

    private class FilterParserDoc {
        private int lastY = 0;
        private int maxY = 0;
        private int maxWidth = 1;
        private JTabbedPane tabbed = null;
        private Component firstTabPane = null;
        private String firstTabPaneTitle = null;
        private JComponent panel;

        public FilterParserDoc() {
            this.panel = ReportParams_Default.this;
        }

        public void process(Element e) throws Exception {
            NodeList childs = e.getChildNodes();
            if (e.getNodeType() == 1 && "report".equals(e.getNodeName())) {
                this.processReport(e, childs);
            } else {
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node node = childs.item(i);
                    if (node.getNodeType() != 1 || !"report".equals(node.getNodeName())) continue;
                    Element elem = (Element)node;
                    this.processReport(elem, childs);
                }
            }
        }

        private void processReport(Element elem, NodeList childs) throws Exception {
            boolean scroll = Utils.parseBoolean((String)XMLUtils.getAttribute((Element)elem, (String)"scroll", (String)""), (boolean)false);
            int height = Utils.parseInt((String)XMLUtils.getAttribute((Element)elem, (String)"height", (String)""), (int)400);
            if (scroll) {
                this.panel = new JPanel(new GridBagLayout());
                this.panel.setMaximumSize(new Dimension(ReportParams_Default.this.getWidth(), height));
                this.panel.setPreferredSize(new Dimension(ReportParams_Default.this.getWidth(), height));
                ReportParams_Default.this.add(new JScrollPane(this.panel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            childs = elem.getChildNodes();
            this.execFilters(childs, this.panel);
        }

        private void execFilters(NodeList childs, JComponent panel) throws Exception {
            for (int j = 0; j < childs.getLength(); ++j) {
                BGControlPanelListSelect text;
                Element it;
                Node n;
                int k;
                DefaultListModel model;
                Node node = childs.item(j);
                if (node.getNodeType() != 1) continue;
                Element attributes = (Element)node;
                String qName = attributes.getNodeName();
                if ("hide".equals(qName)) {
                    BGHidingPanel hidePanel = new BGHidingPanel(attributes.getAttribute("title"));
                    this.execFilters(attributes.getChildNodes(), hidePanel);
                    panel.add((Component)hidePanel, this.getConstraints(attributes));
                    continue;
                }
                String name = attributes.getAttribute("name");
                String title = attributes.getAttribute("title");
                if ("combo".equals(qName)) {
                    RFCombo combo = new RFCombo(title, name, attributes.getAttribute("textBefore"), attributes.getAttribute("textAfter"), attributes.getAttribute("sql"));
                    ReportParams_Default.this.params.add(combo);
                    panel.add((Component)combo, this.getConstraints(attributes));
                    NodeList items = attributes.getChildNodes();
                    for (int k2 = 0; k2 < items.getLength(); ++k2) {
                        Node n2 = items.item(k2);
                        if (n2.getNodeType() != 1 || !"item".equals(n2.getNodeName())) continue;
                        Element it2 = (Element)n2;
                        ComboBoxItem item = new ComboBoxItem((Object)it2.getAttribute("id"), it2.getAttribute("title"));
                        DefaultComboBoxModel model2 = (DefaultComboBoxModel)combo.getCombo().getModel();
                        model2.addElement(item);
                    }
                    continue;
                }
                if ("list".equals(qName)) {
                    RFList list = new RFList(title, name, attributes.getAttribute("sql"));
                    boolean isTabbed = Utils.parseBoolean((String)attributes.getAttribute("tabbed"), (boolean)false);
                    ReportParams_Default.this.params.add(list);
                    if (!isTabbed) {
                        panel.add((Component)list, this.getConstraints(attributes));
                    } else {
                        this.addToTabbed(list, attributes.getAttribute("title"));
                    }
                    NodeList items = attributes.getChildNodes();
                    model = list.getList().getList().getModel();
                    for (k = 0; k < items.getLength(); ++k) {
                        n = items.item(k);
                        if (n.getNodeType() != 1 || !"item".equals(n.getNodeName())) continue;
                        it = (Element)n;
                        model.addElement(new BGUListItem(it.getAttribute("id"), it.getAttribute("title")));
                    }
                    continue;
                }
                if ("checkedList".equals(qName)) {
                    RFCheckedList list = new RFCheckedList(title, name, attributes.getAttribute("sql"));
                    boolean isTabbed = Utils.parseBoolean((String)attributes.getAttribute("tabbed"), (boolean)false);
                    ReportParams_Default.this.params.add(list);
                    if (!isTabbed) {
                        panel.add((Component)((Object)list), this.getConstraints(attributes));
                    } else {
                        this.addToTabbed((Component)((Object)list), attributes.getAttribute("title"));
                    }
                    NodeList items = attributes.getChildNodes();
                    model = list.getList().getModel();
                    for (k = 0; k < items.getLength(); ++k) {
                        n = items.item(k);
                        if (n.getNodeType() != 1 || !"item".equals(n.getNodeName())) continue;
                        it = (Element)n;
                        model.addElement(new BGUListItem(it.getAttribute("id"), it.getAttribute("title")));
                    }
                    continue;
                }
                if ("module".equals(qName)) {
                    String folders = XMLUtils.serializeToString((Node)attributes, (boolean)false);
                    RFModule list = new RFModule(title, name, folders, ReportParams_Default.this.getModuleId());
                    ReportParams_Default.this.params.add(list);
                    this.addToTabbed(list, title);
                    continue;
                }
                if ("listParams".equals(qName)) {
                    RFListParams list = new RFListParams(title, name);
                    ReportParams_Default.this.params.add(list);
                    this.addToTabbed((Component)((Object)list), title);
                    continue;
                }
                if ("textField".equals(qName)) {
                    RFTextField text2 = new RFTextField(title, name, attributes.getAttribute("textBefore"), attributes.getAttribute("textAfter"));
                    ReportParams_Default.this.params.add(text2);
                    panel.add((Component)text2, this.getConstraints(attributes));
                    continue;
                }
                if ("contracts".equals(qName)) {
                    RFContract text3 = new RFContract(title, name);
                    ReportParams_Default.this.params.add(text3);
                    panel.add((Component)((Object)text3), this.getConstraints(attributes));
                    continue;
                }
                if ("date".equals(qName)) {
                    RFDate text4 = new RFDate(title, name, this.getCalendar(attributes.getAttribute("default")));
                    ReportParams_Default.this.params.add(text4);
                    panel.add((Component)((Object)text4), this.getConstraints(attributes));
                    continue;
                }
                if ("hours".equals(qName)) {
                    RFHours text5 = new RFHours(title, attributes.getAttribute("name1"), attributes.getAttribute("name2"));
                    ReportParams_Default.this.params.add(text5);
                    panel.add((Component)((Object)text5), this.getConstraints(attributes));
                    continue;
                }
                if ("month".equals(qName)) {
                    RFMonth text6 = new RFMonth(title, name);
                    ReportParams_Default.this.params.add(text6);
                    panel.add((Component)text6, this.getConstraints(attributes));
                    continue;
                }
                if ("monthAndDays".equals(qName)) {
                    RFMonthAndDays text7 = new RFMonthAndDays(title, attributes.getAttribute("name1"), attributes.getAttribute("name2"));
                    ReportParams_Default.this.params.add(text7);
                    panel.add((Component)text7, this.getConstraints(attributes));
                    continue;
                }
                if ("period".equals(qName)) {
                    RFPeriod text8 = new RFPeriod(title, attributes.getAttribute("name1"), attributes.getAttribute("name2"), this.getCalendar(attributes.getAttribute("default1")), this.getCalendar(attributes.getAttribute("default2")));
                    ReportParams_Default.this.params.add(text8);
                    panel.add((Component)((Object)text8), this.getConstraints(attributes));
                    continue;
                }
                if ("periodWithTime".equals(qName)) {
                    RFPeriodWithTime text9 = new RFPeriodWithTime(title, attributes.getAttribute("name1"), attributes.getAttribute("name2"), this.getCalendar(attributes.getAttribute("default1")), this.getCalendar(attributes.getAttribute("default2")));
                    ReportParams_Default.this.params.add(text9);
                    panel.add((Component)text9, this.getConstraints(attributes));
                    continue;
                }
                if ("contractGroups".equals(qName)) {
                    RFContractGroups text10 = new RFContractGroups(title, name, attributes.getAttribute("select_name"));
                    ReportParams_Default.this.params.add(text10);
                    this.addToTabbed(text10, title);
                    continue;
                }
                if ("contractLabels".equals(qName)) {
                    RFContractLabels text11 = new RFContractLabels(title, name, Boolean.parseBoolean(attributes.getAttribute("showBorder")));
                    ReportParams_Default.this.params.add(text11);
                    this.addToTabbed(text11, title);
                    continue;
                }
                if ("services".equals(qName)) {
                    RFServices text12 = new RFServices(title, name, ReportParams_Default.this.reportMid, Boolean.parseBoolean(attributes.getAttribute("showBorder")));
                    ReportParams_Default.this.params.add(text12);
                    this.addToTabbed((Component)((Object)text12), title);
                    continue;
                }
                if ("nases".equals(qName)) {
                    int moduleId = ReportParams_Default.this.reportMid;
                    if (moduleId <= 0) {
                        moduleId = Utils.parseInt((String)attributes.getAttribute("mid"), (int)0);
                    }
                    text = new RFNases(title, name, moduleId);
                    ReportParams_Default.this.params.add((ReportFilter)text);
                    this.addToTabbed((Component)text, title);
                    continue;
                }
                if ("dealers".equals(qName)) {
                    int moduleId = ReportParams_Default.this.reportMid;
                    if (moduleId <= 0) {
                        moduleId = Utils.parseInt((String)attributes.getAttribute("mid"), (int)0);
                    }
                    text = new RFDealers(title, name, moduleId);
                    ReportParams_Default.this.params.add((ReportFilter)text);
                    this.addToTabbed((Component)text, title);
                    continue;
                }
                if ("paymentTypes".equals(qName)) {
                    RFPaymentTypes text13 = new RFPaymentTypes(title, name);
                    ReportParams_Default.this.params.add(text13);
                    this.addToTabbed(text13, title);
                    continue;
                }
                if ("chargeTypes".equals(qName)) {
                    RFChargeTypes text14 = new RFChargeTypes(title, name);
                    ReportParams_Default.this.params.add(text14);
                    this.addToTabbed(text14, title);
                    continue;
                }
                if ("tariffs".equals(qName)) {
                    RFTariffPlan text15 = new RFTariffPlan(title, name);
                    ReportParams_Default.this.params.add(text15);
                    this.addToTabbed((Component)((Object)text15), title);
                    continue;
                }
                if ("tariffOptions".equals(qName)) {
                    RFTariffOptions text16 = new RFTariffOptions(title, name);
                    ReportParams_Default.this.params.add(text16);
                    this.addToTabbed((Component)((Object)text16), title);
                    continue;
                }
                if ("tariffGroups".equals(qName)) {
                    RFTariffGroups text17 = new RFTariffGroups(title, name);
                    ReportParams_Default.this.params.add(text17);
                    this.addToTabbed((Component)((Object)text17), title);
                    continue;
                }
                if ("registerCategories".equals(qName)) {
                    RFRegisterCategoryList text18 = new RFRegisterCategoryList(title, name);
                    ReportParams_Default.this.params.add(text18);
                    this.addToTabbed((Component)((Object)text18), title);
                    continue;
                }
                if ("registerExecutors".equals(qName)) {
                    boolean needBlank = "1".equals(attributes.getAttribute("blank"));
                    text = new RFRegisterExecutors(title, name, needBlank);
                    ReportParams_Default.this.params.add((ReportFilter)text);
                    this.addToTabbed((Component)text, title);
                    continue;
                }
                if ("registerTaskType".equals(qName)) {
                    RFRegisterTaskType text19 = new RFRegisterTaskType(title, name);
                    ReportParams_Default.this.params.add(text19);
                    this.addToTabbed((Component)((Object)text19), title);
                    continue;
                }
                if ("registerGroups".equals(qName)) {
                    RFRegisterGroups text20 = new RFRegisterGroups(title, name);
                    ReportParams_Default.this.params.add(text20);
                    this.addToTabbed((Component)((Object)text20), title);
                    continue;
                }
                if ("users".equals(qName)) {
                    RFUsers text21 = new RFUsers(title, name);
                    ReportParams_Default.this.params.add(text21);
                    this.addToTabbed(text21, title);
                    continue;
                }
                if ("address".equals(qName)) {
                    RFAddress part = new RFAddress(title, attributes.getAttribute("cityName"), attributes.getAttribute("streetName"), attributes.getAttribute("areaName"), attributes.getAttribute("quarterName"), attributes.getAttribute("houseName"));
                    panel.add((Component)part, this.getConstraints(attributes));
                    ReportParams_Default.this.params.add(part);
                    continue;
                }
                if ("cashcheckKKM".equals(qName)) {
                    RFCashcheckKkmList text22 = new RFCashcheckKkmList(title, name, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text22);
                    panel.add((Component)((Object)text22), this.getConstraints(attributes));
                    continue;
                }
                if ("inetDevices".equals(qName)) {
                    int inetMid = Utils.parseInt((String)attributes.getAttribute("mid"), (int)-1);
                    RFInetDevices devices = new RFInetDevices(title, name, inetMid > 0 ? inetMid : ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(devices);
                    this.addToTabbed((Component)((Object)devices), title);
                    continue;
                }
                if ("contractStatuses".equals(qName) || "contractStatus".equals(qName)) {
                    RFContractStatuses statuses = new RFContractStatuses(title, name);
                    ReportParams_Default.this.params.add(statuses);
                    this.addToTabbed((Component)((Object)statuses), title);
                    continue;
                }
                if (!"checkbox".equals(qName)) continue;
                RFCheckbox cb = new RFCheckbox(title, name, Utils.parseBoolean((String)attributes.getAttribute("default")));
                ReportParams_Default.this.params.add(cb);
                panel.add((Component)cb, this.getConstraints(attributes));
            }
        }

        private Calendar getCalendar(String macros) {
            GregorianCalendar dateCalendar = new GregorianCalendar();
            if (macros.equals("today")) {
                return dateCalendar;
            }
            if (macros.equals("yesterday")) {
                ((Calendar)dateCalendar).add(5, -1);
                return dateCalendar;
            }
            if (macros.equals("tommorrow")) {
                ((Calendar)dateCalendar).add(5, 1);
                return dateCalendar;
            }
            if (macros.equals("first_day_of_month")) {
                dateCalendar.set(5, ((Calendar)dateCalendar).getActualMinimum(5));
                return dateCalendar;
            }
            if (macros.equals("last_day_of_month")) {
                dateCalendar.set(5, ((Calendar)dateCalendar).getActualMaximum(5));
                return dateCalendar;
            }
            return null;
        }

        private void addToTabbed(Component c, String title) {
            if (this.firstTabPane == null) {
                this.firstTabPane = c;
                this.firstTabPaneTitle = title;
            } else {
                if (this.tabbed == null) {
                    this.tabbed = new JTabbedPane();
                    this.tabbed.addTab(this.firstTabPaneTitle, this.firstTabPane);
                }
                this.tabbed.addTab(title, c);
            }
        }

        private GridBagConstraints getConstraints(Element a) {
            int x = Utils.parseInt((String)a.getAttribute("x"), (int)0);
            int y = Utils.parseInt((String)a.getAttribute("y"), (int)-1);
            if (y < 0) {
                y = this.lastY;
            }
            this.lastY = y + 1;
            this.maxY = Math.max(this.maxY, this.lastY);
            int width = Utils.parseInt((String)a.getAttribute("width"), (int)1);
            int height = Utils.parseInt((String)a.getAttribute("height"), (int)1);
            float xweight = Utils.parseFloat((String)a.getAttribute("xweight"), (float)1.0f);
            float yweight = Utils.parseFloat((String)a.getAttribute("yweight"), (float)0.0f);
            this.maxWidth = Math.max(this.maxWidth, x + width);
            int fill = ReportParams_Default.this.getFill(a);
            int anchor = ReportParams_Default.this.getAnchor(a);
            return new GridBagConstraints(x, y, width, height, xweight, yweight, anchor, fill, new Insets(2, 2, 2, 2), 0, 0);
        }

        public void end() {
            if (this.tabbed != null) {
                this.panel.add((Component)this.tabbed, new GridBagConstraints(0, this.maxY, this.maxWidth, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else if (this.firstTabPane != null) {
                this.panel.add(this.firstTabPane, new GridBagConstraints(0, this.maxY, this.maxWidth, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this.panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, this.maxY, this.maxWidth, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
    }
}

