/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;
import ru.bitel.oss.kernel.entity.common.bean.AbstractSpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;

public class EntitySpecAttrDao
extends AbstractDirectoryIdDao<EntitySpecAttr> {
    public EntitySpecAttrDao(Connection con) {
        super(con, 0, "entity_spec_attr");
    }

    protected EntitySpecAttr getFromRS(ResultSet rs) throws SQLException {
        return new EntitySpecAttr().setId(rs.getInt("id")).setTitle(rs.getString("title")).setType(rs.getInt("type")).setComment(rs.getString("comment"));
    }

    protected void updateImpl(EntitySpecAttr entitySpecAttr) throws BGException, SQLException {
        if (Utils.isBlankString((String)entitySpecAttr.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        boolean update = entitySpecAttr.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, comment=?" + (update ? " WHERE id=?" : ", type=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, entitySpecAttr.getTitle());
            ps.setString(index++, entitySpecAttr.getComment());
            ps.setInt(index++, update ? entitySpecAttr.getId() : entitySpecAttr.getType());
            ps.executeUpdate();
            if (!update) {
                entitySpecAttr.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    public List<EntitySpecAttr> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }

    public Map<Integer, List<EntitySpecAttr>> map() throws BGException {
        HashMap<Integer, List<EntitySpecAttr>> result = new HashMap<Integer, List<EntitySpecAttr>>();
        for (EntitySpecAttr sa : this.list()) {
            ArrayList<EntitySpecAttr> list = (ArrayList<EntitySpecAttr>)result.get(sa.getType());
            if (list == null) {
                list = new ArrayList<EntitySpecAttr>();
                result.put(sa.getType(), list);
            }
            list.add(sa);
        }
        return result;
    }

    public List<EntitySpecAttr> listByType(int type) throws BGException {
        return super.list("type=?", null, new Object[]{type});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<EntitySpecAttr> listByEntitySpec(int id) throws BGException {
        String query = "SELECT attr.* FROM entity_spec_attr_link as link  LEFT JOIN " + this.tableName + " as attr ON link.entitySpecAttrId=attr.id WHERE link.entitySpecId=? ORDER BY link.pos";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            List list;
            block14: {
                ps.setInt(1, id);
                ResultSet rs = ps.executeQuery();
                try {
                    list = this.getListFromRS(rs);
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    void update(EntitySpec s) throws BGException {
        PreparedStatement ps;
        String query = "DELETE FROM entity_spec_attr_link WHERE entitySpecId=?";
        try {
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, s.getId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            this.processException(e);
        }
        query = "INSERT INTO entity_spec_attr_link SET entitySpecId=?, entitySpecAttrId=?, pos=?";
        try {
            ps = this.con.prepareStatement(query);
            try {
                if (s.getAttributeList() != null) {
                    int pos = 0;
                    for (AbstractSpecAttr a : s.getAttributeList()) {
                        ps.setInt(1, s.getId());
                        ps.setInt(2, a.getId());
                        ps.setInt(3, pos++);
                        ps.addBatch();
                    }
                }
                ps.executeBatch();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            this.processException(e);
        }
    }

    public EntitySpecAttr get(String title) throws BGException {
        return (EntitySpecAttr)this.get("title=?", new Object[]{title});
    }
}

