/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Calendar;
import ru.bitel.common.TimeUtils;

public abstract class ServiceCost {
    protected int serviceId = 0;
    protected Calendar date1;
    protected Calendar date2;
    protected LocalDate serviceStart;
    protected LocalDate serviceEnd;
    protected int accountingPeriodDays;
    protected long amount = 0L;
    protected BigDecimal cost;
    protected BigDecimal unitCost;
    public boolean amountNull = false;

    protected ServiceCost() {
    }

    protected String paramsToString() {
        return "serviceId: " + this.serviceId + "; date1: " + TimeUtils.formatDate((Calendar)this.date1) + "; date2: " + TimeUtils.formatDate((Calendar)this.date2) + "; serviceStart: " + TimeUtils.formatDate((LocalDate)this.serviceStart) + "; serviceEnd: " + TimeUtils.formatDate((LocalDate)this.serviceEnd) + "; accountingPeriodDays: " + this.accountingPeriodDays + "; amount: " + this.amount + "; cost: " + this.cost + "; unitCost: " + this.unitCost;
    }

    public ServiceCost newCost() {
        ServiceCost result = this.newCostInternal();
        result.amountNull = this.amountNull;
        return result;
    }

    protected ServiceCost newCostInternal() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder result = new StringBuilder(100);
        result.append("ServiceCost [");
        result.append(this.paramsToString());
        result.append("]");
        return result.toString();
    }

    public ServiceCost setServiceId(int serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public long getAmount() {
        return this.amount;
    }

    public ServiceCost setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    public Calendar getDate1() {
        return this.date1;
    }

    public Calendar getDate2() {
        return this.date2;
    }

    public ServiceCost setDate1(Calendar date1) {
        this.date1 = date1;
        if (this.date1 != null && this.date2 != null) {
            this.accountingPeriodDays = this.date2.get(5) - this.date1.get(5) + 1;
        }
        return this;
    }

    public ServiceCost setDate2(Calendar date2) {
        this.date2 = date2;
        if (this.date1 != null && this.date2 != null) {
            this.accountingPeriodDays = this.date2.get(5) - this.date1.get(5) + 1;
        }
        return this;
    }

    public ServiceCost setDate1(LocalDate date) {
        this.setDate1(TimeUtils.convertLocalDateToCalendar((LocalDate)date));
        return this;
    }

    public ServiceCost setDate2(LocalDate date) {
        this.setDate2(TimeUtils.convertLocalDateToCalendar((LocalDate)date));
        return this;
    }

    public Calendar getServiceStart() {
        return TimeUtils.convertLocalDateToCalendar((LocalDate)this.serviceStart);
    }

    public Calendar getServiceEnd() {
        return TimeUtils.convertLocalDateToCalendar((LocalDate)this.serviceEnd);
    }

    public ServiceCost setServiceStart(LocalDate serviceStart) {
        this.serviceStart = serviceStart;
        return this;
    }

    public ServiceCost setServiceEnd(LocalDate serviceEnd) {
        this.serviceEnd = serviceEnd;
        return this;
    }

    public int getAccountingPeriodDays() {
        return this.accountingPeriodDays;
    }

    public ServiceCost setAccountingPeriodDays(int accountingPeriodDays) {
        this.accountingPeriodDays = accountingPeriodDays;
        return this;
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public ServiceCost setCost(BigDecimal cost) {
        this.cost = cost;
        return this;
    }

    public BigDecimal getUnitCost() {
        return this.unitCost;
    }

    public ServiceCost setUnitCost(BigDecimal unitCost) {
        this.unitCost = unitCost;
        return this;
    }

    public <T extends ServiceCost> T to(Class<T> clazz) {
        return (T)this;
    }
}

