/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.common.service.EmailService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;

public class EmailServiceConfigFind
extends ServiceConfigTabbedPanel {
    private BGUComboBox<Domain> domain_CB = new BGUComboBox();
    private JTextField mask_TF = new JTextField();
    private BGDataSourceTableModel tableModel = new BGDataSourceTableModel("FindEmail");
    private JPopupMenu rcMenu = new JPopupMenu();

    public EmailServiceConfigFind() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.mask_TF.setMinimumSize(new Dimension(4, 24));
        this.mask_TF.setPreferredSize(new Dimension(200, 24));
        JButton findButton = new JButton(">>");
        findButton.addActionListener(e -> this.trySetData());
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.setBorder((Border)new BGTitleBorder(" \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b "));
        jPanel1.add((Component)new JLabel("\u0414\u043e\u043c\u0435\u043d:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel1.add((Component)new JLabel("\u041c\u0430\u0441\u043a\u0430:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel1.add((Component)this.mask_TF, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        jPanel1.add((Component)this.domain_CB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel1.add((Component)findButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getTablePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getTablePanel() {
        BGUTable table = new BGUTable((TableModel)this.tableModel);
        BGSwingUtilites.handleMouseClicked((Component)table, e -> this.tableMouseClicked((MouseEvent)e));
        JMenuItem item = new JMenuItem("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        item.addActionListener(e -> ClientUtils.openContract((int)this.tableModel.optSelectContractId().orElse(0)));
        this.rcMenu.add(item);
        JScrollPane jScrollPane1 = new JScrollPane((Component)table);
        jScrollPane1.setBorder(null);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 "));
        panel.add((Component)jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void tableMouseClicked(MouseEvent event) {
        BGUTableRowData index = (BGUTableRowData)this.tableModel.getSelectedRow();
        if (SwingUtilities.isRightMouseButton(event) && index != null) {
            Point p = event.getPoint();
            this.rcMenu.show(event.getComponent(), p.x, p.y);
        }
    }

    public void setData() throws Exception {
        if (!this.init) {
            this.init();
            this.init = true;
        }
        Domain domain = (Domain)this.domain_CB.getSelectedItem();
        String mask = this.mask_TF.getText();
        if (domain != null && Utils.notEmptyString((String)mask)) {
            BGUTableParams tableParams = new BGUTableParams().addParam("domain", domain.getId()).addParam("mask", mask);
            this.tableModel.loadData(this.getContext(), tableParams);
        }
    }

    private void init() {
        this.tryCall(() -> this.domain_CB.setData(((EmailService)this.getContext().getWebService(EmailService.class)).domainList(null)));
    }
}

