/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.service;

import jakarta.jws.WebService;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.subscription.common.bean.RegistrationPeriod;
import ru.bitel.bgbilling.modules.subscription.common.bean.Subscription;
import ru.bitel.bgbilling.modules.subscription.common.bean.SubscriptionType;
import ru.bitel.bgbilling.modules.subscription.common.service.SubscriptionService;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionDao;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionPeriodDao;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionTypeDao;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.PeriodWithTime;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.subscription.common.service.SubscriptionService")
public class SubscriptionServiceImpl
extends AbstractService
implements SubscriptionService {
    public void subscriptionActivate(int subscriptionId) throws BGException {
        this.tryCall(() -> {
            Connection con = this.getConnection();
            SubscriptionDao subscriptionDao = new SubscriptionDao(con, this.moduleId, this.userId);
            Subscription subscription = (Subscription)subscriptionDao.get(subscriptionId);
            if (subscription == null) {
                throw new BGException("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 [subscriptionId = " + subscriptionId + "]");
            }
            new SubscriptionUtils(con).subscriptionActivate(subscription, new Date(), this.moduleId, this.userId, subscriptionDao);
        });
    }

    public List<Subscription> subscriptionList(int contractId, boolean loadRegistrationPeriod) throws BGException {
        return (List)this.tryReturn(() -> {
            List<Subscription> list = new SubscriptionDao(this.getConnectionSet().getConnection(), this.moduleId, this.userId).list(contractId);
            if (loadRegistrationPeriod) {
                ArrayList<Integer> registrationPeriodIds = new ArrayList<Integer>();
                for (Subscription subscription : list) {
                    registrationPeriodIds.add(subscription.getRegistrationPeriodId());
                }
                SubscriptionPeriodDao subscriptionPeriodDao = new SubscriptionPeriodDao(this.getConnectionSet().getConnection(), this.moduleId, this.userId);
                Map<Integer, RegistrationPeriod> map = subscriptionPeriodDao.map(registrationPeriodIds);
                for (Subscription subscription : list) {
                    RegistrationPeriod registrationPeriod = map.get(subscription.getRegistrationPeriodId());
                    if (registrationPeriod == null) continue;
                    ArrayList<RegistrationPeriod> periods = new ArrayList<RegistrationPeriod>();
                    periods.add(registrationPeriod);
                    subscription.setRegistrationPeriodList(periods);
                }
            }
            return list;
        });
    }

    public List<RegistrationPeriod> subscriptionRegistrationPeriodList(int subscriptionId) throws BGException {
        return (List)this.tryReturn(() -> new SubscriptionPeriodDao(this.getConnectionSet().getConnection(), this.moduleId, this.userId).list(subscriptionId));
    }

    public Subscription subscriptionGet(int id) throws BGException {
        return (Subscription)this.tryReturn(() -> (Subscription)new SubscriptionDao(this.getConnectionSet().getConnection(), this.moduleId, this.userId).get(id));
    }

    public int subscriptionUpdate(Subscription subscription) throws BGException {
        return (Integer)this.tryReturn(() -> {
            Connection con = this.getConnectionSet().getConnection();
            SubscriptionDao subscriptionDao = new SubscriptionDao(con, this.moduleId, this.userId);
            subscriptionDao.update(subscription);
            if (subscription.isAvtoCommit() && subscription.getJobId() < 1L) {
                RegistrationPeriod registrationPeriod = null;
                List registrationPeriods = subscription.getRegistrationPeriodList();
                if (registrationPeriods != null) {
                    for (RegistrationPeriod period : registrationPeriods) {
                        if (period.getId() != subscription.getRegistrationPeriodId()) continue;
                        registrationPeriod = period;
                        break;
                    }
                }
                if (registrationPeriod != null) {
                    new SubscriptionUtils(con).addSubscriptionJob(subscription, this.moduleId, registrationPeriod.getPeriod().getDateTo(), subscriptionDao);
                }
            }
            return subscription.getId();
        });
    }

    public int subscriptionDelete(int id) throws BGException {
        return 0;
    }

    public List<SubscriptionType> subscriptionTypeList() throws BGException {
        return (List)this.tryReturn(() -> this.context.getDirectory(SubscriptionType.class, this.moduleId).list());
    }

    public SubscriptionType subscriptionTypeGet(int id) throws BGException {
        return (SubscriptionType)this.context.getDirectory(SubscriptionType.class, this.moduleId).get(id);
    }

    public int subscriptionTypeUpdate(SubscriptionType type) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.context.getDirectory(SubscriptionType.class, this.moduleId).update((Id)type);
            return type.getId();
        });
    }

    public int subscriptionTypeDelete(int id) throws BGException {
        return (Integer)this.tryReturn(() -> this.context.getDirectory(SubscriptionType.class, this.moduleId).delete(id));
    }

    public int[] groupOperationAddSubscription(int[] contractIds, int[] subscriptionTypeIds, Subscription subscription) throws BGException {
        int len = 0;
        int[] result = new int[]{};
        if (contractIds != null && contractIds.length > 0 && subscriptionTypeIds != null && subscriptionTypeIds.length > 0 && subscription != null) {
            result = new int[contractIds.length];
            for (int contractId : contractIds) {
                subscription.setContractId(contractId);
                for (int subscriptionTypeId : subscriptionTypeIds) {
                    subscription.setId(0);
                    subscription.setTypeId(subscriptionTypeId);
                    this.subscriptionUpdate(subscription);
                }
                result[len++] = contractId;
            }
        }
        return Arrays.copyOf(result, len);
    }

    public int[] groupOperationCloseSubscription(int[] contractIds, int[] subscriptionTypeIds, Date dateTo) throws BGException {
        int len = 0;
        int[] result = new int[]{};
        if (contractIds != null && contractIds.length > 0 && subscriptionTypeIds != null && subscriptionTypeIds.length > 0 && dateTo != null && dateTo.after(new Date())) {
            result = new int[contractIds.length];
            for (int contractId : contractIds) {
                block1: for (Subscription subscription : this.subscriptionList(contractId, true)) {
                    List periods = subscription.getRegistrationPeriodList();
                    RegistrationPeriod registrationPeriod = periods != null && periods.size() > 0 ? (RegistrationPeriod)periods.get(periods.size() - 1) : null;
                    PeriodWithTime period = subscription.getPeriod();
                    for (int subscriptionTypeId : subscriptionTypeIds) {
                        if (subscriptionTypeId != subscription.getTypeId()) continue;
                        LocalDateTime localDateTimeTo = TimeUtils.convertDateToLocalDateTime((Date)dateTo);
                        boolean fl = TimeUtils.dateInPeriod((LocalDateTime)localDateTimeTo, (PeriodWithTime)subscription.getPeriod());
                        fl = fl && (registrationPeriod == null || !TimeUtils.dateInPeriod((LocalDateTime)localDateTimeTo, (PeriodWithTime)registrationPeriod.getPeriod()));
                        if (!fl) continue block1;
                        period.setLocalDateTimeTo(localDateTimeTo);
                        this.subscriptionUpdate(subscription);
                        continue block1;
                    }
                }
            }
        }
        return Arrays.copyOf(result, len);
    }

    public int[] groupOperationActivateSubscription(int[] contractIds, int[] subscriptionTypeIds) throws BGException {
        int len = 0;
        int[] result = new int[]{};
        if (contractIds != null && contractIds.length > 0 && subscriptionTypeIds != null && subscriptionTypeIds.length > 0) {
            result = new int[contractIds.length];
            for (int contractId : contractIds) {
                block1: for (Subscription subscription : this.subscriptionList(contractId, false)) {
                    for (int subscriptionTypeId : subscriptionTypeIds) {
                        if (subscriptionTypeId != subscription.getTypeId() || !TimeUtils.dateInPeriod((LocalDateTime)LocalDateTime.now(), (PeriodWithTime)subscription.getPeriod())) continue;
                        this.subscriptionActivate(subscription.getId());
                        result[len++] = contractId;
                        continue block1;
                    }
                }
            }
        }
        return Arrays.copyOf(result, len);
    }

    public List<SubscriptionType> subscriptionTypes() throws BGException, BGMessageException {
        try (SubscriptionTypeDao subscriptionTypeDao = new SubscriptionTypeDao(this.getConnection(), this.moduleId);){
            List<SubscriptionType> list = subscriptionTypeDao.list();
            return list;
        }
    }

    public Boolean[][] subscriptionStatusMatrixGet(List<Integer> subscriptionIds, List<Integer> statusIds, boolean replaceDefaultToValue) throws BGException, BGMessageException {
        return (Boolean[][])this.tryReturn(() -> new SubscriptionDao(this.getConnection(), this.moduleId, this.userId).getSubscriptionStatusValues(subscriptionIds, statusIds, replaceDefaultToValue));
    }

    public void subscriptionStatusMatrixUpdate(List<Integer> subscriptionIds, List<Integer> statusIds, Boolean[][] values) throws BGException, BGMessageException {
        this.tryCall(() -> new SubscriptionDao(this.getConnection(), this.moduleId, this.userId).updateSubscriptionStatusValues(subscriptionIds, statusIds, values));
    }
}

