/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.service;

import jakarta.jws.WebService;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeSpec;
import ru.bitel.bgbilling.modules.inet.common.service.InetDirectoriesService;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.inet.common.service.InetDirectoriesService")
public class InetDirectoriesServiceImpl
extends AbstractService
implements InetDirectoriesService {
    private Directory<TrafficRangeSpec> trafficRangeSpecDir;

    private Directory<TrafficRangeSpec> getTrafficRangeSpecDir() throws BGException {
        this.trafficRangeSpecDir = this.context.getDirectory(TrafficRangeSpec.class, this.moduleId);
        return Optional.ofNullable(this.trafficRangeSpecDir).orElse((Directory<TrafficRangeSpec>)this.trafficRangeSpecDir);
    }

    public List<TrafficRangeSpec> trafficRangeSpecList() throws BGException {
        return (List)this.tryReturn(() -> this.getTrafficRangeSpecDir().list());
    }

    public TrafficRangeSpec trafficRangeSpecGet(int id) throws BGException {
        return (TrafficRangeSpec)this.getTrafficRangeSpecDir().get(id);
    }

    public int trafficRangeSpecUpdate(TrafficRangeSpec trafficRangeSpec) throws BGException {
        return (Integer)this.tryReturn(() -> {
            if (Utils.isBlankString((String)trafficRangeSpec.getTitle())) {
                throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430!", "title");
            }
            if ((trafficRangeSpec.getMode() == 5 || trafficRangeSpec.getMode() == 15) && trafficRangeSpec.getTariffOptionId() <= 0) {
                throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e!", "tariffOptionId");
            }
            this.getTrafficRangeSpecDir().update((Id)trafficRangeSpec);
            return trafficRangeSpec.getId();
        });
    }

    public void trafficRangeSpecDelete(int id) throws BGException {
        this.tryCall(() -> this.getTrafficRangeSpecDir().delete(id));
    }
}

