/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobimoney.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.MobiServiceCode;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.Transaction;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private String serviceCodeTableName;

    public TransactionManager(Connection con, int moduleId) {
        super(con, "mobi_transaction", moduleId);
        this.serviceCodeTableName = "mobi_service_code_" + moduleId;
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "end_date");
        this.fields.put("sum", "summ");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws SQLException {
        ResultSet rs;
        int index;
        Page page = searchResult.getPage();
        String[] sort = searchResult.getSort();
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS m.*, c.title FROM " + this.tableName + " AS m");
        query.append(" LEFT JOIN contract AS c ON c.id=m.cid");
        query.append(" WHERE true");
        if (Utils.notBlankString((String)status)) {
            query.append(" AND m.status=?");
        }
        if (contractId > 0) {
            query.append(" AND c.id=?");
        } else if (Utils.notBlankString((String)contractTitle)) {
            query.append(" AND c.title LIKE ?");
        }
        query.append(this.queryPeriod(period, "m.create_date"));
        query.append(this.getSQLOrder(sort, this.fields));
        query.append(Page.toSqlLimit((Page)page));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            index = 1;
            if (Utils.notBlankString((String)status)) {
                ps.setString(index++, status);
            }
            if (contractId > 0) {
                ps.setInt(index++, contractId);
            } else if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            index = this.psSetPeriod(ps, index, period);
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
        }
        query = new StringBuilder("SELECT SUM(m.summ) FROM " + this.tableName + " AS m");
        query.append(" LEFT JOIN contract AS c ON c.id=m.cid");
        query.append(" WHERE true");
        if (Utils.notBlankString((String)status)) {
            query.append(" AND m.status=?");
        }
        if (contractId > 0) {
            query.append(" AND m.cid=?");
        } else if (Utils.notBlankString((String)contractTitle)) {
            query.append(" AND c.title LIKE ?");
        }
        query.append(this.queryPeriod(period, "m.create_date"));
        ps = this.con.prepareStatement(query.toString());
        try {
            index = 1;
            if (Utils.notBlankString((String)status)) {
                ps.setString(index++, status);
            }
            if (contractId > 0) {
                ps.setInt(index++, contractId);
            } else if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            index = this.psSetPeriod(ps, index, period);
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    searchResult.setSum(rs.getBigDecimal(1));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public boolean checkPayment(int contractId, String mobiPaymentId) throws SQLException {
        boolean result = false;
        String query = "SELECT id FROM " + this.tableName + " WHERE cid=? AND mobi_payment_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setString(index++, mobiPaymentId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = rs.getInt("id") > 0;
                }
            }
        }
        return result;
    }

    public Transaction getTransaction(String mobiPaymentId) throws SQLException {
        Transaction result = null;
        StringBuilder query = new StringBuilder("SELECT m.*, c.title FROM " + this.tableName + " AS m");
        query.append(" LEFT JOIN contract AS c ON c.id=m.cid");
        query.append(" WHERE m.mobi_payment_id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setString(1, mobiPaymentId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        return result;
    }

    public void addTransaction(Transaction transaction) throws SQLException {
        StringBuilder query = new StringBuilder("INSERT INTO " + this.tableName);
        query.append(" (cid, create_date, summ, status, mobi_payment_id ) VALUES ( ?, NOW(), ?, ?, ? )");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getTransactionId());
            if (ps.executeUpdate() > 0) {
                this.con.commit();
                transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public void updateTransaction(Transaction transaction) throws SQLException {
        this.updateImpl(transaction);
    }

    public List<MobiServiceCode> getServiceCodeList() throws SQLException {
        ArrayList<MobiServiceCode> list = new ArrayList<MobiServiceCode>();
        String query = "SELECT * FROM " + this.serviceCodeTableName + " ORDER BY title";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                MobiServiceCode mobiServiceCode = new MobiServiceCode();
                mobiServiceCode.setId(rs.getInt("id"));
                mobiServiceCode.setCode(rs.getInt("code"));
                mobiServiceCode.setTitle(rs.getString("title"));
                list.add(mobiServiceCode);
            }
        }
        return list;
    }

    public void updateServiceCode(MobiServiceCode mobiServiceCode) throws SQLException {
        String querySet = "code=?, title=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)mobiServiceCode, querySet);){
            int index = 1;
            ps.setInt(index++, mobiServiceCode.getCode());
            ps.setString(index++, mobiServiceCode.getTitle());
            this.executeUpdate((Id)mobiServiceCode, index, ps);
        }
    }

    public void deleteServiceCode(List<Integer> ids) throws SQLException {
        if (ids != null && !ids.isEmpty()) {
            String query = "DELETE FROM " + this.serviceCodeTableName + " WHERE id IN ( " + Utils.toString(ids) + " )";
            try (Statement st = this.con.createStatement();){
                st.executeUpdate(query);
            }
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return new Transaction().setId(rs.getInt("m.id")).setContractId(rs.getInt("m.cid")).setContractTitle(rs.getString("c.title")).setSum(rs.getBigDecimal("m.summ")).setCreateDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("m.create_date"))).setTransactionDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("m.end_date"))).setStatus(rs.getString("m.status")).setTransactionId(rs.getString("m.mobi_payment_id"));
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        Objects.requireNonNull(transaction);
        StringBuilder query = new StringBuilder("UPDATE " + this.tableName);
        query.append(" SET status=?");
        if (transaction.getTransactionDate() != null) {
            query.append(", end_date=?");
        }
        query.append(" WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            ps.setString(index++, transaction.getStatus());
            if (transaction.getTransactionDate() != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            }
            ps.setInt(index++, transaction.getId());
            ps.executeUpdate();
        }
    }
}

