/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSelectFilePanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.table.model.ParameterTableModel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.bill.client.BillDoc;
import ru.bitel.bgbilling.modules.bill.client.ServiceConfigBillViewer;
import ru.bitel.bgbilling.modules.bill.client.bean.BGBillTablePos;
import ru.bitel.bgbilling.modules.bill.client.bean.BillPositionsEditor;
import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentSendParameters;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.SortMode;
import ru.bitel.bgbilling.modules.bill.common.export.BillExportInfo;
import ru.bitel.bgbilling.modules.bill.common.export.BillExportSaveFile;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public abstract class BillServiceConfigTabbedPanel
extends ServiceConfigTabbedPanel {
    private String mode;
    protected BGTableModel<Element> tableModel;
    protected JLabel countLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: 0, \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 0.00");
    protected String separator = ",";
    protected String typeBill = "bill";
    protected String currentId;
    protected BillPositionsEditor positionsEditor;
    protected List<BGBillTablePos> positionList = null;
    protected BGUComboBox<IdTitle> packageCb = new BGUComboBox();
    protected BGUComboBox<IdTitle> sortModeCb = new BGUComboBox();
    protected BGUComboBox<IdTitle> secondarySortModeCb = new BGUComboBox();
    protected CardLayout cardLayout = new CardLayout();
    protected JPanel cardPanel = new JPanel(this.cardLayout);
    protected ServiceConfigBillViewer viewer = new ServiceConfigBillViewer(true);

    public BillServiceConfigTabbedPanel(String mode) {
        this.mode = mode;
        this.viewer.addPropertyChangeListener(e -> {
            if ("toList".equals(e.getPropertyName())) {
                this.showCardPanel("table");
            }
        });
    }

    protected abstract Request getRequest();

    protected abstract void addPopupItems(JPopupMenu var1);

    protected abstract BillListFilter getBillListFilter();

    protected void initCardPanel() {
        this.cardPanel.add((Component)this.getPanel(), "table");
        this.cardPanel.add((Component)((Object)this.viewer), "viewer");
        this.setLayout(new GridBagLayout());
        this.add(this.cardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel getPanel() {
        return new JPanel();
    }

    protected JPanel getExportPanel() {
        JButton exportButton = new JButton("\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c...");
        exportButton.addActionListener(e -> new ExportDialog("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432", "").open());
        JPanel saveRegister = new JPanel(new GridBagLayout());
        saveRegister.setBorder(new TitledBorder("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432"));
        saveRegister.add((Component)exportButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return saveRegister;
    }

    protected JPanel getTopPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.getExportPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        return panel;
    }

    protected JPanel getFilterPanel() {
        return new JPanel();
    }

    protected void initTable(String mode, BGUTable table) {
        this.mode = mode;
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(e -> this.positionsEditor.editItem());
        popupMenu.addSeparator();
        popupMenu.add("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440").addActionListener(e -> this.openDocuments(false));
        popupMenu.add("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0432 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440").addActionListener(e -> this.openDocuments(true));
        popupMenu.add("\u041e\u0442\u043e\u0441\u043b\u0430\u0442\u044c \u043d\u0430 \u043f\u043e\u0447\u0442\u0443").addActionListener(actionEvent -> this.sendDocuments());
        popupMenu.addSeparator();
        popupMenu.add("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440").addActionListener(e -> this.gotoContract());
        popupMenu.addSeparator();
        this.countLabel.setFont(new Font("Arial", 1, 14));
        this.addPopupItems(popupMenu);
        table.setComponentPopupMenu(popupMenu);
        table.setSelectionMode(2);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BillServiceConfigTabbedPanel.this.openDocuments(false);
                }
            }
        });
        this.positionsEditor = new BillPositionsEditor((BGPanel)this, null, true, mode, this.tableModel);
    }

    private void openDocuments(boolean insert) {
        List<BillDoc> docs = this.getSelectedDocs();
        if (docs.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b");
        } else {
            this.showCardPanel("viewer");
            this.viewer.openDocuments(docs, insert);
        }
    }

    protected void showCardPanel(String name) {
        this.cardLayout.show(this.cardPanel, name);
    }

    protected List<BillDoc> getSelectedDocs() {
        ArrayList<BillDoc> result = new ArrayList<BillDoc>();
        for (Element rowElement : this.tableModel.getSelectedRows()) {
            BillDoc doc = new BillDoc();
            if (this.mode.equals("invoice")) {
                doc.type = DocumentType.INVOICE;
            }
            doc.cid = Utils.parseInt((String)rowElement.getAttribute("cid"));
            doc.docId = Utils.parseInt((String)rowElement.getAttribute("id"));
            doc.number = rowElement.getAttribute("number");
            result.add(doc);
        }
        return result;
    }

    protected String getSelectedIds() {
        StringBuffer codes = new StringBuffer();
        for (Element rowElement : this.tableModel.getSelectedRows()) {
            String docId = rowElement.getAttribute("id");
            if (codes.length() != 0) {
                codes.append(",");
            }
            codes.append(docId);
        }
        return codes.toString();
    }

    protected void updateCountLabel(String number, String summ) {
        this.countLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: " + new DecimalFormat("###,###,###,##0").format(new BigDecimal(number)) + ", \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 " + new DecimalFormat("###,###,###,##0.00").format(new BigDecimal(summ)));
    }

    protected void prepareFilters() throws Exception {
        ArrayList<IdTitle> packageItems = new ArrayList<IdTitle>();
        packageItems.add(new IdTitle(0, "=== \u043b\u044e\u0431\u0430\u044f ==="));
        Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("PackageList");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            XMLUtils.selectElements((Node)doc, (String)"//list/item").forEach(a -> packageItems.add(new IdTitle(Utils.parseInt((String)a.getAttribute("id")), a.getAttribute("title"))));
        }
        this.packageCb.setData(packageItems);
        this.packageCb.setSelectedIndex(0);
        Stream.of(SortMode.values()).forEach(a -> this.sortModeCb.addItem((Object)new IdTitle(a.getCode(), a.getTitle())));
        this.sortModeCb.setSelectedIndex(0);
        this.secondarySortModeCb.addItem((Object)new IdTitle(-1, "- \u043d\u0435\u0442 -"));
        Stream.of(SortMode.values()).forEach(a -> this.secondarySortModeCb.addItem((Object)new IdTitle(a.getCode(), a.getTitle())));
        this.secondarySortModeCb.setSelectedIndex(0);
    }

    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.viewer.init(module, moduleId);
        this.positionsEditor.init(module, moduleId);
    }

    private void sendDocuments() {
        this.tryCall(() -> {
            ((BillService)this.getContext().getWebService(BillService.class)).sendDocs(new DocumentSendParameters(Utils.toIntegerList((String)this.getSelectedIds()), Collections.emptyList(), "bill".equals(this.mode) ? DocumentSendParameters.SendingDataType.BILL : DocumentSendParameters.SendingDataType.INVOICE));
            ClientUtils.showMessageDialog((Object)"\u0417\u0430\u0434\u0430\u0447\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a");
        });
    }

    protected void gotoContract() {
        List rows = this.tableModel.getSelectedRows();
        if (rows.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else {
            for (Element rowElement : rows) {
                int contractId = Utils.parseInt((String)rowElement.getAttribute("cid"));
                if (contractId <= 0) continue;
                ClientUtils.openContract((int)contractId);
            }
        }
    }

    protected class ExportDialog
    extends BGEditorDialog<String> {
        private BillExportSaveFile billExportSaveFile;
        private BGUList<KeyValue> formatList;
        private ParameterTableModel parameterTableModel;
        private final JCheckBox saveOnServer;
        private BGSelectFilePanel selectFile;
        private BGTextArea description;

        public ExportDialog(String title, String data) {
            super(title, (Object)data);
            this.formatList = new BGUList();
            this.parameterTableModel = new ParameterTableModel();
            this.saveOnServer = new JCheckBox("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435");
            this.selectFile = new BGSelectFilePanel(true);
            this.description = new BGTextArea();
        }

        public void doDialogPanel() {
            this.panel.add((Component)this.getFormatPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.getTabbedPane(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.getFilePanel(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.tryCall(() -> this.formatList.setData(((BillService)BillServiceConfigTabbedPanel.this.getContext().getWebService(BillService.class)).exportFormats(BillServiceConfigTabbedPanel.this.mode)));
            this.formatList.setSelectionMode(0);
            this.formatList.addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting()) {
                    this.tryCall(() -> {
                        BillExportInfo billExportInfo = ((BillService)BillServiceConfigTabbedPanel.this.getContext().getWebService(BillService.class)).exportInfo(((KeyValue)this.formatList.getSelectedValue()).getKey());
                        this.billExportSaveFile = billExportInfo.getExportSaveFile();
                        this.description.setText(billExportInfo.getDescription());
                        this.selectFile.setFileFilter(this.billExportSaveFile.getFileExt(), this.billExportSaveFile.getFilterName());
                    });
                }
            });
        }

        private JPanel getFilePanel() {
            this.selectFile.setDialogTitle("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430");
            this.selectFile.setPreferredSize(new Dimension(500, 30));
            this.saveOnServer.setSelected(false);
            this.saveOnServer.addChangeListener(e -> this.selectFile.setEnabled(!this.saveOnServer.isSelected()));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0424\u0430\u0439\u043b: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
            panel.add((Component)this.selectFile, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
            panel.add((Component)this.saveOnServer, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getFormatPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0424\u043e\u0440\u043c\u0430\u0442 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.formatList, (int)300, (int)300), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JTabbedPane getTabbedPane() {
            BGUTable table = new BGUTable((TableModel)this.parameterTableModel);
            table.setSelectionMode(0);
            this.description.setEditable(false);
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430", BGSwingUtilites.wrapScrollPane((JComponent)table, (int)600, (int)300));
            tabbedPane.add("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", new JScrollPane((Component)this.description));
            return tabbedPane;
        }

        public boolean doApply() throws Exception {
            String exportClass = this.formatList.optSelectedValue().map(a -> a.getKey()).orElse(null);
            if (exportClass == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u043e\u0440\u043c\u0430\u0442 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430!");
                return false;
            }
            File file = this.selectFile.getSelectedFile();
            if (!this.saveOnServer.isSelected() && file == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
                return false;
            }
            try {
                BillListFilter billListFilter = BillServiceConfigTabbedPanel.this.getBillListFilter().setForRegister(true);
                String data = ((BillService)BillServiceConfigTabbedPanel.this.getContext().getWebService(BillService.class)).exportDocs(exportClass, billListFilter, this.saveOnServer.isSelected());
                if (!this.saveOnServer.isSelected()) {
                    if (data == null) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0420\u0435\u0435\u0441\u0442\u0440 \u041d\u0415 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 2);
                        return false;
                    }
                    ClientUtils.saveTextFile((String)data, (File)file, (String)this.billExportSaveFile.getFileExt());
                }
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0420\u0435\u0435\u0441\u0442\u0440 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
            return super.doApply();
        }
    }
}

