/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.util.Map;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUser;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostUsersPanel
extends ForpostBasePanel<ForpostService> {
    @Override
    protected void doRefresh() throws Exception {
        SearchResult searchResult = this.getForpostService().forpostUsersSearch(this.table.getSort(), this.pagePanel.getPage());
        ((UserTableModel)this.getTableModel()).setData(searchResult.getList());
        Page page = searchResult.getPage();
        this.records.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)page.getRecordCount()));
        this.pagePanel.setPage(page);
    }

    @Override
    protected void doSync() throws Exception {
        this.getForpostService().forpostUserSync();
        this.doRefresh();
    }

    @Override
    protected BGTableModel<?> getTableModel() throws BGException {
        if (this.tableModel == null) {
            this.tableModel = new UserTableModel(UserTableModel.class.getName());
        }
        return this.tableModel;
    }

    class UserTableModel
    extends BGTableModel<ForpostTMCAO<ForpostUser>> {
        public UserTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, 200, 300, "contractTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0410\u043a\u043a\u0430\u0443\u043d\u0442", 100, 200, 300, "accountName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041b\u043e\u0433\u0438\u043d", 300, 300, 300, "login", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u043e\u043b\u044c", 150, 150, 150, "isReadOnly", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("Email", 300, 500, -1, "email", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u0435\u043d", Boolean.class, 70, 70, 70, "isActive", true);
        }

        public Object getValueAt(ForpostTMCAO<ForpostUser> value, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            ForpostUser forpostUser = (ForpostUser)value.getObject();
            Map map = Utils.linesToPairsHash((String)forpostUser.getData());
            if ("id".equals(identifier)) {
                return forpostUser.getId();
            }
            if ("login".equals(identifier)) {
                return forpostUser.getLogin();
            }
            if ("isActive".equals(identifier)) {
                return forpostUser.getIsActive() == 1;
            }
            if ("email".equals(identifier)) {
                return map.get("Email");
            }
            if ("isReadOnly".equals(identifier)) {
                String isReadOnly = (String)map.get("IsReadOnly");
                return isReadOnly == null ? "" : (isReadOnly.equals("1") ? "\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c" : "\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440");
            }
            return super.getValueAt(value, column);
        }
    }
}

