/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.contract;

import java.util.Date;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.shop.common.bean.ContractStockItem;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.table.BGTableModel;

public final class ContractStockItemTableModel
extends BGTableModel<ContractStockItem> {
    private ClientContext clientContext;
    private Directory<UserInfo> directory;

    public ContractStockItemTableModel() {
        super("contractStockItemTable");
    }

    public void setClientContext(ClientContext context) {
        this.clientContext = context;
    }

    protected void initColumns() {
        this.addColumnId();
        this.addColumn("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", -1, 50, -1, "contractId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        this.addColumn("\u0422\u043e\u0432\u0430\u0440", -1, 200, -1, "stockItem", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430", -1, 200, -1, "dateFrom", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430", -1, 200, -1, "dateTo", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", -1, 200, -1, "userId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
    }

    public Object getValueAt(ContractStockItem val, int column) throws Exception {
        if (this.directory == null && this.clientContext != null) {
            this.directory = this.clientContext.getDirectory(UserInfo.class);
        }
        switch (column) {
            case 2: {
                return String.valueOf(val.getStockItem().getType()) + "[" + val.getStockItem().getId() + "]";
            }
            case 3: {
                return TimeUtils.format((Date)val.getDateFrom(), (String)"dd.MM.yyyy HH:mm");
            }
            case 4: {
                return TimeUtils.format((Date)val.getDateTo(), (String)"dd.MM.yyyy HH:mm");
            }
            case 5: {
                UserInfo userInfo = this.directory != null ? (UserInfo)this.directory.get(val.getUserId()) : null;
                return userInfo != null ? userInfo.getName() : "<\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
            }
        }
        return super.getValueAt((Object)val, column);
    }
}

