/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import bitel.billing.server.tariff.detail.TariffDetailUtils;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class RtServiceRangeTariffTreeNode
extends DefaultTariffTreeNode {
    private static final boolean debug = false;
    private static final int FOR_MONTH = 1;
    private static final int FOR_DAY = 2;
    private static final int FOR_CALC_PERIOD = 3;
    private long maxNodeAmount = 0L;
    private int forTime = 1;
    private Map<String, Long> contractAmounts = new ConcurrentHashMap<String, Long>(100, 20.0f);
    private String lastKey = "";
    private long lastAmount = 0L;
    int mode = 0;

    @Override
    public void init(String dataStr, int deep, int nodeID) {
        super.init(dataStr, deep, nodeID);
        Map<String, String> data = this.getDataInHash();
        int type = Utils.parseInt((String)data.get("type"), (int)-1);
        long col = Utils.parseLong((String)data.get("col"), (long)-1L);
        this.mode = Utils.parseInt((String)data.get("mode"), (int)0);
        this.forTime = Utils.parseInt((String)data.get("for_time"), (int)this.forTime);
        if (type >= 0 && col >= 0L) {
            this.maxNodeAmount = this.getServiceAmount(type, col);
        }
    }

    @Override
    public void processRequest(TariffRequest request) {
        String action = (String)request.getRequestParam("action");
        Integer cid = (Integer)request.getRequestParam("cid");
        Calendar periodEnd = (Calendar)request.getRequestParam("period_end");
        long maxNodeAmount = this.maxNodeAmount;
        Float part = null;
        if (this.forTime == 1 || this.forTime == 3) {
            if (this.mode == 1) {
                part = (Float)request.getRequestParam("part_service");
                if (part != null) {
                    maxNodeAmount = (long)((float)maxNodeAmount * part.floatValue());
                }
            } else if (this.mode == 2) {
                part = (Float)request.getRequestParam("part_tariff");
                if (part != null) {
                    maxNodeAmount = (long)((float)maxNodeAmount * part.floatValue());
                }
            } else if (this.mode == 3 && (part = (Float)request.getRequestParam("part_tariff_suspended")) != null) {
                maxNodeAmount = (long)((float)maxNodeAmount * part.floatValue());
            }
        }
        if (action != null && cid != null) {
            if (action.equals("reset")) {
                String cidStr = cid + "_";
                Iterator<String> it = this.contractAmounts.keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next();
                    if (!key.startsWith(cidStr)) continue;
                    it.remove();
                }
                request.setResponseParam("reset", "");
                this.lastKey = "";
                this.lastAmount = 0L;
            } else {
                Long amount = (Long)request.getRequestParam("amount");
                Calendar time = null;
                if (this.forTime == 1) {
                    time = (Calendar)request.getRequestParam("month_time");
                }
                if (time == null) {
                    time = (Calendar)request.getRequestParam("time");
                }
                if (amount != null && amount != 0L && time != null) {
                    long takedAmount = 0L;
                    Object in_mirror = request.getRequestParam("in_mirror");
                    if (amount < 0L && in_mirror == null) {
                        request.setRequestParam("in_mirror", "");
                        this.processForMirrorNode(request);
                    } else {
                        request.dropRequestParam("in_mirror");
                        String key = this.getKey(cid, time, periodEnd);
                        long nodeAmount = 0L;
                        if (key.equals(this.lastKey)) {
                            nodeAmount = this.lastAmount;
                        } else {
                            Long a = null;
                            a = this.contractAmounts.get(key);
                            if (a != null) {
                                nodeAmount = a;
                            }
                        }
                        long requestAmount = amount;
                        if (requestAmount > 0L && (nodeAmount < maxNodeAmount || maxNodeAmount == 0L) || requestAmount < 0L && nodeAmount > 0L) {
                            if (action.equals("init")) {
                                takedAmount = requestAmount > 0L ? (maxNodeAmount == 0L ? requestAmount : Math.min(maxNodeAmount - nodeAmount, requestAmount)) : Math.max(-nodeAmount, requestAmount);
                                this.contractAmounts.put(key, nodeAmount += takedAmount);
                            } else {
                                request.setNoAccepted();
                                request.dropResponseParam("cost");
                                request.dropResponseParam("divisor");
                                this.processForChilds(request);
                                Float cost = (Float)request.getResponseParam("cost");
                                Long divisor = (Long)request.getResponseParam("divisor");
                                if (request.wasAccepted() && cost != null && divisor != null && divisor != 0L) {
                                    Float costAmount;
                                    Float balance = (Float)request.getRequestParam("balance");
                                    if (requestAmount > 0L) {
                                        takedAmount = maxNodeAmount == 0L ? requestAmount : Math.min(maxNodeAmount - nodeAmount, requestAmount);
                                        if (balance != null && cost.floatValue() > 0.0f) {
                                            takedAmount = Math.min(takedAmount, (long)(balance.floatValue() / cost.floatValue() * divisor.floatValue()));
                                        }
                                    } else {
                                        takedAmount = Math.max(-nodeAmount, requestAmount);
                                    }
                                    float takedBalance = (float)takedAmount * cost.floatValue() / divisor.floatValue();
                                    if (balance != null) {
                                        balance = Float.valueOf(balance.floatValue() - takedBalance);
                                        request.setRequestParam("balance", balance);
                                    }
                                    if ((costAmount = (Float)request.getResponseParam("costAmount")) == null) {
                                        costAmount = Float.valueOf(0.0f);
                                    }
                                    costAmount = Float.valueOf(costAmount.floatValue() + takedBalance);
                                    request.setResponseParam("costAmount", costAmount);
                                    Integer sid = (Integer)request.getRequestParam("sid");
                                    TariffDetailUtils.processRequest(request, cid, sid, takedAmount, takedBalance, maxNodeAmount, cost.floatValue(), divisor);
                                }
                                request.dropResponseParam("cost");
                                request.dropResponseParam("divisor");
                            }
                        }
                        this.lastKey = key;
                        this.lastAmount = nodeAmount;
                        request.setRequestParam("amount", requestAmount -= takedAmount);
                    }
                }
            }
        } else {
            System.err.println("RtServiceRangeTariffTreeNode cid==NULL OR action==NULL");
        }
    }

    private String getKey(int cid, Calendar time, Calendar periodEnd) {
        StringBuffer result = new StringBuffer(8);
        result.append(cid);
        result.append("_");
        if (this.forTime == 2) {
            result.append(time.get(6));
        } else if (this.forTime == 1) {
            result.append(time.get(2));
        } else if (this.forTime == 3) {
            result.append(TimeUtils.formatDate((Calendar)periodEnd));
        }
        return result.toString();
    }
}

