/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.server.bean;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowValue;
import ru.bitel.bgbilling.kernel.table.common.dto.TableDto;
import ru.bitel.bgbilling.kernel.table.common.enums.BGUTableCellRenderer;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfo;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public abstract class BGTableInfoBase
implements BGTableInfo {
    protected int usetId = 0;
    protected Page page = null;
    protected BGUTableColumn[] columns;
    protected List<KeyValue> attributes = new ArrayList<KeyValue>();

    @Override
    public void setUserId(int userId) {
        this.usetId = userId;
    }

    @Override
    public List<BGUTableColumn> getColumns() throws Exception {
        return Arrays.asList(this.columns);
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public List<KeyValue> getAttributes() {
        return this.attributes;
    }

    protected BGTableInfoBase addAttribute(String key, String value) {
        this.attributes.add(new KeyValue(key, value));
        return this;
    }

    protected void addAttributes(String[][] attributes) {
        if (attributes == null) {
            return;
        }
        for (int i = 0; i < attributes.length; ++i) {
            String[] keyValue = attributes[i];
            if (keyValue.length <= 1) continue;
            this.addAttribute(keyValue[0], keyValue[1]);
        }
    }

    protected List<BGUTableRowValue> toValueList(Object object) throws Exception {
        ArrayList<BGUTableRowValue> values = new ArrayList<BGUTableRowValue>();
        List<BGUTableColumn> columns = this.getColumns();
        for (Method method : object.getClass().getMethods()) {
            BGUTableColumn column;
            String name;
            if (method.getParameterCount() != 0 || (name = method.getName().startsWith("get") ? StringUtils.uncapitalize((String)method.getName().substring(3)) : (method.getName().startsWith("is") ? StringUtils.uncapitalize((String)method.getName().substring(2)) : null)) == null || (column = (BGUTableColumn)columns.stream().filter(a -> a.getName().equals(name)).findFirst().orElse(null)) == null) continue;
            try {
                Object value = method.invoke(object, new Object[0]);
                BGUTableRowValue rowValue = new BGUTableRowValue();
                rowValue.setName(name);
                if (value instanceof Date) {
                    Date date = (Date)value;
                    rowValue.setValue(switch (column.getTableCellRenderer()) {
                        case BGUTableCellRenderer.DATE_TIME -> TimeUtils.format((Date)date, (String)"dd.MM.yyyy HH:mm:ss");
                        default -> String.valueOf(date);
                    });
                } else if (value instanceof LocalDateTime) {
                    LocalDateTime date = (LocalDateTime)value;
                    rowValue.setValue(switch (column.getTableCellRenderer()) {
                        case BGUTableCellRenderer.DATE_TIME -> TimeUtils.format((LocalDateTime)date, (String)"dd.MM.yyyy HH:mm:ss");
                        default -> String.valueOf(date);
                    });
                } else {
                    rowValue.setValue(String.valueOf(value));
                }
                values.add(rowValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return values;
    }

    protected BGUTableRowValue getUserName(Directory<UserInfo> directory, int userId) throws Exception {
        UserInfo userInfo = directory.get(userId);
        BGUTableRowValue tableRowValue = new BGUTableRowValue();
        tableRowValue.setName("userName");
        tableRowValue.setValue((String)(userInfo != null ? userInfo.getName() : "??? [ID=" + userId + "]"));
        return tableRowValue;
    }

    protected BGUTableRowValue getId(int id) {
        return new BGUTableRowValue("id", String.valueOf(id));
    }

    protected BGUTableRowValue getPeriod(Period period) {
        return new BGUTableRowValue("period", period.toString());
    }

    protected BGUTableRowValue getPeriodWithTime(Period period) {
        return new BGUTableRowValue("period", TimeUtils.formatPeriodWithTime((Period)period));
    }

    protected BGUTableRowValue getComment(String comment) {
        BGUTableRowValue tableRowValue = new BGUTableRowValue();
        tableRowValue.setName("comment");
        tableRowValue.setValue(comment);
        return tableRowValue;
    }

    protected BGUTableRowValue getDateTime(String name, Date value) {
        return this.getDateTime(name, value, "dd.MM.yyyy HH:mm:ss");
    }

    protected BGUTableRowValue getDate(String name, Date value) {
        return this.getDateTime(name, value, "dd.MM.yyyy");
    }

    protected BGUTableRowValue getDecimal(String name, BigDecimal value) {
        BGUTableRowValue tableRowValue = new BGUTableRowValue();
        tableRowValue.setName(name);
        tableRowValue.setValue(value.toString());
        return tableRowValue;
    }

    protected BGUTableRowValue getDateTime(String name, Date value, String dateFormat) {
        BGUTableRowValue tableRowValue = new BGUTableRowValue();
        tableRowValue.setName(name);
        tableRowValue.setValue(TimeUtils.format((Date)value, (String)dateFormat));
        return tableRowValue;
    }

    @Override
    public TableDto toTableDto() {
        String key = StringUtils.uncapitalize((String)this.getClass().getSimpleName().substring(5));
        TableDto dto = new TableDto();
        dto.setKey(key);
        dto.setTitle(key);
        return dto;
    }

    protected ServerContext getContext() {
        return (ServerContext)ServerContext.get();
    }
}

