/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;

public class RadiusAttributeSetRealmMap {
    private final Map<String, Map<Integer, RadiusAttributeSet>> realmMap;
    private final Map<Integer, RadiusAttributeSet> defaultRealmMap;

    public RadiusAttributeSetRealmMap(Map<String, Map<Integer, RadiusAttributeSet>> realmMap) {
        this.realmMap = realmMap;
        Map<Integer, RadiusAttributeSet> defaultRealmMap = realmMap.get("default");
        if (defaultRealmMap == null) {
            this.defaultRealmMap = new HashMap<Integer, RadiusAttributeSet>();
            realmMap.put("default", this.defaultRealmMap);
        } else {
            this.defaultRealmMap = defaultRealmMap;
        }
    }

    public RadiusAttributeSet get(Integer id) {
        return this.defaultRealmMap.get(id);
    }

    public RadiusAttributeSet get(String realm, Integer id) {
        if (realm == null || realm.length() == 0 || "default".equals(realm)) {
            return this.defaultRealmMap.get(id);
        }
        Map<Integer, RadiusAttributeSet> map = this.realmMap.get(realm);
        if (map == null) {
            return this.defaultRealmMap.get(id);
        }
        RadiusAttributeSet result = map.get(id);
        if (result != null) {
            return result;
        }
        return this.defaultRealmMap.get(id);
    }

    public void putAll(Map<Integer, RadiusAttributeSet> map) {
        this.defaultRealmMap.putAll(map);
    }

    public void putAll(RadiusAttributeSetRealmMap realmMap) {
        for (Map.Entry<String, Map<Integer, RadiusAttributeSet>> e : realmMap.realmMap.entrySet()) {
            String key = e.getKey();
            Map<Integer, RadiusAttributeSet> map = e.getValue();
            Map<Integer, RadiusAttributeSet> thisMap = this.realmMap.get(key);
            if (thisMap == null) {
                this.realmMap.put(key, new HashMap<Integer, RadiusAttributeSet>(map));
                continue;
            }
            thisMap.putAll(map);
        }
    }

    public void add(String realm, Integer id, RadiusAttributeSet set, boolean replace) {
        Map<Integer, RadiusAttributeSet> thisMap = this.realmMap.get(realm);
        if (thisMap == null) {
            thisMap = new HashMap<Integer, RadiusAttributeSet>();
            thisMap.put(id, set);
            this.realmMap.put(realm, thisMap);
        } else {
            RadiusAttributeSet thisSet = thisMap.get(id);
            if (thisSet == null) {
                thisMap.put(id, set);
            } else if (replace) {
                thisSet.setAttributes(set);
            } else {
                thisSet.addAttributes(set);
            }
        }
    }

    public void add(String realm, Integer id, RadiusAttributeSet set) {
        this.add(realm, id, set, false);
    }

    public Map<String, Map<Integer, RadiusAttributeSet>> getRealmMap() {
        return this.realmMap;
    }
}

