package ru.bitel.bgbilling.modules.inet.dyn.device.zte;

import java.util.Optional;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import ru.bitel.bgbilling.apps.inet.access.sa.ProtocolHandlerAdapter;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpProtocolHandler;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProtocolHandler;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpProcessor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.worker.Destroyable;

/**
 * Обработчик извлекает из DHCP 82 remoteId от ONT и подставляет его как логин, для последующего поиска по логину.
 * 
 * @author amir
 */
public class ZtePonRemoteIdProtocolHandler
    extends ProtocolHandlerAdapter
    implements RadiusProtocolHandler, DhcpProtocolHandler, Destroyable
{
    private static final Logger logger = LogManager.getLogger();

    @Override
    public void init( Setup setup, int moduleId, InetDevice inetDevice, InetDeviceType inetDeviceType, ParameterMap deviceConfig )
        throws Exception
    {
    }

    @Override
    public void preprocessDhcpRequest( DhcpPacket request, DhcpPacket response )
        throws Exception
    {
        final byte[] circuitId = Optional.ofNullable( request.getSubOption( (byte)1 ) ).map( a -> a.value ).orElse( null );
        final byte[] remoteId = Optional.ofNullable( request.getSubOption( (byte)2 ) ).map( a -> a.value ).orElse( null );

        if ( circuitId == null || remoteId == null )
        {
            logger.info( "Option circuitId or remoteId not found" );
            return;
        }

        // парсим значение как строку
        String circuitIdString = new String( circuitId, "UTF8" );
        String remoteIdString = new String( remoteId, "UTF8" );

        logger.info( "circuitId: " + circuitIdString );
        logger.info( "remoteId: " + remoteIdString );

        // устанавливаем remoteId как логин
        request.setOption( InetDhcpProcessor.LOGIN, remoteIdString );
    }
}
