/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.enums.CardPacketStatus;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.TariffRequestManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstarctDaoConstant;
import ru.bitel.common.sql.ConnectionSet;

public class CardPacketManager
extends AbstarctDaoConstant {
    private Connection con;
    private int mid;
    private int userId;

    public CardPacketManager(Connection con, int mid) {
        this(con, mid, 0);
    }

    public CardPacketManager(Connection con, int mid, int userId) {
        this.con = con;
        this.mid = mid;
        this.userId = userId;
    }

    public void updateCardPacket(CardPacket cardPacket) throws BGException {
        String query = null;
        PreparedStatement ps = null;
        try {
            if (cardPacket.getId() <= 0) {
                query = "INSERT INTO card_packet_" + this.mid + " ( cid, ucid, pid, date1, date2, comment, status ) VALUES (?, ?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE card_packet_" + this.mid + " SET cid=?, ucid=?, pid=?, date1=?, date2=?, comment=?, status=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(8, cardPacket.getId());
            }
            ps.setInt(1, cardPacket.getContractId());
            ps.setInt(2, cardPacket.getUsercardId());
            ps.setInt(3, cardPacket.getPacketId());
            ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((java.util.Date)cardPacket.getDateFrom()));
            ps.setTimestamp(5, TimeUtils.convertDateToTimestamp((java.util.Date)cardPacket.getDateTo()));
            ps.setString(6, cardPacket.getComment());
            ps.setInt(7, cardPacket.getStatus().getCode());
            ps.executeUpdate();
            if (cardPacket.getId() <= 0) {
                cardPacket.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public CardPacket getCardPacketById(int cardPacketId) throws BGException {
        CardPacket result = null;
        try {
            String query = "SELECT * FROM card_packet_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cardPacketId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new CardPacket();
                CardPacketManager.loadCardPacketFromRS(rs, result);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void deleteCardPacket(int cardPacketId) throws BGException {
        try {
            String query = "DELETE FROM card_packet_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cardPacketId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteCardPackets(int usercardId) throws BGException {
        try {
            String query = "DELETE FROM card_packet_" + this.mid + " WHERE ucid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, usercardId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<CardPacket> getCardPacketList(int contractId, int usercardId, java.util.Date date, boolean virtualCinema) throws BGException {
        return this.getCardPacketList(contractId, usercardId, -1, date, virtualCinema);
    }

    public List<CardPacket> getCardPacketList(int contractId, int usercardId, int objectId, java.util.Date date, boolean isVirtualCinema) throws BGException {
        ArrayList<CardPacket> result = new ArrayList<CardPacket>(7);
        try {
            StringBuilder query = new StringBuilder(300);
            query.append("SELECT card_packet.* FROM card_packet_").append(this.mid);
            query.append(" as card_packet LEFT JOIN packet_").append(this.mid);
            query.append(" as packet ON card_packet.pid=packet.id");
            if (objectId > 0) {
                query.append(" LEFT JOIN user_card_").append(this.mid);
                query.append(" AS uc ON uc.id=card_packet.ucid ");
            }
            query.append(" WHERE card_packet.cid=? ");
            if (objectId > 0) {
                query.append(" AND uc.object_id=").append(objectId);
            }
            if (usercardId > 0) {
                query.append(" AND ucid=").append(usercardId);
            }
            if (isVirtualCinema) {
                query.append(" AND (packet.virtual_cinema!=0)");
            } else {
                query.append(" AND (packet.virtual_cinema=0 OR packet.virtual_cinema IS NULL)");
            }
            if (date != null) {
                String sqlDate = TimeUtils.formatSQLDate((java.util.Date)date);
                query.append(" AND (card_packet.date1 IS NULL OR TO_DAYS(card_packet.date1)<=TO_DAYS('");
                query.append(sqlDate);
                query.append("'))");
                query.append(" AND (card_packet.date2 IS NULL OR TO_DAYS(card_packet.date2)>=TO_DAYS('");
                query.append(sqlDate);
                query.append("'))");
            }
            query.append(" ORDER BY date1");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CardPacket cardPacket = new CardPacket();
                result.add(cardPacket);
                CardPacketManager.loadCardPacketFromRS(rs, cardPacket);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException("error get CardPacket list", (Throwable)e);
        }
        return result;
    }

    public List<CardPacket> getFutureCardPacketList(int cid, int usercardId, java.util.Date date) throws BGException {
        ArrayList<CardPacket> result = new ArrayList<CardPacket>();
        try {
            String query = "SELECT * FROM card_packet_" + this.mid + " WHERE cid=? AND ucid=? AND TO_DAYS(date1) > TO_DAYS(?) ORDER BY date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, usercardId);
            ps.setDate(3, TimeUtils.convertDateToSqlDate((java.util.Date)date));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CardPacket cardPacket = new CardPacket();
                result.add(cardPacket);
                CardPacketManager.loadCardPacketFromRS(rs, cardPacket);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public boolean haveCardPackets(int userCardId) throws BGException {
        boolean result = false;
        try {
            String query = "SELECT COUNT(*) FROM card_packet_" + this.mid + " WHERE ucid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, userCardId);
            ResultSet rs = ps.executeQuery();
            result = rs.next() && rs.getInt(1) > 0;
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public boolean checkCardPackets(UserCard card) throws BGException {
        boolean result = false;
        try {
            String query = "SELECT COUNT(*) FROM card_packet_" + this.mid + " WHERE ucid=? AND ( ((date1 IS NULL AND ? IS NOT NULL) OR (? IS NOT NULL AND TO_DAYS(date1)<TO_DAYS(?))) OR ((date2 IS NULL AND ? IS NOT NULL) OR (? IS NOT NULL AND TO_DAYS(?)<TO_DAYS(date2))) )";
            PreparedStatement ps = this.con.prepareStatement(query);
            Date sqlDate1 = TimeUtils.convertDateToSqlDate((java.util.Date)card.getDate1());
            Date sqlDate2 = TimeUtils.convertDateToSqlDate((java.util.Date)card.getDate2());
            ps.setInt(1, card.getId());
            ps.setDate(2, sqlDate1);
            ps.setDate(3, sqlDate1);
            ps.setDate(4, sqlDate1);
            ps.setDate(5, sqlDate2);
            ps.setDate(6, sqlDate2);
            ps.setDate(7, sqlDate2);
            ResultSet rs = ps.executeQuery();
            result = rs.next() && rs.getInt(1) > 0;
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<CardPacket> getCalculateCardPacketList(java.util.Date fromDate, java.util.Date toDate, String cids, String ucids, String pids) throws BGException {
        ArrayList<CardPacket> result = new ArrayList<CardPacket>(1000);
        try {
            String query = "SELECT * FROM card_packet_" + this.mid + " WHERE " + (String)(Utils.notBlankString((String)cids) ? "cid IN (" + cids : "(1=1") + ") AND " + (String)(Utils.notBlankString((String)ucids) ? "ucid IN (" + ucids : "(1=1") + ") AND " + (String)(Utils.notBlankString((String)pids) ? "pid IN (" + pids : "(1=1") + ") AND (date1 IS NULL OR ? IS NULL OR TO_DAYS(date1)<=TO_DAYS(?)) AND (date2 IS NULL OR ? IS NULL OR TO_DAYS(?)<=TO_DAYS(date2)) ORDER BY ucid";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate((java.util.Date)toDate));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)toDate));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((java.util.Date)fromDate));
            ps.setDate(4, TimeUtils.convertDateToSqlDate((java.util.Date)fromDate));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CardPacket cardPacket = new CardPacket();
                result.add(cardPacket);
                CardPacketManager.loadCardPacketFromRS(rs, cardPacket);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<CardPacket> getCardPacketList(Calendar date) throws BGException {
        ArrayList<CardPacket> result = new ArrayList<CardPacket>();
        try {
            String query = "SELECT card_packet.* FROM card_packet_" + this.mid + " as card_packet LEFT JOIN packet_" + this.mid + " as packet ON card_packet.pid=packet.id WHERE ((packet.virtual_cinema!=0 AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)) OR (packet.virtual_cinema=0 AND (date1 IS NULL OR TO_DAYS(date1)<=TO_DAYS(?)) AND (date2 IS NULL OR TO_DAYS(?)<=TO_DAYS(date2))))";
            PreparedStatement ps = this.con.prepareStatement(query);
            Timestamp time = TimeUtils.convertCalendarToTimestamp((Calendar)date);
            ps.setTimestamp(1, time);
            ps.setTimestamp(2, time);
            ps.setTimestamp(3, time);
            ps.setTimestamp(4, time);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CardPacket cardPacket = new CardPacket();
                CardPacketManager.loadCardPacketFromRS(rs, cardPacket);
                result.add(cardPacket);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<CardPacket> getActiveCardPacketList(Calendar date, final Integer userCardId) throws BGException {
        return this.getActiveCardPacketList(date, (Collection<Integer>)(userCardId != null ? new ArrayList<Integer>(){
            {
                this.add(userCardId);
            }
        } : null));
    }

    public List<CardPacket> getActiveCardPacketList(Calendar date, Collection<Integer> userCardIds) throws BGException {
        ArrayList<CardPacket> result = new ArrayList<CardPacket>();
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "SELECT card_packet.* FROM card_packet_" + this.mid + " as card_packet LEFT JOIN packet_" + this.mid + " as packet ON card_packet.pid=packet.id WHERE ((packet.virtual_cinema!=0 AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)) OR (packet.virtual_cinema=0 AND (date1 IS NULL OR TO_DAYS(date1)<=TO_DAYS(?)) AND (date2 IS NULL OR TO_DAYS(?)<=TO_DAYS(date2))))  AND status=? ";
            if (userCardIds != null) {
                query = query + " AND ucid in (" + Utils.toString(userCardIds) + ")";
            }
            query = query + " ORDER BY card_packet.cid, card_packet.ucid";
            ps = this.con.prepareStatement(query);
            Timestamp time = TimeUtils.convertCalendarToTimestamp((Calendar)date);
            ps.setTimestamp(1, time);
            ps.setTimestamp(2, time);
            ps.setTimestamp(3, time);
            ps.setTimestamp(4, time);
            ps.setInt(5, CardPacketStatus.STATUS_ACTIVE.getCode());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    CardPacket cardPacket = new CardPacket();
                    CardPacketManager.loadCardPacketFromRS(rs, cardPacket);
                    result.add(cardPacket);
                }
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<CardPacket> getStatusedCardPacketList(Calendar date, int cid, CardPacketStatus cardPacketStatus) throws BGException {
        ArrayList<CardPacket> result = new ArrayList<CardPacket>();
        try {
            String query = "SELECT card_packet.* FROM card_packet_" + this.mid + " as card_packet LEFT JOIN packet_" + this.mid + " as packet ON card_packet.pid=packet.id WHERE ((packet.virtual_cinema!=0 AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)) OR (packet.virtual_cinema=0 AND (date1 IS NULL OR TO_DAYS(date1)<=TO_DAYS(?)) AND (date2 IS NULL OR TO_DAYS(?)<=TO_DAYS(date2))))  AND status=? AND cid=? ORDER BY card_packet.cid, card_packet.ucid";
            PreparedStatement ps = this.con.prepareStatement(query);
            Timestamp time = TimeUtils.convertCalendarToTimestamp((Calendar)date);
            ps.setTimestamp(1, time);
            ps.setTimestamp(2, time);
            ps.setTimestamp(3, time);
            ps.setTimestamp(4, time);
            ps.setInt(5, cardPacketStatus.getCode());
            ps.setInt(6, cid);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    CardPacket cardPacket = new CardPacket();
                    CardPacketManager.loadCardPacketFromRS(rs, cardPacket);
                    result.add(cardPacket);
                }
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    @Deprecated
    public List<CardPacket> getContractActiveCardPacketList(Calendar date, int cid) throws BGException {
        return this.getStatusedCardPacketList(date, cid, CardPacketStatus.STATUS_ACTIVE);
    }

    public CardPacket getCardPacket(int usercardId, int packetId, java.util.Date date) throws BGException {
        CardPacket result = null;
        try {
            String query = "SELECT card_packet.* FROM card_packet_" + this.mid + " as card_packet  LEFT JOIN packet_" + this.mid + " as packet ON card_packet.pid=packet.id  WHERE ucid=? AND pid=? AND ((packet.virtual_cinema=0 AND (date1 IS NULL OR TO_DAYS(date1)<=TO_DAYS(?)) AND (date2 IS NULL OR TO_DAYS(date2)>=TO_DAYS(?))) OR (packet.virtual_cinema!=0 AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)))";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, usercardId);
            ps.setInt(2, packetId);
            Timestamp timestamp = TimeUtils.convertDateToTimestamp((java.util.Date)date);
            ps.setTimestamp(3, timestamp);
            ps.setTimestamp(4, timestamp);
            ps.setTimestamp(5, timestamp);
            ps.setTimestamp(6, timestamp);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new CardPacket();
                CardPacketManager.loadCardPacketFromRS(rs, result);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<CardPacket> getCardPacketList(int cid, java.util.Date date) throws BGException {
        ArrayList<CardPacket> result = new ArrayList<CardPacket>();
        try {
            String query = "SELECT * FROM card_packet_" + this.mid + " WHERE cid=?";
            if (date != null) {
                query = query + " AND (date1 IS NULL OR TO_DAYS(date1)<=TO_DAYS(?)) AND (date2 IS NULL OR TO_DAYS(date2)>=TO_DAYS(?))";
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            if (date != null) {
                ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)date));
                ps.setDate(3, TimeUtils.convertDateToSqlDate((java.util.Date)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CardPacket cardPacket = new CardPacket();
                CardPacketManager.loadCardPacketFromRS(rs, cardPacket);
                result.add(cardPacket);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<CardPacket> getCardPacketList(int userCardId) throws BGException {
        ArrayList<CardPacket> result = new ArrayList<CardPacket>();
        try {
            String query = "SELECT * FROM card_packet_" + this.mid + " WHERE ucid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, userCardId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CardPacket cardPacket = new CardPacket();
                CardPacketManager.loadCardPacketFromRS(rs, cardPacket);
                result.add(cardPacket);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<CardPacket> getCardPacketListByPacketId(int packetId) throws BGException {
        ArrayList<CardPacket> result = new ArrayList<CardPacket>();
        try {
            String query = "SELECT * FROM card_packet_" + this.mid + " WHERE pid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, packetId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CardPacket cardPacket = new CardPacket();
                CardPacketManager.loadCardPacketFromRS(rs, cardPacket);
                result.add(cardPacket);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private static void loadCardPacketFromRS(ResultSet rs, CardPacket cardPacket) throws SQLException {
        cardPacket.setId(rs.getInt("id"));
        cardPacket.setContractId(rs.getInt("cid"));
        cardPacket.setUsercardId(rs.getInt("ucid"));
        cardPacket.setPacketId(rs.getInt("pid"));
        cardPacket.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date1")));
        cardPacket.setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date2")));
        cardPacket.setComment(rs.getString("comment"));
        cardPacket.setStatus(CardPacketStatus.getCardPacketStatusByCode((int)rs.getInt("status")));
    }

    private Set<Integer> getPacketGroup(ConnectionSet connectionSet, ParameterMap moduleSetup, int cid, Calendar date) throws BGException {
        TariffRequestManager trm = new TariffRequestManager(connectionSet, this.mid);
        return trm.getPacketGroup(moduleSetup, cid, date);
    }

    public void openCardPackets(ConnectionSet connectionSet, ParameterMap moduleSetup, Map<Integer, Packet> packetMap, int cid, int usercardId, List<CardPacket> add, Calendar now, boolean check) throws BGException {
        List<CardPacket> currentPacketList = this.getCardPacketList(cid, usercardId, null, false);
        Set<Integer> packetGroup = this.getPacketGroup(connectionSet, moduleSetup, cid, now);
        ArrayList<CardPacket> remove = new ArrayList<CardPacket>();
        ArrayList<CardPacket> update = new ArrayList<CardPacket>();
        StringBuilder errors = new StringBuilder();
        if (packetGroup != null) {
            for (CardPacket cp : add) {
                String result;
                if (!packetGroup.contains(cp.getPacketId()) || (result = CardPacketManager.checkGroup(packetGroup, currentPacketList, cp, now.getTime(), update, remove)) == null) continue;
                errors.append(result).append("\n");
            }
        }
        currentPacketList.addAll(add);
        if (packetGroup != null && !CardPacketManager.haveDepends(currentPacketList, now.getTime(), null, packetGroup)) {
            errors.append("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0431\u0430\u0437\u043e\u0432\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u043e\u0432\n");
        }
        boolean checkOld = moduleSetup.getInt("cerbercrypt.cardpacket.checkold", 1) > 0;
        List<CardPacket> checkCardPacketList = checkOld ? currentPacketList : add;
        CardPacketManager.checkDepend(checkCardPacketList, currentPacketList, packetMap, errors);
        CardPacketManager.checkUnacceptable(checkCardPacketList, add, packetMap, errors);
        CardPacketManager.checkUnacceptable(add, currentPacketList, packetMap, errors);
        if (check && errors.length() > 0) {
            errors.setLength(errors.length() - 1);
            throw new BGMessageException(errors.toString());
        }
        for (CardPacket cp : update) {
            this.updateCardPacket(cp);
        }
        for (CardPacket cp : remove) {
            this.deleteCardPacket(cp.getId());
        }
        for (CardPacket cp : add) {
            this.updateCardPacket(cp);
        }
    }

    private static void checkDepend(List<CardPacket> checkCardPacketList, List<CardPacket> currentPacketList, Map<Integer, Packet> packetMap, StringBuilder errors) {
        Logger log = LoggerFactory.getLogger(CardPacketManager.class);
        for (CardPacket cp : checkCardPacketList) {
            Packet packet = packetMap.get(cp.getPacketId());
            if (packet != null) {
                if (packet.getDepends().size() == 0 || CardPacketManager.haveDepends(currentPacketList, cp.getDateFrom(), cp.getDateTo(), packet.getDepends())) continue;
                StringBuilder packets = new StringBuilder();
                for (Integer id : packet.getDepends()) {
                    Packet p = packetMap.get(id);
                    if (p != null) {
                        packets.append(p.getTitle()).append(", ");
                        continue;
                    }
                    log.error("Depend packet not found=" + id + " for packet " + packet.getId());
                }
                if (packets.length() > 0) {
                    packets.setLength(packets.length() - 2);
                }
                errors.append("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442 ").append(packet.getTitle()).append(" \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0430 \u043e\u0434\u0438\u043d \u0438\u0437 \u043f\u0430\u043a\u0435\u0442\u043e\u0432: ").append((CharSequence)packets).append("\n");
                continue;
            }
            log.error("Packet not found=" + cp.getPacketId());
        }
    }

    static final void logCardPacketList(List<CardPacket> l, Map<Integer, Packet> packetMap) {
        for (CardPacket cp : l) {
            Packet p = packetMap.get(cp.getPacketId());
            System.out.println("  " + p.getTitle() + " | " + String.valueOf(cp.getDateFrom()) + "-" + String.valueOf(cp.getDateTo()) + " | unaccept: " + Utils.toString((Iterable)p.getUnacceptable()));
        }
    }

    private static void checkUnacceptable(List<CardPacket> checkCardPacketList, List<CardPacket> add, Map<Integer, Packet> packetMap, StringBuilder errors) {
        Logger log = LoggerFactory.getLogger(CardPacketManager.class);
        for (CardPacket cp : checkCardPacketList) {
            Packet packet = packetMap.get(cp.getPacketId());
            if (packet == null) {
                log.error("Packet not found=" + cp.getPacketId());
                continue;
            }
            if (packet.getUnacceptable().size() == 0) continue;
            Set<Integer> currentPackets = CardPacketManager.packetsIds(CardPacketManager.filterJoins(add, cp.getDateFrom(), cp.getDateTo(), cp));
            ArrayList unacceptable = new ArrayList(packet.getUnacceptable());
            unacceptable.retainAll(currentPackets);
            if (unacceptable.size() <= 0) continue;
            StringBuilder packets = new StringBuilder();
            for (Integer id : unacceptable) {
                Packet p = packetMap.get(id);
                if (p != null) {
                    packets.append(p.getTitle()).append(", ");
                    continue;
                }
                log.error("Unacceptable packet not found=" + id + " for packet " + packet.getId());
            }
            if (packets.length() > 0) {
                packets.setLength(packets.length() - 2);
            }
            errors.append("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442\u044b: ").append((CharSequence)packets).append("\n");
        }
    }

    public void removeCardPackets(ConnectionSet connectionSet, ParameterMap moduleSetup, Map<Integer, Packet> packetMap, int cid, int cardId, List<CardPacket> remove, Calendar now, boolean check) throws BGException {
        List<CardPacket> currentPacketList = this.getCardPacketList(cid, cardId, null, false);
        Set<Integer> packetGroup = this.getPacketGroup(connectionSet, moduleSetup, cid, now);
        StringBuilder errors = new StringBuilder();
        if (packetGroup != null && !Collections.disjoint(packetGroup, CardPacketManager.packetsIds(remove))) {
            StringBuilder packets = new StringBuilder();
            for (Integer id : packetGroup) {
                Packet p = packetMap.get(id);
                if (p != null) {
                    packets.append(p.getTitle()).append(", ");
                    continue;
                }
                this.getLogger().error("Group packet not found=" + id);
            }
            errors.append("\u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0435\u0433\u043e \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430 \u043e\u0434\u0438\u043d \u0438\u0437: ").append((CharSequence)packets).append("\n");
        }
        currentPacketList.removeAll(remove);
        CardPacketManager.checkDepend(currentPacketList, currentPacketList, packetMap, errors);
        if (check && errors.length() > 0) {
            errors.setLength(errors.length() - 1);
            throw new BGMessageException(errors.toString());
        }
        for (CardPacket cp : remove) {
            this.deleteCardPacket(cp.getId());
        }
    }

    public void closeCardPackets(ConnectionSet connectionSet, ParameterMap moduleSetup, Map<Integer, Packet> packetMap, int cid, int cardId, List<CardPacket> close, java.util.Date closeDate, Calendar now, boolean check) throws BGException {
        List<CardPacket> currentPacketList = this.getCardPacketList(cid, cardId, null, false);
        Set<Integer> packetGroup = this.getPacketGroup(connectionSet, moduleSetup, cid, now);
        StringBuilder errors = new StringBuilder();
        if (packetGroup != null && !Collections.disjoint(packetGroup, CardPacketManager.packetsIds(close))) {
            StringBuilder packets = new StringBuilder();
            for (Integer id : packetGroup) {
                Packet p = packetMap.get(id);
                if (p != null) {
                    packets.append(p.getTitle()).append(", ");
                    continue;
                }
                this.getLogger().error("Group packet not found=" + id);
            }
            errors.append("\u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u044c, \u0435\u0433\u043e \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430 \u043e\u0434\u0438\u043d \u0438\u0437: ").append((CharSequence)packets).append("\n");
        }
        for (CardPacket cp : close) {
            cp.setDateTo(closeDate);
        }
        currentPacketList.removeAll(close);
        currentPacketList.addAll(close);
        CardPacketManager.checkDepend(currentPacketList, currentPacketList, packetMap, errors);
        if (check && errors.length() > 0) {
            errors.setLength(errors.length() - 1);
            throw new BGMessageException(errors.toString());
        }
        for (CardPacket cp : close) {
            this.updateCardPacket(cp);
        }
    }

    public void updateCardPackets(ConnectionSet connectionSet, ParameterMap moduleSetup, Map<Integer, Packet> packetMap, int cid, int cardId, List<CardPacket> update, Calendar now, boolean check) throws BGException {
        List<CardPacket> currentPacketList = this.getCardPacketList(cid, cardId, null, false);
        Set<Integer> packetGroup = this.getPacketGroup(connectionSet, moduleSetup, cid, now);
        ArrayList<CardPacket> needUpdate = new ArrayList<CardPacket>();
        ArrayList<CardPacket> needRemove = new ArrayList<CardPacket>();
        StringBuilder errors = new StringBuilder();
        if (packetGroup != null) {
            for (CardPacket cp : update) {
                String result;
                if (!packetGroup.contains(cp.getPacketId()) || (result = CardPacketManager.checkGroup(packetGroup, currentPacketList, cp, now.getTime(), needUpdate, needRemove)) == null) continue;
                errors.append(result).append("\n");
            }
        }
        currentPacketList.removeAll(update);
        currentPacketList.addAll(update);
        if (packetGroup != null && !CardPacketManager.haveDepends(currentPacketList, now.getTime(), null, packetGroup)) {
            errors.append("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0431\u0430\u0437\u043e\u0432\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u043e\u0432\n");
        }
        CardPacketManager.checkDepend(currentPacketList, currentPacketList, packetMap, errors);
        if (check && errors.length() > 0) {
            errors.setLength(errors.length() - 1);
            throw new BGMessageException(errors.toString());
        }
        for (CardPacket cp : needUpdate) {
            this.updateCardPacket(cp);
        }
        for (CardPacket cp : needRemove) {
            this.deleteCardPacket(cp.getId());
        }
        for (CardPacket cp : update) {
            this.updateCardPacket(cp);
        }
    }

    private static boolean haveDepends(List<CardPacket> cardPacketList, java.util.Date date1, java.util.Date date2, Collection<Integer> depends) {
        ArrayList<Calendar[]> periods = new ArrayList<Calendar[]>();
        block0: for (CardPacket cp : cardPacketList) {
            if (!depends.contains(cp.getPacketId())) continue;
            Calendar[] period = new Calendar[]{TimeUtils.convertDateToCalendar((java.util.Date)cp.getDateFrom()), TimeUtils.convertDateToCalendar((java.util.Date)cp.getDateTo())};
            block1: while (period != null) {
                Iterator iter = periods.iterator();
                while (iter.hasNext()) {
                    Calendar[] p = (Calendar[])iter.next();
                    if (p[0] != null && period[1] != null && TimeUtils.compare((Calendar)TimeUtils.plusPeriod((Calendar)p[0], (int)5, (int)-1), (Calendar)period[1], (int)5) > 0 || p[1] != null && period[0] != null && TimeUtils.compare((Calendar)TimeUtils.plusPeriod((Calendar)period[0], (int)5, (int)-1), (Calendar)p[1], (int)5) > 0) continue;
                    if (p[0] == null || period[0] == null) {
                        p[0] = null;
                    } else {
                        Calendar calendar = p[0] = TimeUtils.dateBefore((Calendar)p[0], (Calendar)period[0]) ? p[0] : period[0];
                    }
                    p[1] = p[1] == null || period[1] == null ? null : (TimeUtils.dateBefore((Calendar)p[1], (Calendar)period[1]) ? period[1] : p[1]);
                    period = p;
                    iter.remove();
                    continue block1;
                }
                periods.add(period);
                continue block0;
            }
        }
        for (Calendar[] p : periods) {
            if (!TimeUtils.periodInRange((Calendar)TimeUtils.convertDateToCalendar((java.util.Date)date1), (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)date2), (Calendar)p[0], (Calendar)p[1])) continue;
            return true;
        }
        return false;
    }

    private static List<CardPacket> filterJoins(List<CardPacket> cardPacketList, java.util.Date date1, java.util.Date date2, CardPacket without) {
        ArrayList<CardPacket> result = new ArrayList<CardPacket>();
        for (CardPacket cp : cardPacketList) {
            if (without == cp || date1 != null && cp.getDateTo() != null && !TimeUtils.dateBeforeOrEq((java.util.Date)date1, (java.util.Date)cp.getDateTo()) || date2 != null && cp.getDateFrom() != null && !TimeUtils.dateBeforeOrEq((java.util.Date)cp.getDateFrom(), (java.util.Date)date2)) continue;
            result.add(cp);
        }
        return result;
    }

    private static String checkGroup(Set<Integer> packetGroup, List<CardPacket> currentPacketList, CardPacket cardPacket, java.util.Date now, List<CardPacket> needUpdate, List<CardPacket> needRemove) throws BGMessageException {
        java.util.Date date = cardPacket.getDateFrom();
        java.util.Date closeDate = TimeUtils.plusPeriod((java.util.Date)date, (int)5, (int)-1);
        Iterator<CardPacket> iter = currentPacketList.iterator();
        while (iter.hasNext()) {
            CardPacket cp = iter.next();
            if (cp.equals((Object)cardPacket) || !packetGroup.contains(cp.getPacketId())) continue;
            if (TimeUtils.dateBeforeOrEq((java.util.Date)date, (java.util.Date)cp.getDateFrom())) {
                if (now != null && TimeUtils.dateBeforeOrEq((java.util.Date)date, (java.util.Date)now)) {
                    return "\u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u0440\u0443\u0433\u0438\u043c \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u0432\u0442\u0440\u0430\u0448\u043d\u0438\u043c \u0434\u043d\u0435\u043c";
                }
                needRemove.add(cp);
                iter.remove();
                continue;
            }
            if (!TimeUtils.dateInRange((java.util.Date)date, (java.util.Date)cp.getDateFrom(), (java.util.Date)cp.getDateTo())) continue;
            cp.setDateTo(closeDate);
            needUpdate.add(cp);
        }
        return null;
    }

    private static Set<Integer> packetsIds(List<CardPacket> cardPacketList) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (CardPacket cp : cardPacketList) {
            result.add(cp.getPacketId());
        }
        return result;
    }

    public void synchronizeCardPacketFromTo(int uidSrc, int uidDest, Set<Integer> ignorePackets, java.util.Date newDateFrom) throws BGException {
        List<CardPacket> cardpacketsBasecard = this.getCardPacketList(uidSrc);
        List<CardPacket> cardpacketsCopycard = this.getCardPacketList(uidDest);
        if (ignorePackets != null) {
            ArrayList<CardPacket> cardpacketsBasecardFilter = new ArrayList<CardPacket>(cardpacketsBasecard);
            for (CardPacket cardpacket : cardpacketsBasecard) {
                if (!ignorePackets.contains(cardpacket.getPacketId())) continue;
                this.getLogger().debug("synchronizeCardPacket: ignore cardpacket for synchronize (see tariff?): " + cardpacket.toString());
                cardpacketsBasecardFilter.remove(cardpacket);
            }
            cardpacketsBasecard = cardpacketsBasecardFilter;
        }
        if (!CardPacketManager.isEqualSubscribe(cardpacketsBasecard, cardpacketsCopycard)) {
            this.getLogger().debug("synchronizeCardPacket: delete cardpackets: uid=" + uidDest);
            this.deleteCardPackets(uidDest);
            for (CardPacket cardpacket : cardpacketsBasecard) {
                this.getLogger().debug("synchronizeCardPacket: copy cardpacket: " + cardpacket.toString());
                cardpacket.setUsercardId(uidDest);
                cardpacket.setId(-1);
                cardpacket.setComment("\u043a\u043e\u043f\u0438\u044f \u0441 uid=" + uidSrc);
                if (newDateFrom != null) {
                    cardpacket.setDateFrom(newDateFrom);
                }
                this.updateCardPacket(cardpacket);
            }
        } else {
            this.getLogger().debug("synchronizeCardPacket: equals subscribe, do nothing");
        }
    }

    protected static boolean isEqualSubscribe(List<CardPacket> list1, List<CardPacket> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null && list2 != null || list1 != null && list2 == null || list1.size() != list2.size()) {
            return false;
        }
        list1 = new ArrayList<CardPacket>(list1);
        list2 = new ArrayList<CardPacket>(list2);
        CardPacket.CardPacketComparator comparator = new CardPacket.CardPacketComparator();
        Collections.sort(list1, comparator);
        Collections.sort(list2, comparator);
        for (int i = 0; i < list1.size(); ++i) {
            if (comparator.compare(list1.get(i), list2.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public void truncatePacketsToCard(UserCard uc) throws BGException {
        java.util.Date date1 = uc.getDate1();
        java.util.Date date2 = uc.getDate2();
        List<CardPacket> cardpackets = this.getCardPacketList(uc.getId());
        for (CardPacket cardpacket : cardpackets) {
            java.util.Date packetDate1 = cardpacket.getDateFrom();
            java.util.Date packetDate2 = cardpacket.getDateTo();
            if (TimeUtils.dateBefore((java.util.Date)packetDate1, (java.util.Date)date1)) {
                cardpacket.setDateFrom(date1);
                this.getLogger().info("cardpacket of card '" + uc.getGuiTitle() + "' will be truncated from LEFT (" + TimeUtils.formatDate((java.util.Date)packetDate1) + "->" + TimeUtils.formatDate((java.util.Date)date1) + ")");
                this.updateCardPacket(cardpacket);
            }
            if (date2 == null || packetDate2 != null && !TimeUtils.dateBefore((java.util.Date)date2, (java.util.Date)packetDate2)) continue;
            cardpacket.setDateTo(date2);
            this.getLogger().info("cardpacket of card '" + uc.getGuiTitle() + "' will be truncated from RIGHT (" + TimeUtils.formatDate((java.util.Date)packetDate2) + "->" + TimeUtils.formatDate((java.util.Date)date2) + ")");
            this.updateCardPacket(cardpacket);
        }
    }

    public void replaceCardPackets(int cid, java.util.Date dateFrom, Set<Integer> newPacketIds, String commentOpen, String commentClose) throws Exception {
        for (UserCard uc : new UserCardManager(this.con, this.mid, this.userId).getList(cid, dateFrom)) {
            this.replaceCardPacketsUserCard(uc, dateFrom, newPacketIds, commentOpen, commentClose);
        }
    }

    public void replaceCardPacketsUserCard(UserCard uc, java.util.Date dateFrom, Set<Integer> newPacketIds, String commentOpen, String commentClose) throws BGException {
        java.util.Date oldSubscrDateTo = TimeUtils.getPrevDay((java.util.Date)dateFrom);
        for (CardPacket cp : this.getFutureCardPacketList(uc.getContractId(), uc.getId(), oldSubscrDateTo)) {
            this.deleteCardPacket(cp.getId());
        }
        for (CardPacket cp : this.getCardPacketList(uc.getContractId(), uc.getId(), -1, dateFrom, false)) {
            cp.setDateTo(oldSubscrDateTo);
            cp.setComment(Utils.maskNull((String)cp.getComment()) + commentClose);
            this.updateCardPacket(cp);
        }
        for (Integer packetId : newPacketIds) {
            CardPacket cardPacket = new CardPacket();
            cardPacket.setContractId(uc.getContractId());
            cardPacket.setUsercardId(uc.getId());
            cardPacket.setPacketId(packetId.intValue());
            cardPacket.setDateFrom(dateFrom);
            cardPacket.setDateTo(uc.getDate2());
            cardPacket.setComment(commentOpen);
            this.updateCardPacket(cardPacket);
        }
    }

    public List<CardPacket> checkConflictSamePackets(Integer userCardId, Integer packetId, java.util.Date dateFrom, java.util.Date dateTo, Integer selfCardPacketId) throws BGException {
        List<CardPacket> findCp = this.getCalculateCardPacketList(dateFrom, dateTo, null, String.valueOf(userCardId), String.valueOf(packetId));
        return findCp.stream().filter(cp -> selfCardPacketId == null || cp.getId() != selfCardPacketId.intValue()).collect(Collectors.toList());
    }
}

