/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.server.task;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.payonline.common.bean.Rebill;
import ru.bitel.bgbilling.modules.payonline.server.bean.RebillManager;
import ru.bitel.bgbilling.modules.payonline.server.bean.RebillWorker;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.concurrent.ConcurrentUtils;

public class RebillTask
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            this.getLogger().info("\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u0434\u0430\u0447\u0438.");
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            boolean rebill = moduleSetup.getBoolean("rebill", false);
            String rebillUrl = moduleSetup.get("rebill.url", null);
            String merchantId = moduleSetup.get("merchant.id", "");
            String privateSecKey = moduleSetup.get("private.security.key", "");
            if (!rebill) {
                this.getLogger().info("Rebill  is switch off in module config.");
                return;
            }
            if (Utils.isBlankString((String)rebillUrl) || Utils.isBlankString((String)merchantId) || Utils.isBlankString((String)privateSecKey)) {
                this.getLogger().error("\u041c\u043e\u0434\u0443\u043b\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u043e!");
                return;
            }
            GregorianCalendar c = new GregorianCalendar();
            int dayOfWeek = this.getDayOfWeek(c);
            int dayOfMonth = c.get(5);
            RebillManager rebillManager = new RebillManager(con, this.moduleId);
            this.getLogger().info("\u0412\u044b\u0431\u0438\u0440\u0430\u0435\u043c \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u0441 \u043d\u0435\u0434\u0435\u043b\u044c\u043d\u043e\u0439 \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c\u044e [dayOfWeek=" + dayOfWeek + "]");
            List<Rebill> rebillTransactionList = rebillManager.getList(dayOfWeek, 1);
            this.getLogger().info("\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0439 \u043d\u0435\u0434\u0435\u043b\u044c\u043d\u044b\u0445 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 - " + rebillTransactionList.size());
            this.getLogger().info("\u0412\u044b\u0431\u0438\u0440\u0430\u0435\u043c \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u0441 \u043c\u0435\u0441\u044f\u0447\u043d\u043e\u0439 \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c\u044e [dayOfMonth=" + dayOfMonth + "]");
            List<Rebill> rebillTransactionListMonth = rebillManager.getList(dayOfMonth, 2);
            this.getLogger().info("\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0439 \u043c\u0435\u0441\u044f\u0447\u043d\u044b\u0445 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 - " + rebillTransactionListMonth.size());
            rebillTransactionList.addAll(rebillTransactionListMonth);
            if (dayOfMonth == ((Calendar)c).getActualMaximum(5)) {
                this.getLogger().info("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0434\u0435\u043d\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0432 \u043c\u0435\u0441\u044f\u0446\u0435, \u0438\u0449\u0435\u043c \u0430\u0432\u0442\u043e\u043f\u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0435 \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u043f\u043e\u0437\u0434\u043d\u0438\u0435 \u0434\u043d\u0438 \u043c\u0435\u0441\u044f\u0446\u0430");
                for (int i = dayOfMonth + 1; i <= 31; ++i) {
                    this.getLogger().info("\u0412\u044b\u0431\u0438\u0440\u0430\u0435\u043c \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u0441 \u043c\u0435\u0441\u044f\u0447\u043d\u043e\u0439 \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c\u044e \u043d\u0430 \u0434\u0435\u043d\u044c \u043c\u0435\u0441\u044f\u0446\u0430 [dayOfMonth=" + i + "]");
                    List<Rebill> rebillTransactionListForDay = rebillManager.getList(i, 2);
                    this.getLogger().info("\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0439 \u043c\u0435\u0441\u044f\u0447\u043d\u044b\u0445 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 - " + rebillTransactionListForDay.size());
                    rebillTransactionList.addAll(rebillTransactionListForDay);
                }
            }
            rebillManager.close();
            if (rebillTransactionList.isEmpty()) {
                this.getLogger().info("\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b.");
                return;
            }
            int maxThreadCount = moduleSetup.getInt("thread.count", 20);
            ArrayList futures = new ArrayList();
            ThreadPoolExecutor pool = new ThreadPoolExecutor(maxThreadCount, maxThreadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            int count = rebillTransactionList.size() / maxThreadCount + 1;
            int fromIndex = 0;
            for (int i = 0; i < maxThreadCount; ++i) {
                int toIndex = fromIndex + count;
                toIndex = toIndex > rebillTransactionList.size() ? rebillTransactionList.size() : toIndex;
                RebillWorker worker = new RebillWorker();
                worker.init(this.moduleId, rebillUrl, merchantId, privateSecKey, rebillTransactionList.subList(fromIndex, toIndex));
                Future<?> f = pool.submit(worker);
                futures.add(f);
                if ((fromIndex += count) >= rebillTransactionList.size()) break;
            }
            ConcurrentUtils.awaitFutures(futures);
            pool.shutdown();
        }
        catch (Exception ex) {
            this.getLogger().error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430.", (Throwable)ex);
            this.error = ex;
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c PayOnline. \u0417\u0430\u0434\u0430\u0447\u0430 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }

    private int getDayOfWeek(Calendar c) {
        return 7 - (8 - c.get(7)) % 7;
    }
}

