/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.service;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiClient;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonKassaApiClient;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.oss.kernel.job.server.JobScheduler;

public class MsisdnActivate
extends BGLogger {
    private static MsisdnActivate INSTANCE;
    private static JobScheduler jobScheduler;
    private static final Map<String, Status> CACHE;

    public static MsisdnActivate getInstance(int moduleId) throws BGException {
        if (INSTANCE == null) {
            INSTANCE = new MsisdnActivate(moduleId);
        }
        return INSTANCE;
    }

    private MsisdnActivate(int moduleId) throws BGException {
        jobScheduler = JobScheduler.getInstance((String)"megafon", (int)moduleId);
        jobScheduler.schedule(MsisdnActivator.class, (ParameterMap)new ParameterMap.DefaultParameterMap(new HashMap()), new Date());
    }

    public void activate(int moduleId, String msisdn) {
        this.getLogger().info("Megafon - \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044e - {}", (Object)msisdn);
        MegafonApiClient megafonClient = new MegafonApiClient(moduleId);
        int activateResult = megafonClient.activateSim(-1, msisdn);
        this.getLogger().info("Megafon - activateResult - {}", (Object)activateResult);
        CACHE.put(msisdn, Status.IN_PROGRESS);
    }

    public Map<String, Status> getCache() {
        return CACHE;
    }

    static {
        CACHE = new HashMap<String, Status>();
    }

    public static class MsisdnActivator
    extends BGLogger
    implements Callable<Object> {
        @Override
        public Object call() throws Exception {
            ServerContext context = (ServerContext)ServerContext.get();
            MegafonKassaApiClient kassaApiClient = new MegafonKassaApiClient(context.getModuleId());
            for (String msisdn : CACHE.keySet()) {
                if (!CACHE.get(msisdn).equals((Object)Status.IN_PROGRESS)) continue;
                this.getLogger().info("Megafon - \u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u043e\u043c\u0435\u0440\u0430={}", (Object)msisdn);
                if (!kassaApiClient.accountExists(msisdn)) continue;
                this.getLogger().info("Megafon - \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 - {} - \u0410\u043a\u0442\u0438\u0432\u0435\u043d", (Object)msisdn);
                CACHE.put(msisdn, Status.ACTIVATED);
            }
            jobScheduler.schedule(MsisdnActivator.class, null, TimeUtils.convertLocalDateTimeToDate((LocalDateTime)LocalDateTime.now().plusMinutes(5L)));
            return null;
        }
    }

    public static enum Status {
        ACTIVATED,
        IN_PROGRESS;

    }
}

