/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends FilterInputStream {
    private int iBuffer;
    private int iNextBit = 8;

    public BitInputStream(InputStream in) {
        super(in);
    }

    public synchronized int readBits(int aNumberOfBits) throws IOException {
        int value = 0;
        for (int i = aNumberOfBits - 1; i >= 0; --i) {
            value |= this.readBit() << i;
        }
        return value;
    }

    private synchronized int readBit() throws IOException {
        if (this.iNextBit == 8) {
            this.iBuffer = this.in.read();
            if (this.iBuffer == -1) {
                throw new EOFException();
            }
            this.iNextBit = 0;
        }
        int bit = this.iBuffer & 1 << 7 - this.iNextBit;
        ++this.iNextBit;
        bit = bit == 0 ? 0 : 1;
        return bit;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static void main(String[] args) throws IOException {
        BitInputStream input = new BitInputStream(new ByteArrayInputStream(new byte[]{1, 4, 2, -102, 0, 1}));
        int r_Proto_Ver = input.readBits(8);
        int r_Crypt_Ver = input.readBits(6);
        int r_Key_Type = input.readBits(2);
        int r_OPE_ID = input.readBits(16);
        int r_SMS_ID = input.readBits(16);
        System.out.println("r_Proto_Ver=" + r_Proto_Ver);
        System.out.println("r_Crypt_Ver=" + r_Crypt_Ver);
        System.out.println("r_Key_Type=" + r_Key_Type);
        System.out.println("r_OPE_ID=" + r_OPE_ID);
        System.out.println("r_SMS_ID=" + r_SMS_ID);
        input.close();
    }
}

