/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.radius;

import java.net.InetAddress;
import java.sql.Connection;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDeviceType;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNas;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNasConnection;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceRadiusProcessor;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntimeMap;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class VoiceNasList
extends NasList<VoiceNasConnection, VoiceNas> {
    private final VoiceApplication application;

    public VoiceNasList(VoiceApplication application) {
        this.application = application;
    }

    protected VoiceNas newNas(DefaultServerSetup setup, int moduleId, RadiusProcessor<VoiceNasConnection, VoiceNas, ?> processor, int id, VoiceNas oldNas, InetAddress nasIPAddress, String nasIdentifier, int vendorCode, ParameterMap conf, byte[] secret, ConcurrentMap<Object, VoiceNasConnection> connections, String script, NasConnectionInspector inspector, Object ... params) {
        return new VoiceNas((Preferences)setup, moduleId, (VoiceRadiusProcessor)processor, id, oldNas, nasIPAddress, nasIdentifier, vendorCode, conf, secret, connections, (VoiceDeviceRuntime)((Object)params[0]));
    }

    public synchronized void load(DefaultServerSetup setup, RadiusProcessor<VoiceNasConnection, VoiceNas, ?> processor, Connection con, int moduleId) {
        VoiceDeviceRuntimeMap deviceMap = this.application.getDeviceRuntimeMap();
        try {
            for (VoiceDeviceRuntime deviceRuntime : deviceMap.values()) {
                VoiceDevice device = deviceRuntime.getDevice();
                VoiceDeviceType type = deviceRuntime.getDeviceType();
                if (device.getDeviceTypeId() == 0 || !type.isNas()) continue;
                byte[] secret = device.getSecret() != null ? device.getSecret().getBytes() : null;
                Preferences deviceTypeConf = new Preferences(type.getConfig(), "\r\n");
                ParameterMap deviceConf = new Preferences(device.getConfig(), "\r\n").inherit((ParameterMap)deviceTypeConf);
                int vendor = deviceConf.getInt("vendor.code", 9);
                InetAddress nasIPAddress = null;
                if (!Utils.isEmptyString((String)device.getHost())) {
                    try {
                        nasIPAddress = InetAddress.getByName(device.getHost());
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                }
                this.setNas(setup, moduleId, processor, device.getId(), nasIPAddress, device.getIdentifier(), secret, vendor, deviceConf.toString(), "", new Object[]{deviceRuntime});
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }
}

