/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.flussonicwatcher;

import java.util.ArrayList;
import javax.swing.table.TableCellRenderer;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.client.flussonicwatcher.FlussonicWatcherBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.common.service.FlussonicWatcherService;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;
import ru.bitel.common.model.SearchResult;

public class FlussonicWatcherOrganizationsPanel
extends FlussonicWatcherBasePanel {
    private OrganizationTableModel tableModel;
    private FlussonicWatcherService flussonicWatcherService;

    @Override
    protected BGTableModel<RowData> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new OrganizationTableModel(OrganizationTableModel.class.getName());
        }
        return this.tableModel;
    }

    @Override
    protected void doRefresh() throws BGException {
        SearchResult searchResult = this.getFlussonicWatcherService().searchOrganizations();
        ArrayList data = new ArrayList();
        searchResult.getList().forEach(i -> data.add(new RowData(i)));
        this.getTableModel().setData(data);
    }

    protected void getPopupMenuItems() {
        this.popupMenu.add(this.getRecordDataMenuItem());
    }

    private FlussonicWatcherService getFlussonicWatcherService() {
        if (this.flussonicWatcherService == null) {
            this.flussonicWatcherService = (FlussonicWatcherService)((ClientContext)this.getContext()).getPort(FlussonicWatcherService.class);
        }
        return this.flussonicWatcherService;
    }

    class OrganizationTableModel
    extends BGTableModel<RowData> {
        public OrganizationTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438", 100, 150, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e", Boolean.class, 120, 120, 120, "is_default", true);
            this.addColumn("\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440", 100, 125, 150, "owner", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u0430\u043c\u0435\u0440\u044b [\u043f\u0440\u0430\u0432\u043a\u0430]", 100, 120, 150, "camera", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041c\u043e\u0437\u0430\u0438\u043a\u0438", 120, 120, 120, "mosaic_count", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("DVR", 120, 120, 120, "dvr_limit", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438 [\u043f\u0440\u0430\u0432\u043a\u0430]", 150, 200, 250, "user", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u0414\u043e\u043c\u0435\u043d", 100, 200, 300, "domain", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValueAt(RowData rowData, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            JSONObject json = rowData.getJson();
            if ("id".equals(identifier) || "mosaic_count".equals(identifier) || "dvr_limit".equals(identifier)) {
                return json.optInt(identifier);
            }
            if ("camera".equals(identifier) || "user".equals(identifier)) {
                return json.optInt(identifier + "_count") + "/" + json.optInt(identifier + "_limit") + " [" + (json.optBoolean("can_edit_" + identifier + "s") ? "+" : "-") + "]";
            }
            if ("is_default".equals(identifier) || "is_admin".equals(identifier)) {
                return json.optBoolean(identifier);
            }
            if ("owner".equals(identifier)) {
                return json.optQuery("/owner/login");
            }
            if ("domain".equals(identifier)) {
                return json.optQuery("/domain/title");
            }
            if ("title".equals(identifier)) {
                return json.optString(identifier);
            }
            return super.getValueAt((Object)rowData, column);
        }
    }
}

