/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.organizer.server.action;

import bitel.billing.server.ActionBase;
import java.util.Date;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.organizer.server.bean.OrganizerManager;
import ru.bitel.bgbilling.plugins.organizer.server.bean.OrganizerRecord;
import ru.bitel.common.model.Period;

public class ActionUpdateOrganizerRecord
extends ActionBase {
    public void doAction() throws Exception {
        int rid = this.getIntParameter("rid", -1);
        if (rid < 0) {
            throw new BGIllegalArgumentException();
        }
        Period per = this.getPeriod();
        try {
            OrganizerManager man = new OrganizerManager(this.con);
            OrganizerRecord rec = man.getRecordById(rid);
            if (rec == null && rid > 0) {
                throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            }
            if (rid == 0) {
                rec = new OrganizerRecord();
                Date created = this.getDateParameter("created");
                int uid = this.getIntParameter("uid", -1);
                if (created == null || uid < 0) {
                    throw new BGIllegalArgumentException();
                }
                rec.setCreationDate(created);
                rec.setUid(uid);
            }
            rec.setCid(this.getIntParameter("cid", -1));
            rec.setTitle(this.getParameter("title", ""));
            rec.setComment(this.getParameter("comment", ""));
            rec.setPeriod(per);
            rec.setTodoUid(this.getIntParameter("user_id", -1));
            rec.setTodoGid(this.getIntParameter("group_id", -1));
            rec.setDone(!"notdone".equals(this.getParameter("status")));
            if (rec.isDone()) {
                if (rec.getCompleteUid() <= 0) {
                    rec.setCompleteUid(this.getIntParameter("complete_uid", 0));
                    rec.setCompleteDate(this.getDateParameter("complete_date"));
                }
            } else if (rec.getCompleteUid() > 0) {
                rec.setCompleteUid(0);
                rec.setCompleteDate(null);
            }
            man.updateRecord(rec);
            man.addToJournal(rec.getId(), this.userId, this.getParameter("journal", "error"));
        }
        catch (Exception e) {
            throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
        }
    }
}

