/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.inet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpAddressRangeSetEntry;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.Ranger;

public class IpAddressRangeSet2<R> {
    private static final int IPv6_ADDRESS_LENGTH = 16;
    private final Ranger<R, byte[]> ranger;
    private final IpAddressRangeSetEntry<R> rangeSetEntryV4;
    private final IpAddressRangeSetEntry<R> rangeSetEntryV6;

    public static <K extends IpRange> IpAddressRangeSet2<K> newInstance(Class<K> clazz, int maskLength) {
        return new IpAddressRangeSet2<K>(clazz, new IpRanger(), false, maskLength);
    }

    public IpAddressRangeSet2(Class<R> clazz, Ranger<R, byte[]> ranger, boolean bites, int maskLength) {
        this.ranger = ranger;
        this.rangeSetEntryV4 = new IpAddressRangeSetEntry<R>(clazz, ranger, bites, maskLength);
        this.rangeSetEntryV6 = new IpAddressRangeSetEntry<R>(clazz, ranger, bites, bites ? maskLength + 64 : maskLength + 8);
    }

    protected IpAddress segmentKey(R range) {
        if (this.ranger.getMinValue(range).length == 16) {
            return this.rangeSetEntryV6.segmenter.segmentKey((Object)range);
        }
        return this.rangeSetEntryV4.segmenter.segmentKey((Object)range);
    }

    protected byte[] segmentKey(byte[] address) {
        if (address.length == 16) {
            return this.rangeSetEntryV6.segmenter.segmentKey(address);
        }
        return this.rangeSetEntryV4.segmenter.segmentKey(address);
    }

    public R get(IpAddress segmentKey, byte[] address, Matcher<R> matcher) {
        if (address.length == 16) {
            return this.rangeSetEntryV6.get(segmentKey, address, matcher);
        }
        return this.rangeSetEntryV4.get(segmentKey, address, matcher);
    }

    public R get(IpAddress segmentKey, byte[] address) {
        if (address.length == 16) {
            return this.rangeSetEntryV6.get(segmentKey, address);
        }
        return this.rangeSetEntryV4.get(segmentKey, address);
    }

    public void addAll(Iterable<R> list) {
        Object key;
        HashSet<R> notSegmentedV4 = new HashSet<R>();
        HashMap segmentsV4 = new HashMap();
        HashSet<R> notSegmentedV6 = new HashSet<R>();
        HashMap<Object, HashSet<R>> segmentsV6 = new HashMap<Object, HashSet<R>>();
        for (R r : list) {
            Set<Object> rangeSet;
            if (this.ranger.getMinValue(r).length == 16) {
                key = this.rangeSetEntryV6.segmenter.segmentKey((Object)r);
                if (key != null) {
                    rangeSet = (HashSet<R>)segmentsV6.get(key);
                    if (rangeSet == null) {
                        rangeSet = new HashSet<R>();
                        segmentsV6.put(key, (HashSet<R>)rangeSet);
                    }
                    rangeSet.add(r);
                    continue;
                }
                notSegmentedV6.add(r);
                continue;
            }
            key = this.rangeSetEntryV4.segmenter.segmentKey((Object)r);
            if (key != null) {
                rangeSet = (Set)segmentsV4.get(key);
                if (rangeSet == null) {
                    rangeSet = new HashSet();
                    segmentsV4.put(key, rangeSet);
                }
                rangeSet.add(r);
                continue;
            }
            notSegmentedV4.add(r);
        }
        this.rangeSetEntryV6.notSegmented().addAll(notSegmentedV6);
        for (Map.Entry entry : segmentsV6.entrySet()) {
            key = (IpAddress)entry.getKey();
            this.rangeSetEntryV6.addAll((IpAddress)key, (Set)entry.getValue());
        }
        this.rangeSetEntryV4.notSegmented().addAll(notSegmentedV4);
        for (Map.Entry entry : segmentsV4.entrySet()) {
            key = (IpAddress)entry.getKey();
            this.rangeSetEntryV4.addAll((IpAddress)key, (Set)entry.getValue());
        }
    }

    public void removeAll(Iterable<R> list) {
        Object key;
        HashSet<R> notSegmentedV4 = new HashSet<R>();
        HashMap segmentsV4 = new HashMap();
        HashSet<R> notSegmentedV6 = new HashSet<R>();
        HashMap<Object, HashSet<R>> segmentsV6 = new HashMap<Object, HashSet<R>>();
        for (R r : list) {
            Set<Object> rangeSet;
            if (this.ranger.getMinValue(r).length == 16) {
                key = this.rangeSetEntryV6.segmenter.segmentKey((Object)r);
                if (key != null) {
                    rangeSet = (HashSet<R>)segmentsV6.get(key);
                    if (rangeSet == null) {
                        rangeSet = new HashSet<R>();
                        segmentsV6.put(key, (HashSet<R>)rangeSet);
                    }
                    rangeSet.add(r);
                    continue;
                }
                notSegmentedV6.add(r);
                continue;
            }
            key = this.rangeSetEntryV4.segmenter.segmentKey((Object)r);
            if (key != null) {
                rangeSet = (Set)segmentsV4.get(key);
                if (rangeSet == null) {
                    rangeSet = new HashSet();
                    segmentsV4.put(key, rangeSet);
                }
                rangeSet.add(r);
                continue;
            }
            notSegmentedV4.add(r);
        }
        this.rangeSetEntryV6.notSegmented().removeAll(notSegmentedV6);
        for (Map.Entry entry : segmentsV6.entrySet()) {
            key = (IpAddress)entry.getKey();
            this.rangeSetEntryV6.removeAll((IpAddress)key, (Set)entry.getValue());
        }
        this.rangeSetEntryV4.notSegmented().removeAll(notSegmentedV4);
        for (Map.Entry entry : segmentsV4.entrySet()) {
            key = (IpAddress)entry.getKey();
            this.rangeSetEntryV4.removeAll((IpAddress)key, (Set)entry.getValue());
        }
    }

    public void add(R range) {
        if (this.ranger.getMinValue(range).length == 16) {
            this.rangeSetEntryV6.add(range);
        } else {
            this.rangeSetEntryV4.add(range);
        }
    }

    public void remove(R range) {
        if (this.ranger.getMinValue(range).length == 16) {
            this.rangeSetEntryV6.remove(range);
        } else {
            this.rangeSetEntryV4.remove(range);
        }
    }

    public boolean contains(byte[] address) {
        if (address.length == 16) {
            byte[] segmentKey = this.rangeSetEntryV6.segmenter.segmentKey(address);
            IpAddress segment = new IpAddress(segmentKey);
            return this.rangeSetEntryV6.get(segment, address) != null;
        }
        byte[] segmentKey = this.rangeSetEntryV4.segmenter.segmentKey(address);
        IpAddress segment = new IpAddress(segmentKey);
        return this.rangeSetEntryV4.get(segment, address) != null;
    }

    public boolean contains(byte[] address, Matcher<R> matcher) {
        if (address.length == 16) {
            byte[] segmentKey = this.rangeSetEntryV6.segmenter.segmentKey(address);
            IpAddress segment = new IpAddress(segmentKey);
            return this.rangeSetEntryV6.get(segment, address, matcher) != null;
        }
        byte[] segmentKey = this.rangeSetEntryV4.segmenter.segmentKey(address);
        IpAddress segment = new IpAddress(segmentKey);
        return this.rangeSetEntryV4.get(segment, address, matcher) != null;
    }

    static final class IpRanger<R extends IpRange>
    implements Ranger<R, byte[]> {
        IpRanger() {
        }

        @Override
        public byte[] getMinValue(R r) {
            return ((IpRange)r).getAddressFrom();
        }

        @Override
        public byte[] getMaxValue(R r) {
            return ((IpRange)r).getAddressTo();
        }
    }
}

