/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.directory.address.AddressParamTableModel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityData;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class AddressEntityEditor
extends BGEditorDialog<AddressEntityData> {
    private int parentId = 0;
    private JLabel titleLabel = new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435:");
    private TitleTextField entityTitlePrefix = new TitleTextField(10);
    private TitleTextField entityTitle = new TitleTextField(50);
    private TitleTextField entityTitleSuffix = new TitleTextField(10);
    private AddressParamTableModel paramTableModel = new AddressParamTableModel();
    private BGUTable paramTable = new BGUTable(this.paramTableModel);

    public AddressEntityEditor(String title, AddressEntityData data, ClientContext clientContext) {
        super(title, data, clientContext);
    }

    @Override
    public void doDialogPanel() {
        this.panel.add((Component)this.getTitlePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.getParamPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.tryCall(() -> {
            this.data = this.clientContext.getWebService(AddressService.class, 0).addressEntityDataGet(((AddressEntityData)this.data).getAddressEntityType(), ((AddressEntityData)this.data).getRecordId());
            this.entityTitlePrefix.setText(((AddressEntityData)this.data).getTitlePrefix());
            this.entityTitle.setText(((AddressEntityData)this.data).getTitle());
            this.entityTitleSuffix.setText(((AddressEntityData)this.data).getTitleSuffix());
            this.paramTableModel.setData(((AddressEntityData)this.data).getConfigParams());
        });
        this.entityTitlePrefix.setPlaceholder("\u043f\u0440\u0435\u0444\u0438\u043a\u0441");
        this.entityTitle.setPlaceholder("\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
        this.entityTitleSuffix.setPlaceholder("\u0441\u0443\u0444\u0444\u0438\u043a\u0441");
    }

    @Override
    public boolean doApply() throws Exception {
        if (this.entityTitle.getText().trim().length() == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
            return false;
        }
        try {
            ((AddressEntityData)this.data).setParentId(this.parentId);
            ((AddressEntityData)this.data).setTitle(this.entityTitle.getText());
            if (this.entityTitlePrefix.isVisible()) {
                ((AddressEntityData)this.data).setTitlePrefix(this.entityTitlePrefix.getText());
            }
            if (this.entityTitleSuffix.isVisible()) {
                ((AddressEntityData)this.data).setTitleSuffix(this.entityTitleSuffix.getText());
            }
            ((AddressEntityData)this.data).setConfigParams(this.paramTableModel.getRows());
            this.clientContext.getWebService(AddressService.class, 0).addressEntityDataUpdate((AddressEntityData)this.data);
            return true;
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
            return false;
        }
    }

    private JPanel getTitlePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.titleLabel, new GridBagConstraints(0, -1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.entityTitlePrefix, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)this.entityTitle, new GridBagConstraints(-1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)this.entityTitleSuffix, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getParamPanel() {
        this.paramTable.setRowHeight(18);
        this.paramTable.setFont(new Font("Dialog", 0, 13));
        this.paramTable.setSelectionMode(0);
        this.paramTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.paramTable, 800, 300), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    public String getTitle() {
        return this.entityTitle.getText().trim();
    }

    public void setTitleLabelText(String text) {
        this.titleLabel.setText(text);
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public void setTitlePrefixEnable(boolean value) {
        this.entityTitlePrefix.setVisible(value);
    }

    public void setTitleSuffixEnable(boolean value) {
        this.entityTitleSuffix.setVisible(value);
    }

    class TitleTextField
    extends JTextField {
        private String placeholder;

        public TitleTextField(int col) {
            super(col);
            this.setHorizontalAlignment(0);
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        @Override
        protected void paintComponent(Graphics pG) {
            super.paintComponent(pG);
            if (this.placeholder == null || this.placeholder.length() == 0 || this.getText().length() > 0) {
                return;
            }
            Graphics2D g = (Graphics2D)pG;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.getDisabledTextColor());
            Rectangle2D r = g.getFont().getStringBounds(this.placeholder, g.getFontRenderContext());
            g.drawString(this.placeholder, this.getInsets().left + this.getSize().width / 2 - (int)(r.getWidth() / 2.0), pG.getFontMetrics().getMaxAscent() + this.getInsets().top);
        }

        public void setPlaceholder(String text) {
            this.placeholder = text;
        }
    }
}

