/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.text.JTextComponent;

public class BGComboBoxWithSearch
extends BGComboBox<ComboBoxItem> {
    private int lengthOfEnteredText = -1;

    public BGComboBoxWithSearch(int lengthOfEnteredText) {
        this.lengthOfEnteredText = lengthOfEnteredText;
        this.init();
    }

    private void init() {
        final JTextComponent editor = (JTextComponent)this.getEditor().getEditorComponent();
        editor.addKeyListener(new KeyAdapter(){
            private String previousEnteredText = "";

            @Override
            public void keyReleased(KeyEvent e) {
                BGComboBoxWithSearch.this.firePropertyChange("resetAllText", false, true);
                if (e.getKeyChar() == '\n') {
                    BGComboBoxWithSearch.this.firePropertyChange("textEntered", false, true);
                    return;
                }
                if (e.getKeyChar() == '\u001b') {
                    editor.setText("");
                    BGComboBoxWithSearch.this.hidePopup();
                    return;
                }
                if (e.getKeyCode() != 40 && e.getKeyCode() != 38) {
                    int caretPosition = editor.getCaretPosition();
                    String enteredText = editor.getText();
                    if (!enteredText.equals(this.previousEnteredText)) {
                        if (enteredText.length() > BGComboBoxWithSearch.this.lengthOfEnteredText) {
                            BGComboBoxWithSearch.this.firePropertyChange("fillText", "", enteredText);
                            BGComboBoxWithSearch.this.hidePopup();
                            BGComboBoxWithSearch.this.showPopup();
                            editor.setCaretPosition(caretPosition < editor.getText().length() ? caretPosition : editor.getText().length());
                        }
                        if (enteredText.length() <= BGComboBoxWithSearch.this.lengthOfEnteredText) {
                            BGComboBoxWithSearch.this.initPopup(enteredText);
                            BGComboBoxWithSearch.this.hidePopup();
                        }
                    }
                    this.previousEnteredText = enteredText;
                }
            }
        });
    }

    public void initPopup(String enteredText) {
        this.initPopup(0, enteredText);
    }

    public void initPopup(int id, String enteredText) {
        this.removeAllItems();
        this.addItem(new ComboBoxItem(id, enteredText));
    }

    public void resetTextFromEditor() {
        JTextComponent editor = (JTextComponent)this.getEditor().getEditorComponent();
        editor.setText("");
    }
}

