/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.server.service;

import jakarta.jws.WebService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableDataSource;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUserTable;
import ru.bitel.bgbilling.kernel.table.common.dto.TableComponentDto;
import ru.bitel.bgbilling.kernel.table.common.dto.TableDto;
import ru.bitel.bgbilling.kernel.table.common.service.TableService;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfo;
import ru.bitel.bgbilling.kernel.table.server.bean.BGUserTableDao;
import ru.bitel.bgbilling.kernel.table.server.bean.TableCache;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.table.common.service.TableService")
public class TableServiceImpl
extends AbstractService
implements TableService {
    @Override
    public BGUTableDataSource tableDataSourceGet(String component, int componentId, String tableKey, BGUTableParams tableParams) throws BGException {
        return (BGUTableDataSource)this.tryReturn(() -> {
            if ("kernel".equals(component)) {
                BGTableInfo tableInfo = Class.forName("ru.bitel.bgbilling.kernel.table.server.table.Table" + tableKey).asSubclass(BGTableInfo.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                tableInfo.setUserId(this.userId);
                return new BGUTableDataSource().setColumns(tableInfo.getColumns()).setRows(tableInfo.getRows(tableParams, componentId)).setPage(tableInfo.getPage()).setAttributes(tableInfo.getAttributes());
            }
            for (BGTableInfo tableInfo : TableCache.getTableList(component)) {
                if (!tableInfo.getClass().getSimpleName().equals("Table" + tableKey)) continue;
                tableInfo.getAttributes().clear();
                tableInfo.setUserId(this.userId);
                return new BGUTableDataSource().setColumns(tableInfo.getColumns()).setRows(tableInfo.getRows(tableParams, componentId)).setPage(tableInfo.getPage()).setAttributes(tableInfo.getAttributes());
            }
            return new BGUTableDataSource();
        });
    }

    @Override
    public List<TableDto> tableList(String componentId) throws BGException {
        if (componentId.matches("^\\d+$")) {
            componentId = ModuleCache.getInstance().getModule(Utils.parseInt((String)componentId)).getInstalledModule().getName();
        }
        return Optional.ofNullable(TableCache.getTableList(componentId)).orElse(Collections.emptyList()).stream().map(BGTableInfo::toTableDto).toList();
    }

    @Override
    public List<TableComponentDto> tableComponentList() throws BGException {
        return TableCache.getTableComponentList();
    }

    @Override
    public void userTableSet(boolean defaultUserTable, BGUserTable userTable) throws BGException {
        this.tryCall(() -> {
            userTable.setUserId(defaultUserTable ? 0 : this.userId);
            new BGUserTableDao(this.getConnection()).update(userTable);
        });
    }

    @Override
    public BGUserTable userTableGet(boolean defaultUserTable, String module, String tableId) throws BGException {
        return (BGUserTable)this.tryReturn(() -> new BGUserTableDao(this.getConnection()).get(defaultUserTable ? 0 : this.userId, module, tableId));
    }

    @Override
    public boolean userTableReset(boolean defaultUserTable, String module, String tableId) throws BGException {
        return (Boolean)this.tryReturn(() -> new BGUserTableDao(this.getConnection()).delete(defaultUserTable ? 0 : this.userId, module, tableId));
    }
}

