/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class ContractLabelsTariffTreeNode
extends TariffTreeNode<AbstractTariffRequest<ServiceCost>, TariffContext, TreeContext, ThreadContext> {
    private final List<Integer> contractLabelIds;
    private final boolean modeOr;

    public ContractLabelsTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.contractLabelIds = Utils.toIntegerList((String)parameterMap.get("contractLabelIds", ""));
        this.contractLabelIds.addAll(Utils.toIntegerList((String)parameterMap.get("contractGroups", "")).stream().map(a -> a + 2).toList());
        this.modeOr = parameterMap.getInt("mode", 0) == 0;
    }

    @Override
    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<ServiceCost> req, TariffContext context, TreeContext treeContext, ThreadContext workerContext) {
        if (this.contractLabelIds.isEmpty()) {
            Set<Long> acceptedSet = req.getAcceptedSet(ContractLabelsTariffTreeNode.class);
            if (!acceptedSet.contains(parentTreeNodeId)) {
                acceptedSet.add(parentTreeNodeId);
                return 1;
            }
            return 0;
        }
        int count = 0;
        if (this.modeOr) {
            for (Integer id : this.contractLabelIds) {
                if (!req.contractLabelIds.contains(id)) continue;
                ++count;
                break;
            }
            if (count == 0) {
                return 0;
            }
        } else {
            for (Integer id : this.contractLabelIds) {
                if (!req.contractLabelIds.contains(id)) continue;
                ++count;
                break;
            }
            if (count != req.contractLabelIds.size()) {
                return 0;
            }
        }
        Set<Long> acceptedSet = req.getAcceptedSet(ContractLabelsTariffTreeNode.class);
        acceptedSet.add(parentTreeNodeId);
        return 1;
    }
}

