/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.service;

import jakarta.jws.WebService;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractCredentials;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubRequestLog;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscription;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscriptionStatusPeriod;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractTryAndBuy;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoSubscription;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoTryAndBuy;
import ru.bitel.bgbilling.modules.megogo.common.service.MegogoService;
import ru.bitel.bgbilling.modules.megogo.server.MegogoApi;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractCredentialsDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractSubRequestLogDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractSubscriptionDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractSubscriptionStatusPeriodDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractTryAndBuyDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoSubscriptionDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoTryAndBuyDao;
import ru.bitel.bgbilling.modules.megogo.server.event.MegogoCreateUserEvent;
import ru.bitel.bgbilling.modules.megogo.server.event.MegogoSubscriptionUpdateEvent;
import ru.bitel.bgbilling.modules.megogo.server.tasks.MegogoRecalculator;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.megogo.common.service.MegogoService")
public class MegogoServiceImpl
extends AbstractService
implements MegogoService {
    private MegogoTryAndBuyDao megogoTryAndBuyDao;
    private MegogoSubscriptionDao megogoSubscriptionDao;
    private MegogoContractTryAndBuyDao megogoContractTryAndBuyDao;
    private MegogoContractCredentialsDao megogoContractCredentialsDao;
    private MegogoContractSubscriptionDao megogoContractSubscriptionDao;
    private MegogoContractSubRequestLogDao megogoContractSubRequestLogDao;
    private MegogoContractSubscriptionStatusPeriodDao megogoContractSubscriptionStatusPeriodDao;

    public int updateContractSubscription(MegogoContractSubscription contractSub, boolean sendToMegogo) throws BGException {
        return this.updateContractSubscription(contractSub, sendToMegogo, null);
    }

    private int updateContractSubscription(MegogoContractSubscription contractSub, boolean sendToMegogo, MegogoSubscription subscriptionTo) throws BGException {
        return (Integer)this.tryReturn(() -> {
            Date now = new Date();
            MegogoSubscription subscription = this.getMegogoSubscriptionDao().getByServiceId(contractSub.getServiceId());
            this.checkOnUpdate(contractSub);
            int logId = -1;
            if (contractSub.getId() < 1) {
                MegogoSubscriptionUpdateEvent event;
                if (TimeUtils.dateBefore((Date)contractSub.getPeriod().getDateFrom(), (Date)now)) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u043e\u0448\u043b\u043e\u043c!");
                }
                contractSub.setStatus(3);
                contractSub.setDateActivated(null);
                contractSub.setDateDeactivated(null);
                if (subscription.getType() == 1) {
                    String mainSids = Utils.toString(this.getMegogoSubscriptionDao().getMainSubscriptionsServiceIds());
                    List<MegogoContractSubscription> list = this.getMegogoContractSubscriptionDao().getContractsSubscriptionList("" + contractSub.getContractId(), mainSids, -1, contractSub.getPeriod().getDateFrom(), contractSub.getPeriod().getDateTo(), -1);
                    for (MegogoContractSubscription sub : list) {
                        if (sub.getStatus() == 2) continue;
                        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0412\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u043f\u0435\u0440\u0435\u0441\u0435\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u043e\u0441\u043d\u043e\u0432\u043d\u044b\u0445 \u043d\u0435 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433/\u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a! \u041a\u043e\u0434 - " + sub.getId());
                    }
                }
                if (!(event = (MegogoSubscriptionUpdateEvent)EventProcessor.getInstance().request((QueueEvent)new MegogoSubscriptionUpdateEvent(this.moduleId, contractSub, this.userId, sendToMegogo))).isProcessed()) {
                    if (TimeUtils.dateBeforeOrEq((Date)contractSub.getPeriod().getDateFrom(), (Date)now) && sendToMegogo) {
                        logId = this.requesToMegogo(contractSub, subscription, 0);
                    } else {
                        MegogoContractCredentialsDao credentialsDao;
                        MegogoContractCredentials credentials;
                        int modeCreateUser = Utils.parseInt((String)this.getModuleSetup().get("user.create.mode", "1"), (int)1);
                        if (modeCreateUser == 2 && (credentials = (credentialsDao = new MegogoContractCredentialsDao(this.getConnection(), this.moduleId)).getByContractId(contractSub.getContractId())) == null) {
                            credentials = new MegogoContractCredentials();
                            credentials.setContractId(contractSub.getContractId());
                            MegogoCreateUserEvent megogoCreateUserEvent = new MegogoCreateUserEvent(this.moduleId, contractSub.getContractId(), this.userId, credentials);
                            megogoCreateUserEvent = (MegogoCreateUserEvent)EventProcessor.getInstance().request((QueueEvent)megogoCreateUserEvent);
                            MegogoApi megogoApi = new MegogoApi(this.moduleId, this.userId, this.getConnection(), -1);
                            megogoApi.createUser(contractSub.getContractId(), credentials.getLogin(), credentials.getPwd());
                        }
                    }
                }
            } else {
                MegogoContractSubscription old = (MegogoContractSubscription)this.getMegogoContractSubscriptionDao().get(contractSub.getId());
                contractSub.setContractId(old.getContractId());
                contractSub.setDateActivated(old.getDateActivated());
                contractSub.setDateDeactivated(old.getDateDeactivated());
                contractSub.setStatus(old.getStatus());
                if (old.getStatus() == 2 && !TimeUtils.dateEqual((Date)old.getPeriod().getDateFrom(), (Date)contractSub.getPeriod().getDateFrom())) {
                    throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434 \u0443 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
                }
                if (TimeUtils.dateBeforeOrEq((Date)now, (Date)contractSub.getPeriod().getDateTo())) {
                    contractSub.setStatus(1);
                } else if (contractSub.getPeriod().getDateTo() == null && old.getStatus() == 1) {
                    contractSub.setStatus(0);
                }
                MegogoSubscriptionUpdateEvent event = (MegogoSubscriptionUpdateEvent)EventProcessor.getInstance().request((QueueEvent)new MegogoSubscriptionUpdateEvent(this.moduleId, contractSub, this.userId, sendToMegogo, subscriptionTo));
                if (!event.isProcessed() && sendToMegogo && TimeUtils.dateBeforeOrEq((Date)contractSub.getPeriod().getDateTo(), (Date)now) && contractSub.getStatus() != 2) {
                    this.requesToMegogo(contractSub, subscription, 2);
                }
            }
            contractSub.setUserId(this.userId);
            this.getMegogoContractSubscriptionDao().update(contractSub);
            if (logId > 0) {
                MegogoContractSubRequestLogDao logDao = new MegogoContractSubRequestLogDao(this.getConnection(), this.moduleId);
                logDao.setContractSubscriptionId(logId, contractSub.getId());
            }
            return contractSub.getId();
        });
    }

    private void checkOnUpdate(MegogoContractSubscription contractSubscription) throws BGException {
        this.tryCall(() -> {
            Date now = new Date();
            if (contractSubscription.getPeriod() == null || contractSubscription.getPeriod().getDateFrom() == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
            }
            if (TimeUtils.dateBefore((Date)contractSubscription.getPeriod().getDateTo(), (Date)contractSubscription.getPeriod().getDateFrom())) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f!");
            }
            MegogoSubscription subscription = this.getMegogoSubscriptionDao().getByServiceId(contractSubscription.getServiceId());
            if (subscription == null || Utils.isBlankString((String)subscription.getKey())) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u0443\u0441\u043b\u0443\u0433\u0438!");
            }
            Contract contract = Optional.ofNullable(this.getContract(contractSubscription.getContractId())).orElseThrow(() -> new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
            if (contract.getDateTo() != null && TimeUtils.dateBefore((Date)contract.getDateTo(), (Date)now)) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0437\u0430\u043a\u0440\u044b\u0442!");
            }
            List<MegogoContractSubscription> list = this.getMegogoContractSubscriptionDao().getContractSubscriptionList(contract.getId(), contractSubscription.getServiceId(), -1, contractSubscription.getPeriod(), contractSubscription.getId());
            if (list.size() > 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0412\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u043f\u0435\u0440\u0435\u0441\u0435\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u043e\u0434\u043d\u043e\u0439 \u0438 \u0442\u043e\u0439 \u0436\u0435 \u0443\u0441\u043b\u0443\u0433\u0438! \u041a\u043e\u0434 - " + list.get(0).getId());
            }
        });
    }

    private int requesToMegogo(MegogoContractSubscription contractSubscription, MegogoSubscription subscription, int operation) throws BGException {
        return (Integer)this.tryReturn(() -> {
            MegogoApi megogoApi = new MegogoApi(this.moduleId, this.userId, this.getConnection(), contractSubscription.getId());
            MegogoContractSubRequestLog requestLog = null;
            if (operation == 0) {
                requestLog = megogoApi.subscribe(contractSubscription.getContractId(), subscription);
            } else if (operation == 2) {
                requestLog = megogoApi.unsubscribe(contractSubscription, subscription);
            } else if (operation == 4) {
                requestLog = megogoApi.suspend(contractSubscription.getContractId(), subscription);
            } else if (operation == 6) {
                requestLog = megogoApi.resume(contractSubscription.getContractId(), subscription);
            } else {
                return -1;
            }
            if (operation == 0) {
                contractSubscription.setDateActivated(new Date());
            } else if (operation == 2) {
                this.getMegogoContractSubscriptionDao().updateDateDeactivated(contractSubscription.getId(), new Date());
                contractSubscription.setDateDeactivated(new Date());
            }
            contractSubscription.setStatus(operation);
            return requestLog.getId();
        });
    }

    public int deleteContractSubscription(int contractSubscriptionId) throws BGException {
        return (Integer)this.tryReturn(() -> {
            MegogoContractSubscription subscription = (MegogoContractSubscription)this.getMegogoContractSubscriptionDao().get(contractSubscriptionId);
            if (subscription == null) {
                throw new BGMessageException("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0441 \u043a\u043e\u0434\u043e\u043c " + contractSubscriptionId + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            }
            if (subscription.getStatus() == 3 && TimeUtils.dateBefore((Date)new Date(), (Date)subscription.getPeriod().getDateFrom()) && subscription.getDateActivated() == null) {
                return this.getMegogoContractSubscriptionDao().delete(contractSubscriptionId);
            }
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0435\u0449\u0435 \u043d\u0435 \u043d\u0430\u0441\u0442\u0443\u043f\u0438\u0432\u0448\u0438\u0445 \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a!");
        });
    }

    public List<MegogoContractSubscription> contractSubscriptionList(int contractId, int serviceId, boolean hiddenClosed) throws BGException {
        return (List)this.tryReturn(() -> this.getMegogoContractSubscriptionDao().getContractSubscriptionList(contractId, serviceId, hiddenClosed));
    }

    public List<MegogoContractSubscription> getContractSubscriptionListByType(int contractId, int type, Period period) throws BGException {
        return (List)this.tryReturn(() -> this.getMegogoContractSubscriptionDao().getContractSubscriptionList(contractId, -1, type, period, -1));
    }

    public void subscribe(int contractId, int serviceId) throws BGException {
        this.tryCall(() -> {
            List<MegogoContractSubscription> contractlistAll;
            List<MegogoContractSubscription> mainSubList;
            Contract contract = this.getContract(contractId);
            try (BalanceUtils balanceUtils = new BalanceUtils(this.getConnection());){
                if (balanceUtils.getBalance(new Date(), contract).compareTo(contract.getBalanceLimit()) < 1) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u0438 \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u0431\u0430\u043b\u0430\u043d\u0441\u0435!");
                }
            }
            Date from = new Date();
            int idFrom = -1;
            MegogoSubscription subscription = this.getSubscriptionByServiceId(serviceId);
            if (subscription.getType() == 1 && (mainSubList = this.getMegogoContractSubscriptionDao().getContractSubscriptionList(contractId, -1, 1, new Period(new Date(), null), -1)).size() > 0) {
                MegogoContractSubscription mainSub = mainSubList.get(0);
                if (mainSubList.size() > 1) {
                    MegogoContractSubscription secondSub = mainSubList.get(1);
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0423 \u0432\u0430\u0441 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0437\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u043d\u0430 \u0434\u0440\u0443\u0433\u0443\u044e \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443( \u2116 = " + secondSub.getId() + " )");
                }
                if (mainSub.getServiceId() == serviceId) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0423 \u0432\u0430\u0441 \u0438 \u0442\u0430\u043a \u0438\u043c\u0435\u0435\u0442\u0441\u044f \u0434\u0430\u043d\u043d\u0430\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430!");
                }
                int day = this.dayBetweenChangeSubscription(contractId, mainSub.getServiceId(), serviceId);
                Calendar to = Calendar.getInstance();
                to.add(6, day);
                mainSub.getPeriod().setDateTo(to.getTime());
                this.updateContractSubscription(mainSub, day != 0, subscription);
                to.add(6, 1);
                from = to.getTime();
                idFrom = mainSub.getId();
            }
            boolean firstConnection = (contractlistAll = this.contractSubscriptionList(contractId, -1, false)).size() == 0;
            MegogoContractSubscription service = new MegogoContractSubscription().setCount(1).setContractId(contractId).setServiceId(serviceId).setPeriod(new Period(from, null)).setSubscriptionFrom(idFrom);
            this.updateContractSubscription(service, true);
            MapHolder<Integer, MegogoTryAndBuy> tryAndBuyMap = this.getTryAndBuyMap(true);
            MegogoTryAndBuy tAb = (MegogoTryAndBuy)tryAndBuyMap.getMap().get(subscription.getSid());
            if (tAb != null && (tAb.getType() != 1 || firstConnection)) {
                if (tAb.getType() == 2) {
                    for (MegogoContractSubscription contractSubscription : contractlistAll) {
                        if (contractSubscription.getServiceId() != tAb.getSid()) continue;
                        break;
                    }
                } else {
                    Calendar to = TimeUtils.convertDateToCalendar((Date)from);
                    to.add(5, Utils.parseInt((String)((String)tAb.getParams().get("countDay")), (int)30));
                    MegogoContractTryAndBuy contractTryAndBuy = new MegogoContractTryAndBuy(contractId, tAb.getId(), service.getId(), new Period(from, to.getTime()), this.userId);
                    this.getContractTryAndBuyDao().update(contractTryAndBuy);
                }
            }
        });
    }

    public void unsubscribe(int contractSubscribeId) throws BGException {
        this.tryCall(() -> {
            MegogoContractSubscription contractSub = (MegogoContractSubscription)this.getMegogoContractSubscriptionDao().get(contractSubscribeId);
            if (contractSub == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
            }
            int status = contractSub.getStatus();
            if (status != 0 && status != 4) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u0432 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0435.");
            }
            ModuleSetup moduleSetup = this.getModuleSetup();
            MegogoSubscription subscription = this.getMegogoSubscriptionDao().getByServiceId(contractSub.getServiceId());
            int mode = Utils.parseInt((String)moduleSetup.get("service.unsubscribe.default.mode", "3"), (int)3);
            Calendar to = Calendar.getInstance();
            switch (mode) {
                case 1: {
                    this.requesToMegogo(contractSub, subscription, 2);
                    break;
                }
                case 2: {
                    contractSub.setStatus(1);
                    break;
                }
                default: {
                    TimeUtils.moveToEndOfMonth((Calendar)to);
                    contractSub.setStatus(1);
                }
            }
            contractSub.getPeriod().setDateTo(to.getTime());
            this.getMegogoContractSubscriptionDao().update(contractSub);
        });
    }

    public void suspend(int contractSubscribeId) throws BGException {
        this.tryCall(() -> {
            MegogoContractSubscriptionStatusPeriod statusPeriod;
            MegogoContractSubscription contractSub = (MegogoContractSubscription)this.getMegogoContractSubscriptionDao().get(contractSubscribeId);
            if (contractSub == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
            }
            int status = contractSub.getStatus();
            if (status != 0 && status != 1) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u0432 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0435.");
            }
            MegogoSubscription subscription = this.getMegogoSubscriptionDao().getByServiceId(contractSub.getServiceId());
            this.requesToMegogo(contractSub, subscription, 4);
            contractSub.setUserId(this.userId);
            this.getMegogoContractSubscriptionDao().update(contractSub);
            List<MegogoContractSubscriptionStatusPeriod> list = this.getMegogoContractSubscriptionStatusPeriodDao().getList(contractSubscribeId, 4, false, TimeUtils.getPrevDay((Date)new Date()));
            if (list.size() > 0) {
                statusPeriod = list.get(0);
            } else {
                statusPeriod = new MegogoContractSubscriptionStatusPeriod();
                statusPeriod.setStatus(4);
                statusPeriod.setDateFrom(new Date());
                statusPeriod.setIdSub(contractSubscribeId);
            }
            statusPeriod.setDateTo(null);
            this.getMegogoContractSubscriptionStatusPeriodDao().update(statusPeriod);
        });
    }

    public void resume(int contractSubscribeId) throws BGException {
        this.tryCall(() -> {
            MegogoContractSubscription contractSub = (MegogoContractSubscription)this.getMegogoContractSubscriptionDao().get(contractSubscribeId);
            if (contractSub == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
            }
            int status = contractSub.getStatus();
            if (status != 4) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u0432 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0435.");
            }
            MegogoSubscription subscription = this.getMegogoSubscriptionDao().getByServiceId(contractSub.getServiceId());
            this.requesToMegogo(contractSub, subscription, 6);
            contractSub.setUserId(this.userId);
            contractSub.setStatus(0);
            this.getMegogoContractSubscriptionDao().update(contractSub);
            List<MegogoContractSubscriptionStatusPeriod> list = this.getMegogoContractSubscriptionStatusPeriodDao().getList(contractSubscribeId, 4, true, (Period)null);
            if (list.size() > 0) {
                MegogoContractSubscriptionStatusPeriod statusPeriod;
                if (list.size() > 1) {
                    this.getLogger().error("ERROR. FOUND MORE THAN ONE SUSPEND STATUS PERIOD FOR SUBSCRIPTION id=" + contractSubscribeId);
                }
                if (TimeUtils.dateEqual((Date)(statusPeriod = list.get(0)).getDateFrom(), (Date)new Date())) {
                    this.getMegogoContractSubscriptionStatusPeriodDao().delete(statusPeriod.getId());
                } else {
                    statusPeriod.setDateTo(TimeUtils.getPrevDay((Date)new Date()));
                    this.getMegogoContractSubscriptionStatusPeriodDao().update(statusPeriod);
                }
            } else {
                this.getLogger().error("ERROR. NOT FOUND SUSPEND STATUS PERIOD FOR SUBSCRIPTION id=" + contractSubscribeId);
            }
        });
    }

    public void abortUnsubscribe(int contractSubscribeId) throws BGException {
        this.tryCall(() -> {
            MegogoContractSubscription contractSub = (MegogoContractSubscription)this.getMegogoContractSubscriptionDao().get(contractSubscribeId);
            if (contractSub == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
            }
            if (contractSub.getStatus() != 1) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441!");
            }
            if (contractSub.getDateDeactivated() != null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0423\u0436\u0435 \u0435\u0441\u0442\u044c \u0432\u0440\u0435\u043c\u044f \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438!");
            }
            MegogoContractSubscription to = this.getMegogoContractSubscriptionDao().getByFromId(contractSubscribeId);
            if (to != null) {
                if (to.getStatus() == 3) {
                    this.getMegogoContractSubscriptionDao().delete(to.getId());
                    this.getLogger().debug("Was deleted the megogo subscription on cid=" + contractSub.getContractId() + " sid=" + to.getServiceId());
                } else {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0443 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u043f\u043b\u0430\u043d\u0438\u0440\u0443\u0435\u043c \u043f\u0435\u0440\u0435\u0445\u043e\u0434!");
                }
            }
            contractSub.getPeriod().setDateTo(null);
            contractSub.setStatus(0);
            this.getMegogoContractSubscriptionDao().update(contractSub);
        });
    }

    public List<MegogoContractSubscriptionStatusPeriod> getContractSubscriptionStatusPeriodList(int idSub, int status, Period period) throws BGException {
        return (List)this.tryReturn(() -> this.getMegogoContractSubscriptionStatusPeriodDao().getList(idSub, status, false, period));
    }

    public int updateSubscription(MegogoSubscription subscription) throws BGException {
        return (Integer)this.tryReturn(() -> {
            subscription.setUserId(this.userId);
            this.getMegogoSubscriptionDao().update(subscription);
            return subscription.getId();
        });
    }

    public List<MegogoSubscription> subscriptionList(Boolean used, int type) throws BGException {
        return (List)this.tryReturn(() -> this.getMegogoSubscriptionDao().getSubscriptionList(used, type));
    }

    public MegogoSubscription getSubscriptionByServiceId(int serviceId) throws BGException {
        return (MegogoSubscription)this.tryReturn(() -> this.getMegogoSubscriptionDao().getByServiceId(serviceId));
    }

    public List<MegogoTryAndBuy> getTryAndBuyList(boolean onlyUsed) throws BGException {
        return (List)this.tryReturn(() -> this.getMegogoTryAndBuyDao().getTryAndBuyList(onlyUsed));
    }

    public MapHolder<Integer, MegogoTryAndBuy> getTryAndBuyMap(boolean onlyUsed) throws BGException {
        HashMap<Integer, MegogoTryAndBuy> tryAndBuyMap = new HashMap<Integer, MegogoTryAndBuy>();
        for (MegogoTryAndBuy tAb : this.getTryAndBuyList(onlyUsed)) {
            tryAndBuyMap.put(tAb.getSid(), tAb);
        }
        return new MapHolder(tryAndBuyMap);
    }

    public int updateTryAndBuy(MegogoTryAndBuy megogoTryAndBuy) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.getMegogoTryAndBuyDao().update(megogoTryAndBuy);
            return megogoTryAndBuy.getId();
        });
    }

    public int deleteTryAndBuy(int id) throws BGException {
        return (Integer)this.tryReturn(() -> this.getMegogoTryAndBuyDao().delete(id));
    }

    public List<MegogoContractTryAndBuy> getContractTryAndBuyList(int contractId, Period period) throws BGException {
        return (List)this.tryReturn(() -> this.getContractTryAndBuyDao().getContractTBList(contractId, null, -1));
    }

    public List<MegogoContractSubRequestLog> getContractRequestLog(int contractId) throws BGException {
        return (List)this.tryReturn(() -> this.getMegogoContractSubRequestLogDao().getContractLogList(contractId));
    }

    public MegogoContractCredentials getContractCredentials(int contractId) throws BGException {
        return (MegogoContractCredentials)this.tryReturn(() -> this.getMegogoContractCredentialsDao().getByContractId(contractId));
    }

    public MegogoContractCredentials requestCredentials(int contractId, String login, String pwd) throws BGException {
        return (MegogoContractCredentials)this.tryReturn(() -> {
            MegogoContractCredentials check;
            String localLogin = login;
            int uid = -1;
            MegogoApi megogoApi = new MegogoApi(this.moduleId, this.userId, this.getConnection());
            MegogoContractCredentials credentials = this.getMegogoContractCredentialsDao().getByContractId(contractId);
            if (credentials != null) {
                uid = credentials.getUid();
                MegogoContractCredentials credentialsNew = megogoApi.getMegogoUidAndLogin(contractId);
                if (credentialsNew == null) {
                    throw new BGMessageException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043b\u043e\u0433\u0438\u043d \u0443 Megogo!");
                }
                localLogin = credentialsNew.getLogin();
                uid = credentialsNew.getUid();
            } else if (Utils.notBlankString((String)localLogin) && (check = this.getMegogoContractCredentialsDao().getByLogin(localLogin)) != null) {
                throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u043b\u043e\u0433\u0438\u043d \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f. Cid = " + check.getContractId());
            }
            return megogoApi.requestCredentials(contractId, localLogin, pwd, uid);
        });
    }

    private int dayBetweenChangeSubscription(int contractId, int serviceIdFrom, int serviceIdTo) throws BGException {
        int result = 5;
        ModuleSetup moduleSetup = this.getModuleSetup();
        List list = moduleSetup.getIntegerList("service.main.cost.order", null);
        boolean moreExpensive = true;
        if (list != null) {
            int indexFrom = list.indexOf(serviceIdFrom);
            int indexTo = list.indexOf(serviceIdTo);
            if (indexTo != -1 && indexTo != -1) {
                moreExpensive = indexTo > indexFrom;
            }
        }
        Calendar now = Calendar.getInstance();
        String key = moreExpensive ? "expensive" : "cheap";
        int type = moduleSetup.getInt("service.main.migration." + key + ".type", moreExpensive ? 1 : 2);
        int value = moduleSetup.getInt("service.main.migration." + key + ".value", 1);
        switch (type) {
            case 1: {
                result = value > -1 ? value : TimeUtils.daysDelta((Calendar)now, (Calendar)TimeUtils.getEndMonth((Calendar)now));
                break;
            }
            case 2: {
                result = TimeUtils.daysDelta((Calendar)now, (Calendar)TimeUtils.getEndMonth((Calendar)now));
                break;
            }
            case 3: {
                result = -1;
                break;
            }
            default: {
                result = TimeUtils.daysDelta((Calendar)now, (Calendar)TimeUtils.getEndMonth((Calendar)now));
            }
        }
        return result;
    }

    public String getRedirectUrl(int contratId) throws BGException {
        MegogoApi megogoApi = new MegogoApi(this.moduleId, this.userId, this.getConnection());
        return megogoApi.getRedirectUrl(contratId);
    }

    public void recalculate(Date date, Set<Integer> contractSet) throws BGException {
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new MegogoRecalculator(this.moduleId, TimeUtils.convertDateToCalendar((Date)date), contractSet));
    }

    private MegogoContractSubscriptionDao getMegogoContractSubscriptionDao() {
        this.megogoContractSubscriptionDao = new MegogoContractSubscriptionDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.megogoContractSubscriptionDao).orElse(this.megogoContractSubscriptionDao);
    }

    private MegogoSubscriptionDao getMegogoSubscriptionDao() {
        this.megogoSubscriptionDao = new MegogoSubscriptionDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.megogoSubscriptionDao).orElse(this.megogoSubscriptionDao);
    }

    private MegogoContractSubRequestLogDao getMegogoContractSubRequestLogDao() {
        this.megogoContractSubRequestLogDao = new MegogoContractSubRequestLogDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.megogoContractSubRequestLogDao).orElse(this.megogoContractSubRequestLogDao);
    }

    private MegogoTryAndBuyDao getMegogoTryAndBuyDao() {
        this.megogoTryAndBuyDao = new MegogoTryAndBuyDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.megogoTryAndBuyDao).orElse(this.megogoTryAndBuyDao);
    }

    private MegogoContractTryAndBuyDao getContractTryAndBuyDao() {
        this.megogoContractTryAndBuyDao = new MegogoContractTryAndBuyDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.megogoContractTryAndBuyDao).orElse(this.megogoContractTryAndBuyDao);
    }

    private MegogoContractSubscriptionStatusPeriodDao getMegogoContractSubscriptionStatusPeriodDao() {
        this.megogoContractSubscriptionStatusPeriodDao = new MegogoContractSubscriptionStatusPeriodDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.megogoContractSubscriptionStatusPeriodDao).orElse(this.megogoContractSubscriptionStatusPeriodDao);
    }

    private MegogoContractCredentialsDao getMegogoContractCredentialsDao() {
        this.megogoContractCredentialsDao = new MegogoContractCredentialsDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.megogoContractCredentialsDao).orElse(this.megogoContractCredentialsDao);
    }
}

