/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageContract;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageOption;
import ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHousePackageService;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.PackageOptionBase;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHousePackageBaseDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHousePackageContractDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHousePackageOptionDao;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHousePackageService")
public class SmartHousePackageServiceImpl
extends AbstractService
implements SmartHousePackageService {
    private SmartHousePackageContractDao smartHousePackageContractDao;

    private SmartHousePackageContractDao getSmartHousePackageContractDao() {
        this.smartHousePackageContractDao = new SmartHousePackageContractDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.smartHousePackageContractDao).orElse(this.smartHousePackageContractDao);
    }

    public SearchResult<SmartHousePackageContract> packageContractSearch(int contractId, boolean showOld, String[] sort, Page page) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult(page, sort);
            this.getSmartHousePackageContractDao().searchContractPackages((SearchResult<SmartHousePackageContract>)searchResult, contractId);
            return searchResult;
        });
    }

    public SearchResult<SmartHousePackageBase> packageBaseSearch(String title, boolean showOld, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(page, sort);
        try (SmartHousePackageBaseDao basePackageDao = new SmartHousePackageBaseDao(this.getConnection(), this.moduleId);){
            basePackageDao.searchPackageBases((SearchResult<SmartHousePackageBase>)searchResult, title, showOld);
        }
        return searchResult;
    }

    public SmartHousePackageBase smartHousePackageBaseGet(int packageBaseId) throws BGException {
        try (SmartHousePackageBaseDao packageBaseDao = new SmartHousePackageBaseDao(this.getConnection(), this.moduleId);){
            SmartHousePackageBase smartHousePackageBase = (SmartHousePackageBase)packageBaseDao.get(packageBaseId);
            return smartHousePackageBase;
        }
    }

    public SmartHousePackageBase smartHousePackageBaseUpdate(SmartHousePackageBase packageBase) throws BGException {
        return (SmartHousePackageBase)this.tryReturn(() -> {
            try (SmartHousePackageBaseDao packageBaseDao = new SmartHousePackageBaseDao(this.getConnection(), this.moduleId);){
                packageBaseDao.update(packageBase);
                SmartHousePackageBase smartHousePackageBase = packageBase;
                return smartHousePackageBase;
            }
        });
    }

    public void packageBaseOptionUpdate(int packageBaseId, String optionNames) throws BGException {
        try (SmartHousePackageBaseDao packageBaseDao = new SmartHousePackageBaseDao(this.getConnection(), this.moduleId);){
            packageBaseDao.updateOptions(packageBaseId, optionNames);
        }
    }

    public List<IdTitle> smartHousePackageBaseList() throws BGException {
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        try (SmartHousePackageBaseDao packageBaseDao = new SmartHousePackageBaseDao(this.getConnection(), this.moduleId);){
            for (SmartHousePackageBase housePackageBase : packageBaseDao.list()) {
                list.add(new IdTitle(housePackageBase.getId(), housePackageBase.getTitle()));
            }
        }
        return list;
    }

    public SmartHousePackageContract packageContractGet(int contractId, int packageContractId) throws BGException {
        return (SmartHousePackageContract)this.tryReturn(() -> {
            int localPackageContractId = packageContractId;
            if (localPackageContractId == 0) {
                int[] ids = this.packageContractNavigationIds(contractId, localPackageContractId);
                localPackageContractId = ids[1];
            }
            return (SmartHousePackageContract)this.getSmartHousePackageContractDao().get(localPackageContractId);
        });
    }

    public SmartHousePackageContract packageContractUpdate(SmartHousePackageContract packageContract) throws BGException {
        return (SmartHousePackageContract)this.tryReturn(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public void packageContractDelete(int contractId, int packageContractId) throws BGException {
        this.tryCall(() -> this.getSmartHousePackageContractDao().delete(packageContractId));
    }

    public int[] packageContractNavigationIds(int contractId, int packageContractId) throws BGException {
        return (int[])this.tryReturn(() -> this.getSmartHousePackageContractDao().getNavigationIds(contractId, packageContractId));
    }

    public List<SmartHousePackageOption> packageOptionList() throws BGException {
        ArrayList<SmartHousePackageOption> list = new ArrayList<SmartHousePackageOption>();
        try (SmartHousePackageOptionDao packageOptionDao = new SmartHousePackageOptionDao(this.getConnection(), this.moduleId);){
            Map<String, SmartHousePackageOption> optionMap = packageOptionDao.getOptionMap();
            for (PackageOptionBase packageOptionBase : PackageOptionBase.values()) {
                SmartHousePackageOption packageOption = new SmartHousePackageOption();
                SmartHousePackageOption packageOption2 = optionMap.get(packageOptionBase.getName());
                packageOption.setName(packageOptionBase.getName());
                if (packageOption2 != null) {
                    packageOption.setTitle(packageOption2.getTitle());
                    packageOption.setServiceId(packageOption2.getServiceId());
                } else {
                    packageOption.setTitle(packageOptionBase.getTitle());
                }
                list.add(packageOption);
            }
        }
        return list;
    }

    public SmartHousePackageOption packageOptionGet(int packageOptionId) throws BGException {
        return null;
    }

    public SmartHousePackageOption packageOptionUpdate(SmartHousePackageOption packageOption) throws BGException {
        return (SmartHousePackageOption)this.tryReturn(() -> {
            try (SmartHousePackageOptionDao packageOptionDao = new SmartHousePackageOptionDao(this.getConnection(), this.moduleId);){
                packageOptionDao.update(packageOption);
                SmartHousePackageOption smartHousePackageOption = packageOption;
                return smartHousePackageOption;
            }
        });
    }

    public List<String> serviceList() throws BGException {
        ArrayList<String> list = new ArrayList<String>();
        ModuleService moduleService = (ModuleService)((ServerContext)ServerContext.get(ServerContext.class)).getService(ModuleService.class, 0);
        for (Service service : moduleService.serviceList(this.moduleId)) {
            JSONObject json = new JSONObject().put("key", service.getId()).put("value", (Object)service.getTitle());
            list.add(json.toString());
        }
        return list;
    }

    public List<IdTitle> npayModules() throws BGException {
        return ModuleCache.getInstance().getModulesList("npay").stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList();
    }

    public List<IdTitle> npayServices(int moduleId) throws BGException {
        return ModuleCache.getInstance().getModuleServicesList(moduleId).stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList();
    }

    private static /* synthetic */ void lambda$packageContractUpdate$3(JSONObject data, Object o) {
        data.put(String.valueOf(o), 0);
    }
}

