/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAccountingPeriod;
import ru.bitel.common.util.AbstractPeriodItemSet;
import ru.bitel.common.util.PeriodItemSet;

public final class InetAccountingPeriodList
extends PeriodItemSet {
    private static final Logger logger = LogManager.getLogger();

    InetAccountingPeriodList(List<AbstractPeriodItemSet.PeriodItem> entryList) {
        super(entryList);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(160);
            sb.append("Create: \n");
            for (AbstractPeriodItemSet.PeriodItem item : this.entries) {
                item.toString(sb.append("\t\tAccountingPeriod: ")).append("\n");
            }
            sb.setLength(sb.length() - 1);
            logger.debug(sb.toString());
        }
    }

    InetAccountingPeriodList(AbstractPeriodItemSet.PeriodItem[] entries) {
        super(entries);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(160);
            sb.append("Create: \n");
            for (AbstractPeriodItemSet.PeriodItem item : entries) {
                item.toString(sb.append("\t\tAccountingPeriod: ")).append("\n");
            }
            sb.setLength(sb.length() - 1);
            logger.debug(sb.toString());
        }
    }

    protected boolean containsMillis(AbstractPeriodItemSet.PeriodItem item, long millis) {
        return item.timeFrom <= millis && (item.timeTo == 0L || millis <= item.timeTo);
    }

    protected boolean isCoincide(AbstractPeriodItemSet.PeriodItem item, AbstractPeriodItemSet.PeriodItem other) {
        return other.id == item.id;
    }

    public InetAccountingPeriodList add(InetAccountingPeriod accountingPeriod, Calendar utilCalendar) {
        long timeFrom = InetAccountingPeriodList.timeFrom(accountingPeriod.getDateFrom());
        long timeTo = InetAccountingPeriodList.timeTo(accountingPeriod.getDateTo());
        return new InetAccountingPeriodList(super.add(new AbstractPeriodItemSet.PeriodItem(accountingPeriod.getId(), timeFrom, timeTo)));
    }

    public InetAccountingPeriodList update(InetAccountingPeriod accountingPeriod, Calendar utilCalendar) {
        long timeFrom = InetAccountingPeriodList.timeFrom(accountingPeriod.getDateFrom());
        long timeTo = InetAccountingPeriodList.timeTo(accountingPeriod.getDateTo());
        return new InetAccountingPeriodList(super.update(new AbstractPeriodItemSet.PeriodItem(accountingPeriod.getId(), timeFrom, timeTo)));
    }

    public InetAccountingPeriodList remove(InetAccountingPeriod accountingPeriod, Calendar utilCalendar) {
        long timeFrom = InetAccountingPeriodList.timeFrom(accountingPeriod.getDateFrom());
        long timeTo = InetAccountingPeriodList.timeTo(accountingPeriod.getDateTo());
        return new InetAccountingPeriodList(super.remove(new AbstractPeriodItemSet.PeriodItem(accountingPeriod.getId(), timeFrom, timeTo)));
    }

    public static void main(String[] args) {
        InetAccountingPeriodList list = new InetAccountingPeriodList(new ArrayList<AbstractPeriodItemSet.PeriodItem>());
        list = new InetAccountingPeriodList(list.add(new AbstractPeriodItemSet.PeriodItem(1, 1L, 2L)));
        list = new InetAccountingPeriodList(list.add(new AbstractPeriodItemSet.PeriodItem(2, 3L, 4L)));
        list = new InetAccountingPeriodList(list.remove(new AbstractPeriodItemSet.PeriodItem(2, 3L, 4L)));
    }

    public static InetAccountingPeriodList newInstance(List<InetAccountingPeriod> accountingPeriodList, Calendar utilCalendar) {
        ArrayList<AbstractPeriodItemSet.PeriodItem> result = new ArrayList<AbstractPeriodItemSet.PeriodItem>();
        for (InetAccountingPeriod accountingPeriod : accountingPeriodList) {
            long timeFrom = InetAccountingPeriodList.timeFrom(accountingPeriod.getDateFrom());
            long timeTo = InetAccountingPeriodList.timeTo(accountingPeriod.getDateTo());
            result.add(new AbstractPeriodItemSet.PeriodItem(accountingPeriod.getId(), timeFrom, timeTo));
        }
        return new InetAccountingPeriodList(result);
    }

    private static long timeFrom(Date date) {
        if (date == null) {
            return 0L;
        }
        long millis = date.getTime();
        return millis / 1000L * 1000L;
    }

    private static long timeTo(Date date) {
        if (date == null) {
            return 0L;
        }
        long millis = date.getTime();
        return millis / 1000L * 1000L + 999L;
    }
}

