/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.radius;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListener;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorkerContext;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAuthError;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAuthErrorDao;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNas;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNasConnection;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAbtractAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntime;
import ru.bitel.common.model.Idable;
import ru.bitel.common.sql.ConnectionSet;

public class VoiceRadiusListenerWorker
extends RadiusListenerWorker<VoiceNas> {
    public VoiceRadiusListenerWorker(RadiusListener<VoiceNas> listener, SocketAddress clientAddress, long millis, ByteBuffer data, int overloadLevel) {
        super(listener, clientAddress, millis, data, overloadLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accessRequest(VoiceNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) throws BGException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        try {
            this.processor.accessRequest((RadiusListenerWorker)this, (Nas)nas, 0, request, response, connectionSet);
            connectionSet.commit();
            if (this.radiusSession != null && this.radiusSession.errorCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                // empty if block
            }
        }
        finally {
            ByteBuffer responseData = ByteBuffer.allocate(4096);
            response.write(responseData, nas.getSecret());
            responseData.flip();
            try {
                this.writeLog(connectionSet, time, responseData);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.send(this.clientAddress, responseData);
            logger.info("RESPONSE:\n" + response.toString());
        }
    }

    private void writeLog(ConnectionSet connectionSet, Date time, ByteBuffer responseData) throws Exception {
        if (this.response.getCode() == 2 || this.response.getCode() == 3) {
            int[] requestPositions = new int[3];
            int[] responsePositions = new int[3];
            this.data.rewind();
            ((RadiusListenerWorkerContext)this.context).writeRecord((Idable)this.nas, requestPositions, this.data, time.getTime());
            ((RadiusListenerWorkerContext)this.context).writeRecord((Idable)this.nas, responsePositions, responseData, time.getTime());
            responseData.rewind();
            ConnectionLogEntry entry = this.saveConnectionCoordinate(connectionSet, time, requestPositions, responsePositions, 1, 0L, (VoiceNas)this.nas);
            if (this.radiusSession.errorCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                VoiceAuthError error = new VoiceAuthError();
                error.setDeviceId(((VoiceNas)this.nas).getId());
                error.setDeviceTitle(((VoiceNas)this.nas).getNasIdentifier());
                if (this.radiusSession.contract != null) {
                    error.setContractId(this.radiusSession.contract.getId());
                    error.setContractTitle(this.radiusSession.contract.getTitle());
                }
                if (this.radiusSession.errorCode != AccessCode.INVALID_ACCOUNT.getCode() && this.radiusSession.login != null) {
                    VoiceAbtractAccountRuntime accountRuntime = (VoiceAbtractAccountRuntime)((Object)this.radiusSession.login);
                    error.setAccountId(accountRuntime.getAccountId());
                    error.setAccountTitle(accountRuntime.getTitle());
                }
                error.setLogCoordinateRecordId(entry.getId());
                error.setErrorCode(this.radiusSession.errorCode);
                new VoiceAuthErrorDao(connectionSet, this.processor.moduleId, new Date()).addError(error);
            }
        }
    }

    protected ConnectionLogEntry saveConnectionCoordinate(ConnectionSet connectionSet, Date time, int[] requestPositions, int[] responsePositions, int logType, long connectionId, VoiceNas nas) throws BGException {
        ConnectionLogEntry entry = new ConnectionLogEntry();
        entry.setApplicationId(this.processor.applicationId);
        entry.setDeviceId(nas.getId());
        entry.setDevicePort(RadiusUtils.getNasPort((RadiusPacket)this.request));
        entry.setConnectionId(connectionId);
        entry.setTime(time);
        entry.setAcctSessId(this.request.getStringAttribute(-1, 44, ""));
        entry.setLogType(logType);
        entry.setConnectionId(connectionId);
        entry.setRequestDataLogId(requestPositions[0]);
        entry.setRequestChunkId(requestPositions[1]);
        entry.setRequestPosition(requestPositions[2]);
        entry.setIdentifier(nas.getIdentifier(this.request));
        if (responsePositions != null) {
            entry.setResponseDataLogId(responsePositions[0]);
            entry.setResponseChunkId(responsePositions[1]);
            entry.setResponsePosition(responsePositions[2]);
        }
        try (ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(connectionSet, this.processor.moduleId);){
            dataLogEntryDao.update(entry);
        }
        return entry;
    }

    protected void accountingRequest(VoiceNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) throws BGException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        VoiceSessionRuntime sessionRuntime;
        int[] coords = new int[3];
        ((RadiusListenerWorkerContext)this.context).writeRecord((Idable)nas, coords, this.data, time.getTime());
        VoiceNasConnection nasConnection = (VoiceNasConnection)this.processor.accountingRequest((RadiusListenerWorker)this, (Nas)nas, request, response, connectionSet, time);
        long connectionId = 0L;
        connectionId = nasConnection != null && (sessionRuntime = (VoiceSessionRuntime)nasConnection.getSession()) != null ? sessionRuntime.getSession().getId() : 0L;
        if (this.isConnectionModified()) {
            this.saveConnectionCoordinate(connectionSet, time, coords, null, 2, connectionId, nas);
        }
    }
}

