/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.update.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Utils;

public class LibInfo
extends BGLogger
implements Comparator<LibInfo> {
    private String type;
    private String dir;
    private String toDir;
    private String name;
    private String hash;
    private File file;

    @Override
    public int compare(LibInfo libInfo1, LibInfo libInfo2) {
        return libInfo1.getName().compareToIgnoreCase(libInfo2.getName());
    }

    public String getDir() {
        return this.dir;
    }

    public File getFile() {
        return this.file;
    }

    public String getHash() {
        return this.hash;
    }

    public String getName() {
        return this.name;
    }

    public String getToDir() {
        return this.toDir;
    }

    public String getType() {
        return this.type;
    }

    public void serializeLib(OutputStream outputStream) throws IOException {
        byte[] bytes = this.getType().getBytes("UTF-8");
        outputStream.write(bytes.length);
        outputStream.write(bytes);
        Object name = this.getName();
        if (Utils.notBlankString(this.toDir)) {
            int pos = ((String)name).lastIndexOf("/");
            if (pos > -1) {
                name = ((String)name).substring(pos + 1);
            }
            name = this.toDir + "/" + (String)name;
        }
        this.getLogger().debug("this.name={}; this.toDir={}; name={}", new Object[]{this.getName(), this.getToDir(), name});
        bytes = ((String)name).getBytes("UTF-8");
        outputStream.write(bytes.length);
        outputStream.write(bytes);
        long length = this.getFile().length();
        outputStream.write(LibInfo.longToBytes(length));
        try (FileInputStream fileInputStream = new FileInputStream(this.getFile());){
            Utils.flush(fileInputStream, outputStream);
        }
    }

    public LibInfo setDir(String dir) {
        this.dir = dir;
        return this;
    }

    public LibInfo setFile(File file) {
        this.file = file;
        return this;
    }

    public LibInfo setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public LibInfo setName(String name) {
        this.name = name;
        return this;
    }

    public LibInfo setToDir(String toDir) {
        this.toDir = toDir;
        return this;
    }

    public LibInfo setType(String type) {
        this.type = type;
        return this;
    }

    public String toString() {
        return String.format("%s\t%s\t%s", this.name, this.hash, this.file.toString());
    }

    public static byte[] longToBytes(long x) {
        return ByteBuffer.allocate(8).putLong(x).array();
    }
}

