/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.table.renderer;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class BooleanTableCellRenderer
extends JCheckBox
implements TableCellRenderer {
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border border = new EmptyBorder(1, 3, 1, 3);

    public BooleanTableCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setBorderPainted(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (value instanceof String) {
            value = Boolean.valueOf((String)value);
        }
        this.setSelected(value != null && (Boolean)value != false);
        if (hasFocus) {
            this.setBorder(BorderFactory.createCompoundBorder(border, UIManager.getBorder("Table.focusCellHighlightBorder")));
        } else {
            this.setBorder(BorderFactory.createCompoundBorder(border, noFocusBorder));
        }
        return this;
    }
}

