/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.EnigoCasCommand;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.EnigoCasException;
import ru.bitel.common.TimeUtils;

public class CommandSubscriptionsList
extends EnigoCasCommand {
    List<SubscriptionInfo> infos = new ArrayList<SubscriptionInfo>();

    public CommandSubscriptionsList(long cardNumber) {
        this.parammap.put("serial-no", cardNumber);
    }

    @Override
    public int getCommandNumber() {
        return 5;
    }

    @Override
    public void checkCommandError(int errorcode) throws EnigoCasException {
        switch (errorcode) {
            case 4: {
                throw new EnigoCasException(this.getCommandNumber(), errorcode, "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043f\u043e \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c\u0443 \u043a\u0440\u0438\u0442\u0435\u0440\u0438\u044e");
            }
        }
        throw new EnigoCasException(this.getCommandNumber(), errorcode, "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
    }

    private static Date parseDate(String date) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.parse(date);
    }

    private static boolean almostEqualDate(Date date1, Date date2) {
        return Math.abs(date1.getTime() - date2.getTime()) < 60000L;
    }

    @Override
    public void setResponse(String response) throws BGException, EnigoCasException {
        try {
            List values = new CSVReader((Reader)new StringReader(response), ';').readAll();
            for (String[] line : values) {
                boolean isremoved = "true".equalsIgnoreCase(line[8]);
                Date time_start = CommandSubscriptionsList.parseDate(line[5]);
                Date time_stop = CommandSubscriptionsList.parseDate(line[6]);
                if (isremoved) continue;
                this.infos.add(new SubscriptionInfo(Long.valueOf(line[0]), line[1], line[2], line[3], line[4], time_start, time_stop, line[7], isremoved));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BGException("error parse response: too few columns", (Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new BGException("error parse response: column format", (Throwable)e);
        }
        catch (ParseException e) {
            throw new BGException("error parse response: date format", (Throwable)e);
        }
        catch (IOException e) {
            throw new BGException("error parse response: io", (Throwable)e);
        }
    }

    public List<SubscriptionInfo> getSubscriptionInfo() {
        return this.infos;
    }

    public static class SubscriptionInfo {
        public Long serial_no;
        public String subscription_id;
        public String package_code;
        public String subscription_type;
        public String subscription_slot;
        public Date time_start;
        public Date time_stop;
        public String is_running;
        public boolean is_removed;

        public SubscriptionInfo(Long serial_no, String subscription_id, String package_code, String subscription_type, String subscription_slot, Date time_start, Date time_stop, String is_running, boolean is_removed) {
            this.serial_no = serial_no;
            this.subscription_id = subscription_id;
            this.package_code = package_code;
            this.subscription_type = subscription_type;
            this.subscription_slot = subscription_slot;
            this.time_start = time_start;
            this.time_stop = time_stop;
            this.is_running = is_running;
            this.is_removed = is_removed;
        }

        public static String getHeader() {
            return "serial-no | subscription-id | package-code | subscription-type | subscription-slot | time-start | time-stop | is-running | is-removed";
        }

        public String toString() {
            return String.format("%s | %s | %s | %s | %s | %s | %s | %s | %s", this.serial_no, this.subscription_id, this.package_code, this.subscription_type, this.subscription_slot, this.time_start, this.time_stop, this.is_running, this.is_removed);
        }
    }

    public static class SubscriptionInfoComparator
    implements DigitalTVServiceActivator.SubscriptionComparatorForEqualizer<SubscriptionInfo> {
        @Override
        public boolean subscriptionEquals(DigitalTVServiceActivator.CardPacketCodePair cardpacket, SubscriptionInfo casPacket) {
            boolean date1eq = CommandSubscriptionsList.almostEqualDate(TimeUtils.clear_HOUR_MIN_MIL_SEC((Date)cardpacket.cardpacket.getDateFrom()), casPacket.time_start);
            boolean date2eq = cardpacket.cardpacket.getDateTo() == null || CommandSubscriptionsList.almostEqualDate(TimeUtils.getEndDay((Date)cardpacket.cardpacket.getDateTo()), casPacket.time_stop);
            return date1eq && date2eq && cardpacket.cardnumber == casPacket.serial_no && cardpacket.packetCode.trim().equals(casPacket.package_code.trim());
        }
    }
}

