/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import org.json.JSONObject;
import org.slf4j.MDC;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.Transaction;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="TinkoffExecutor", urlPatterns={"/tinkoff/*"})
public class ModuleExecutor
extends CommonExecutor {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection con = null;
        try {
            int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            Setup setup = Setup.getSetup();
            con = setup.getDBConnectionFromPool();
            ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(moduleId));
            MDC.put((String)"module", (String)"tinkoff");
            MDC.put((String)"moduleId", (String)String.valueOf(moduleId));
            byte[] bytes = Utils.readByBlock((InputStream)request.getInputStream());
            String data = new String(bytes, "UTF-8");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("In data = " + data);
            }
            if (Utils.isBlankString((String)data)) {
                this.getLogger().error("Request data is empty!!!");
                this.send(response);
                return;
            }
            JSONObject requestJsonObject = new JSONObject(data);
            String inToken = requestJsonObject.optString("Token");
            TransactionManager transactionManager = new TransactionManager(con, moduleId);
            String password = moduleSetup.get("tinkoff.terminal.pswd", "");
            String calcToken = transactionManager.getToken(requestJsonObject, password);
            if (inToken == null || !inToken.equalsIgnoreCase(calcToken)) {
                this.getLogger().error("inToken = " + inToken);
                this.getLogger().error("calcToken  = " + calcToken);
                this.send(response);
                return;
            }
            String orderId = requestJsonObject.optString("OrderId");
            String transactionId = requestJsonObject.optString("PaymentId");
            Transaction transaction = (Transaction)transactionManager.get(Utils.parseInt((String)orderId));
            if (transaction == null) {
                this.getLogger().error("Not found transaction for ID = " + orderId);
                this.send(response);
                return;
            }
            if (transaction.getTransactionId() == null || !transaction.getTransactionId().equals(transactionId)) {
                this.getLogger().error("Transaction for ID = " + orderId + "( " + transaction.getTransactionId() + " != " + transactionId + " )");
                this.send(response);
                return;
            }
            MDC.put((String)"contractId", (String)String.valueOf(transaction.getContractId()));
            transactionManager.check(transaction, requestJsonObject);
            this.send(response);
        }
        catch (Exception ex) {
            this.logError(ex);
            response.sendError(500, ex.getMessage());
        }
        finally {
            MDC.remove((String)"module");
            MDC.remove((String)"moduleId");
            MDC.remove((String)"contractId");
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private void send(HttpServletResponse response) {
        response.setStatus(200);
        response.setContentType("text/plain");
        try (PrintWriter printWriter = response.getWriter();){
            printWriter.write("OK");
            printWriter.flush();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }
}

