<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
	<!ENTITY copy   "&#169;">
	<!ENTITY reg    "&#174;">
	<!ENTITY trade  "&#8482;">
	<!ENTITY mdash  "&#8212;">
	<!ENTITY ldquo  "&#8220;">
	<!ENTITY rdquo  "&#8221;"> 
	<!ENTITY pound  "&#163;">
	<!ENTITY yen    "&#165;">
	<!ENTITY euro   "&#8364;">
]>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:utils="ru.bitel.bgbilling.server.util.ServerUtils"
	xmlns:bg="ru.bitel.bgbilling.server.util.exslt.BGXsltFunctions">

	<xalan:component prefix="bg" functions="counterAdd counterSet counterGet">
		<xalan:script lang="javaclass" src="xalan://ru.bitel.bgbilling.server.util.exslt.BGXsltFunctions" />
	</xalan:component>

	<xsl:output encoding="UTF-8" method='xml' indent='yes' />

	<!-- Список атрибутов: payment_purpose Назначение платежа bill_number Номер 
		счета date Дата выписки payer Плательщик total_sum Итого: Сумма total_NDS 
		Итого: НДС total_sumWithNDS Итого: Всего с НДС total_toPay Итого к оплате 
		<pay //\//\//\//\//\//\//\//\//\// goods Товар unit Ед. amount Кол-во price 
		Цена sum Сумма NDS НДС sumWithNDS Всего с НДС //\//\//\//\//\//\//\//\//\// 
		/> -->

	<!-- РЕКВИЗИТЫ ПРЕДПРИЯТИЯ -->
	<xsl:variable name="postal_address" select="'450001, Российская Федерация, Республика Башкортостан, г.XXX, проспект Октября, д.X, адм. здание'" />
	<xsl:variable name="INN" select="'000000000'" />
	<xsl:variable name="KPP" select="'000000000'" />
	<xsl:variable name="title" select="'ОАО &quot;XXXXX&quot;'" />
	<xsl:variable name="OKVED" select="'ОКВЭД 82000'" />
	<xsl:variable name="OKPO" select="'ОКПО 45219144'" />
	<!-- РЕКВИЗИТЫ ПРЕДПРИЯТИЯ -->

	<xsl:variable name="currency" select="'рубль'" />

	<!-- конец Костанты -->

	<xsl:attribute-set name="text">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text7">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text_ban">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-size">6pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text_bold">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table_text_left">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table_text_right">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table_text_center">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text_title">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text_italic">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table_text7_left">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="space-before">0.05cm</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
		<xsl:attribute name="linefeed-treatment">preserve</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table_text7_right">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="space-before">0.05cm</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
		<xsl:attribute name="linefeed-treatment">preserve</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table_text7_center">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.05cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.05cm</xsl:attribute>
		<xsl:attribute name="space-before">0.05cm</xsl:attribute>
		<xsl:attribute name="space-after">0.05cm</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
		<xsl:attribute name="linefeed-treatment">preserve</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table_text6_center">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-size">6pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.05cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.05cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
		<xsl:attribute name="space-after">0.2cm</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
		<xsl:attribute name="linefeed-treatment">preserve</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="table_text6_center_new">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-size">6pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.05cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.05cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
		<xsl:attribute name="space-after">0.37cm</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
		<xsl:attribute name="linefeed-treatment">preserve</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="table_text5_center">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-size">5pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.05cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.05cm</xsl:attribute>
		<xsl:attribute name="space-before">0.05cm</xsl:attribute>
		<xsl:attribute name="space-after">0.05cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell_border">
		<xsl:attribute name="border-width">0.7pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell_border_top">
		<xsl:attribute name="border-width">0.7pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell_border_bottom">
		<xsl:attribute name="border-width">0.7pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="padding-left">1mm</xsl:attribute>
		<xsl:attribute name="padding-right">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">0.5mm</xsl:attribute>
		<xsl:attribute name="padding-bottom">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:template match="data">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<xsl:apply-templates select="bill" />
		</fo:root>
	</xsl:template>

	<xsl:template match="bill">
		<xsl:variable name="nds_rate" select="number(params/@nds)" />
		<xsl:value-of select="bg:counterSet('total_nds', '0.0')" />
		<!-- <xsl:variable name="total_nds" select="number((@total_sum * ($nds_rate div 100))div($nds_rate div 100 + 1))" /> -->

		<fo:layout-master-set>
			<fo:simple-page-master margin-right="2cm"
				margin-left="2cm" margin-bottom="1cm" margin-top="0.5cm" page-width="29.7cm"
				page-height="21cm" master-name="first">
				<fo:region-body margin-top="0cm" margin-bottom="0.0cm" />
				<fo:region-before extent="0cm" />
				<fo:region-after extent="0.5cm" />
			</fo:simple-page-master>
			<fo:simple-page-master margin-right="2cm"
				margin-left="2cm" margin-bottom="1cm" margin-top="0.5cm" page-width="21cm"
				page-height="29.7cm" master-name="second">
				<fo:region-body margin-top="0cm" margin-bottom="0.0cm" />
				<fo:region-before extent="0cm" />
				<fo:region-after extent="0.5cm" />
			</fo:simple-page-master>
		</fo:layout-master-set>

		<fo:page-sequence master-reference="first">
			<fo:flow flow-name="xsl-region-body" font-family="sans-serif">

				<fo:block xsl:use-attribute-sets="text">&#160;</fo:block>
				<!-- Таблица с заголовком и шапкой в правом углу -->
				<fo:table table-layout="fixed">
					<fo:table-column />
					<fo:table-column column-width="11.5cm" />
					
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text_title" text-align="left">Счет-фактура № <xsl:value-of select="@bill_number" />  от <xsl:value-of select="@date" /></fo:block>
								<fo:block xsl:use-attribute-sets="text_title" text-align="left">Исправление №   
									<xsl:choose>
										<xsl:when test="@correction=0">-</xsl:when>
										<xsl:when test="@correction"><xsl:value-of select="@correction" /> от <xsl:value-of select="@correction_date" /></xsl:when>
										<xsl:otherwise>-</xsl:otherwise>
									</xsl:choose>
								</fo:block>
								<fo:block xsl:use-attribute-sets="text_bold" space-before="5mm">Продавец: <xsl:value-of select="$title" /></fo:block>
								<fo:block xsl:use-attribute-sets="text">Адрес: <xsl:value-of select="$postal_address" /></fo:block>
								<fo:block xsl:use-attribute-sets="text">ИНН/КПП Продавца: <xsl:value-of select="$INN" />/<xsl:value-of select="$KPP" /></fo:block>
								<fo:block xsl:use-attribute-sets="text">Грузоотправитель и его адрес: <xsl:value-of select="/data/bill/attributes/@otpr_org_name" /></fo:block>
								<fo:block xsl:use-attribute-sets="text">Грузополучатель и его адрес: <xsl:value-of select="/data/bill/attributes/@pol_org_name" /></fo:block>
								<fo:block xsl:use-attribute-sets="text">
									<xsl:variable name="payDoc">
										<xsl:choose>
											<xsl:when test="string-length(@paymentDocument)>0"><xsl:value-of select="@paymentDocument"/></xsl:when>
											<xsl:when test="string-length(@payDoc)>0"><xsl:value-of select="@payDoc"/></xsl:when>
										</xsl:choose>
									</xsl:variable>
									<xsl:variable name="payDocDate">
										<xsl:choose>
											<xsl:when test="string-length(@paymentDocumentFromDate)>0"><xsl:value-of select="@paymentDocumentFromDate"/></xsl:when>
											<xsl:when test="string-length(@payDocDate)>0"><xsl:value-of select="@payDocDate"/></xsl:when>
										</xsl:choose>
									</xsl:variable>
									К платежно-расчетному документу
									<xsl:choose>
										<xsl:when test="string-length($payDoc)>0">
											№ <xsl:value-of select="$payDoc" /> от  
											<xsl:value-of select="substring($payDocDate,1,2)" />&#160;
											<xsl:call-template name="month2"><xsl:with-param name="month" select="number(substring($payDocDate,4,2)) - 1" /></xsl:call-template>&#160;
											<xsl:value-of select="substring($payDocDate,7)" /> г.
										</xsl:when>
										<xsl:otherwise> - </xsl:otherwise>
									</xsl:choose>
								</fo:block>
								<fo:block xsl:use-attribute-sets="text">Покупатель: <xsl:value-of select="/data/bill/attributes/@org_name" /></fo:block>
								<fo:block xsl:use-attribute-sets="text">Адрес: <xsl:value-of select="/data/bill/attributes/@address" /></fo:block>
								<fo:block xsl:use-attribute-sets="text">ИНН/КПП покупателя: <xsl:value-of select="/data/bill/attributes/@inn" />/<xsl:value-of select="/data/bill/attributes/@kpp" /></fo:block>
								<fo:block xsl:use-attribute-sets="text">Валюта: 643 наименование Российский рубль</fo:block>
								<fo:block xsl:use-attribute-sets="text">Идентификатор государственного контракта, договора(соглашения): <xsl:value-of select="@identifierGovermentContract" /></fo:block>
							</fo:table-cell>
							
							<fo:table-cell>
								<!-- заголовок -->
								<fo:block xsl:use-attribute-sets="text_ban">Приложение №1</fo:block>
								<fo:block xsl:use-attribute-sets="text_ban">к правилам ведения журналов учетов полученных и выставленных счетов-фактур,</fo:block>
								<fo:block xsl:use-attribute-sets="text_ban">книг покупок и книг продаж при расчетах по налогу на добавленную стоимость,</fo:block>
								<fo:block xsl:use-attribute-sets="text_ban">утвержденным постановлением Правительства РФ от 2 декабря 2000г. №914</fo:block>
								<fo:block xsl:use-attribute-sets="text_ban">(в ред. постановлений Правительства Российской Федерации от 15 марта 2001 г. № 189,</fo:block>
								<fo:block xsl:use-attribute-sets="text_ban">от 27 июля 2002 г. № 575, от 16 февраля 2004 г. № 84, от 11 мая 2006 г. №283, от 26 мая 2009 г. № 451</fo:block>
								<fo:block xsl:use-attribute-sets="text_ban"> от 26 декабря 2011 г. № 1137)</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				<!-- Основная таблица в СФ -->
				<fo:table space-before="0.2cm" table-layout="fixed" border-width="0.7pt" border-style="solid" font-size="7pt">
					<fo:table-column column-width="6.0cm" border-right-style="solid"/> <!-- 1 -->
					<fo:table-column column-width="0.8cm" border-right-style="solid"/> <!-- 2 -->
					<fo:table-column column-width="1.7cm" border-right-style="solid"/> <!-- 2a -->
					<fo:table-column column-width="1.4cm" border-right-style="solid"/> <!-- 3 -->
					<fo:table-column column-width="1.6cm" border-right-style="solid"/> <!-- 4 -->
					<fo:table-column column-width="2.5cm" border-right-style="solid"/> <!-- 5 -->
					<fo:table-column column-width="1.3cm" border-right-style="solid"/> <!-- 6 -->
					<fo:table-column column-width="1.3cm" border-right-style="solid"/> <!-- 7 -->
					<fo:table-column column-width="1.9cm" border-right-style="solid"/> <!-- 8 -->
					<fo:table-column column-width="2.5cm" border-right-style="solid"/> <!-- 9 -->
					<fo:table-column column-width="1.1cm" border-right-style="solid"/> <!-- 10 -->
					<fo:table-column column-width="1.6cm" border-right-style="solid"/> <!-- 10a -->
					<fo:table-column column-width="2.0cm" border-right-style="solid"/> <!-- 11 -->

					<fo:table-header>
						<fo:table-row border-bottom-style="solid" display-align="center">
							<fo:table-cell number-rows-spanned="2"><fo:block xsl:use-attribute-sets="table_text7_center">Наименование товара (описание выполненных работ, оказанных услуг), имущественного права</fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="2"><fo:block xsl:use-attribute-sets="table_text7_center">Единица измерения</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block xsl:use-attribute-sets="table_text7_center">Коли-чество (объем)</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block xsl:use-attribute-sets="table_text7_center">Цена (тариф) за единицу измерения </fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block xsl:use-attribute-sets="table_text7_center">Стоимость товаров (работ, услуг), имущественных прав без налога - всего</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block xsl:use-attribute-sets="table_text7_center">В том числе сумма акциза</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block xsl:use-attribute-sets="table_text7_center">Нало-говая ставка</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block xsl:use-attribute-sets="table_text7_center">Сумма налога, предъяв-ляемая покупателю</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block xsl:use-attribute-sets="table_text7_center">Стоимость товаров (работ, услуг), имущественных прав с налогом - всего</fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="2"><fo:block xsl:use-attribute-sets="table_text7_center">Страна происхождения</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block xsl:use-attribute-sets="table_text7_center">Номер таможенной декларации</fo:block></fo:table-cell>
						</fo:table-row>

						<fo:table-row border-bottom-style="solid" display-align="center">
							<fo:table-cell><fo:block xsl:use-attribute-sets="table_text6_center">код</fo:block></fo:table-cell>
							<fo:table-cell border-left-style="solid" border-left-width="0.7pt"><fo:block xsl:use-attribute-sets="table_text6_center">условное обозначение (нацио-нальное)</fo:block></fo:table-cell>
							<fo:table-cell><fo:block xsl:use-attribute-sets="table_text6_center_new">Циф-ровой код</fo:block></fo:table-cell>
							<fo:table-cell border-left-style="solid" border-left-width="0.7pt"><fo:block xsl:use-attribute-sets="table_text6_center_new">Краткое наимено-вание</fo:block></fo:table-cell>
						</fo:table-row>

						<fo:table-row border-bottom-style="solid" display-align="center" text-align="center" font-size="5pt">
							<fo:table-cell><fo:block>1</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>2</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>2a</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>3</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>4</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>5</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>6</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>7</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>8</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>9</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>10</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>10a</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>11</fo:block></fo:table-cell>
						</fo:table-row>
					</fo:table-header>

					<fo:table-body>
						<xsl:for-each select="pos">
							<xsl:variable name="nds" select="number((@summ * ($nds_rate div 100))div($nds_rate div 100 + 1))" />
							<xsl:value-of select="bg:counterAdd( 'total_nds', format-number($nds, '0.00') )" />
							<fo:table-row border-bottom-style="solid" text-align="right">
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block text-align="left"><xsl:value-of select="@name" /></fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block><xsl:value-of select="utils:valueOrDefault(@unitCode,'796')"/></fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block><xsl:value-of select="utils:valueOrDefault(@unit,'шт')"/></fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block><xsl:value-of select="utils:valueOrDefault(@quantity,'1')"/></fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block><xsl:value-of select="format-number(@summ - $nds, '0.00')" /></fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block><xsl:value-of select="format-number(@summ - $nds, '0.00')" /></fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block/></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block><xsl:value-of select="format-number($nds_rate div 100, '0%')" /></fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block><xsl:value-of select="format-number($nds, '0.00')" /></fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block><xsl:value-of select="format-number(@summ, '0.00')" /></fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block/></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block/></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell"><fo:block/></fo:table-cell>
							</fo:table-row>
						</xsl:for-each>

						<fo:table-row font-weight="bold">
							<fo:table-cell number-columns-spanned="5"><fo:block xsl:use-attribute-sets="table_text7_right">Всего к оплате</fo:block></fo:table-cell>
							<fo:table-cell><fo:block xsl:use-attribute-sets="table_text7_right"><xsl:value-of select="format-number(@total_sum - bg:counterGet( 'total_nds'), '0.00')"></xsl:value-of></fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="cell_border"><fo:block xsl:use-attribute-sets="table_text7_center">X</fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border"><fo:block xsl:use-attribute-sets="table_text7_right"><xsl:value-of select="format-number(bg:counterGet( 'total_nds' ), '0.00')" /></fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border"><fo:block xsl:use-attribute-sets="table_text7_right"><xsl:value-of select="format-number(@total_sum, '0.00')" /></fo:block></fo:table-cell>
							<fo:table-cell><fo:block></fo:block></fo:table-cell>
							<fo:table-cell><fo:block></fo:block></fo:table-cell>
							<fo:table-cell><!-- недостающая --><fo:block></fo:block></fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				<!-- Таблица с должностями и печатями -->
				<fo:table space-before="0.5cm" start-indent="0.5cm" table-layout="fixed" width="100%">
					<fo:table-column column-width="4.5cm" />
					<fo:table-column column-width="2.5cm" />
					<fo:table-column column-width="2.5cm" />
					<fo:table-column column-width="3cm" />
					<fo:table-column column-width="4.5cm" />
					<fo:table-column column-width="2.5cm" />
					<fo:table-column column-width="2.5cm" />
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell><fo:block xsl:use-attribute-sets="text7">Руководитель организации или иное уполномоченное лицо</fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="2"><fo:block/></fo:table-cell>
							<fo:table-cell><fo:block/></fo:table-cell>
							<fo:table-cell><fo:block xsl:use-attribute-sets="text7">Главный бухгалтер или иное уполномоченное лицо</fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="2"><fo:block/></fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell><fo:block/></fo:table-cell>
							<fo:table-cell>
								<fo:block>
									<xsl:call-template name="line">
										<xsl:with-param name="width" select="'2.5cm'"/>
										<xsl:with-param name="weight" select="'0.6pt'"/>
										<xsl:with-param name="space-before" select="'0.3cm'"/>
									</xsl:call-template>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell border-bottom-style="solid" border-bottom-width="0.6pt"><fo:block xsl:use-attribute-sets="text7"><xsl:value-of select="/data/inline_params/@name" /></fo:block></fo:table-cell>
							<fo:table-cell><fo:block/></fo:table-cell>
							<fo:table-cell><fo:block/></fo:table-cell>
							<fo:table-cell>
								<fo:block>
									<xsl:call-template name="line">
										<xsl:with-param name="width" select="'2.5cm'"/>
										<xsl:with-param name="weight" select="'0.6pt'"/>
										<xsl:with-param name="space-before" select="'0.3cm'"/>
									</xsl:call-template>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell border-bottom-style="solid" border-bottom-width="0.6pt"><fo:block xsl:use-attribute-sets="text7"><xsl:value-of select="/data/inline_params/@name" /></fo:block></fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell><fo:block></fo:block></fo:table-cell>
							<fo:table-cell><fo:block xsl:use-attribute-sets="table_text5_center">(подпись)</fo:block></fo:table-cell>
							<fo:table-cell><fo:block xsl:use-attribute-sets="table_text5_center">(ф.и.о.)</fo:block></fo:table-cell>
							<fo:table-cell><fo:block></fo:block></fo:table-cell>
							<fo:table-cell><fo:block></fo:block></fo:table-cell>
							<fo:table-cell><fo:block xsl:use-attribute-sets="table_text5_center">(подпись)</fo:block></fo:table-cell>
							<fo:table-cell><fo:block xsl:use-attribute-sets="table_text5_center">(ф.и.о.)</fo:block></fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell number-columns-spanned="3"><fo:block xsl:use-attribute-sets="text7" text-align="center"><xsl:value-of select="/data/inline_params/@prikaz" /></fo:block></fo:table-cell>
							<fo:table-cell><fo:block></fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="3"><fo:block xsl:use-attribute-sets="text7" text-align="center"><xsl:value-of select="/data/inline_params/@prikaz" /></fo:block></fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				<!-- таблица ИП -->
				<fo:table space-before="0.4cm" start-indent="0.5cm"
					table-layout="fixed" width="100%">
					<fo:table-column column-width="5cm" />
					<fo:table-column column-width="3.5cm" />
					<fo:table-column column-width="3.5cm" />
					<fo:table-column column-width="15cm" />
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell><fo:block xsl:use-attribute-sets="text7">Индивидуальный предприниматель или иное уполномоченное лицо</fo:block></fo:table-cell>
							<fo:table-cell>
								<fo:block>
									<xsl:call-template name="line">
										<xsl:with-param name="width" select="'2.5cm'"/>
										<xsl:with-param name="weight" select="'0.6pt'"/>
										<xsl:with-param name="space-before" select="'0.3cm'"/>
									</xsl:call-template>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block>
									<xsl:call-template name="line">
										<xsl:with-param name="width" select="'2.5cm'"/>
										<xsl:with-param name="weight" select="'0.6pt'"/>
										<xsl:with-param name="space-before" select="'0.3cm'"/>
									</xsl:call-template>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block>
									<xsl:call-template name="line">
										<xsl:with-param name="width" select="'12cm'"/>
										<xsl:with-param name="weight" select="'0.6pt'"/>
										<xsl:with-param name="space-before" select="'0.3cm'"/>
									</xsl:call-template>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell><fo:block></fo:block></fo:table-cell>
							<fo:table-cell><fo:block xsl:use-attribute-sets="table_text5_center">(подпись)</fo:block></fo:table-cell>
							<fo:table-cell><fo:block xsl:use-attribute-sets="table_text5_center">(ф.и.о.)</fo:block></fo:table-cell>
							<fo:table-cell><fo:block xsl:use-attribute-sets="table_text5_center">(реквизиты свидетельства о государственной регистрации индивидуального предпринимателя)</fo:block></fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell><fo:block></fo:block></fo:table-cell>
							<fo:table-cell><!-- недостающая --><fo:block></fo:block></fo:table-cell>
							<fo:table-cell><!-- недостающая --><fo:block></fo:block></fo:table-cell>
							<fo:table-cell><!-- недостающая --><fo:block></fo:block></fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				<fo:block xsl:use-attribute-sets="text7" space-before="0.5cm">Примечание: первый экземпляр - покупателю, второй экземпляр - продавцу. </fo:block>
			</fo:flow>
		</fo:page-sequence>

		<fo:page-sequence master-reference="second">
			<fo:flow flow-name="xsl-region-body">

				<fo:block xsl:use-attribute-sets="text" space-before="0.2cm">
					К договору <xsl:value-of select="@contract" />
				</fo:block>
				<fo:block xsl:use-attribute-sets="text_title" text-align="center">
					Акт приемки-сдачи услуг № <xsl:value-of select="@bill_number" /> от <xsl:value-of select="@date" />
				</fo:block>
				<fo:block xsl:use-attribute-sets="text7" space-before="0.0cm">
					Мы, нижеподписавшиеся, от лица Исполнителя,	<xsl:value-of select="/data/inline_params/@dolz" />
					&#160; <xsl:value-of select="/data/inline_params/@name" />, действующие на основании доверенности
					<xsl:value-of select="/data/inline_params/@dover" />
				</fo:block>
				<fo:block xsl:use-attribute-sets="text7" space-before="0.0cm">
					с одной стороны, и от лица Заказчика, <xsl:value-of select="/data/bill/attributes/@dolz" />
					&#160; <xsl:value-of select="/data/bill/attributes/@face" />, действующие на основании <xsl:value-of select="/data/bill/attributes/@osn" />
				</fo:block>
				<fo:block xsl:use-attribute-sets="text7" space-before="0.0cm">
					с другой стороны, составили настоящий акт о том, что услуги, выполненные Исполнителем по договору за период &lt;
					<xsl:call-template name="month"><xsl:with-param name="month" select="@mm" /></xsl:call-template>
					<xsl:value-of select="@yy" /> г.&gt;, удовлетворяют требованиям Заказчика и условиям договора.
				</fo:block>

				<fo:table space-before="0.2cm" table-layout="fixed">
					<fo:table-column column-width="5cm" />
					<fo:table-column column-width="1.1cm" />
					<fo:table-column column-width="1cm" />
					<fo:table-column column-width="1.5cm" />
					<fo:table-column column-width="2cm" />
					<fo:table-column column-width="1.5cm" />
					<fo:table-column column-width="2cm" />
					<fo:table-column column-width="2cm" />

					<fo:table-header>
						<fo:table-row>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">Наименование товара (описание выполненных работ, оказываемых услуг)</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block end-indent="0.01cm" start-indent="0.01cm"	xsl:use-attribute-sets="table_text7_center">Единица измере- ния</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">Коли- чество</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">Цена (тариф) за единицу измерения</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">Стоимость товаров (работ, услуг), всего без налога </fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">Нало- говая ставка</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">Сумма налога</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">Стоимость товаров (работ, услуг) всего с учетом налога</fo:block>
							</fo:table-cell>
						</fo:table-row>

						<fo:table-row>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">1</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">2</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">3</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">4</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">5</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">7</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">8</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block xsl:use-attribute-sets="table_text7_center">9</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-header>

					<fo:table-body>
						<xsl:for-each select="pos">
							<xsl:variable name="nds" select="number((@summ * ($nds_rate div 100))div($nds_rate div 100 + 1))" />

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell_border">
									<fo:block xsl:use-attribute-sets="table_text7_left">
										<xsl:value-of select="@name" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_border">
									<fo:block xsl:use-attribute-sets="table_text7_center">
										<xsl:if test="@unit">
											<xsl:value-of select="@unit" />
										</xsl:if>
										<xsl:if test="not(@unit)">
											месяц
										</xsl:if>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_border">
									<fo:block xsl:use-attribute-sets="table_text7_right">
										<xsl:if test="@quantity">
											<xsl:value-of select="@quantity" />
										</xsl:if>
										<xsl:if test="not(@quantity)">1</xsl:if>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_border">
									<fo:block xsl:use-attribute-sets="table_text7_right">
										<xsl:value-of select="format-number(@summ - $nds, '0.00')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_border">
									<fo:block xsl:use-attribute-sets="table_text7_right">
										<xsl:value-of select="format-number(@summ - $nds, '0.00')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_border">
									<fo:block xsl:use-attribute-sets="table_text7_center">
										<xsl:value-of select="format-number($nds_rate, '0.00')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_border">
									<fo:block xsl:use-attribute-sets="table_text7_right">
										<xsl:value-of select="format-number($nds, '0.00')" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_border">
									<fo:block xsl:use-attribute-sets="table_text7_right">
										<xsl:value-of select="format-number(@summ, '0.00')" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:for-each>
					</fo:table-body>
				</fo:table>

				<fo:table table-layout="fixed">
					<xsl:choose>
						<xsl:when test="@with_stamp">
							<xsl:attribute name="space-before">1cm</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="space-before">0.5cm</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>

					<fo:table-column column-width="proportional-column-width(1)" />
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell>
								
								<fo:table table-layout="fixed" space-before="0.3cm">
									<fo:table-column column-width="5cm" />
									<fo:table-column column-width="10cm" />

									<fo:table-body>
										<fo:table-row>
											<fo:table-cell><fo:block xsl:use-attribute-sets="table_text7_left">Общая стоимость услуг:</fo:block></fo:table-cell>
											<fo:table-cell><fo:block xsl:use-attribute-sets="table_text7_left"><xsl:value-of select="@total_sum" /> руб.</fo:block></fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell><fo:block xsl:use-attribute-sets="table_text7_left">В том числе НДС:</fo:block></fo:table-cell>
											<fo:table-cell><fo:block xsl:use-attribute-sets="table_text7_left"><xsl:value-of select="format-number( bg:counterGet( 'total_nds' ), '0.00')" /> руб.</fo:block></fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>

								<fo:table table-layout="fixed">
									<fo:table-column column-width="7cm" />
									<fo:table-column column-width="8cm" />

									<fo:table-body>
										<fo:table-row>
											<fo:table-cell>
												<fo:block xsl:use-attribute-sets="table_text7_left" font-weight="bold">
													Исполнитель: <xsl:value-of select="$title" />
													&#160;
													&#160;
													&#160;
												</fo:block>
											</fo:table-cell>
											<fo:table-cell>
												<fo:block xsl:use-attribute-sets="table_text7_left" font-weight="bold">
													Заказчик: <xsl:value-of select="/data/bill/attributes/@org_name" />
													&#160;
													&#160;
													&#160;
												</fo:block>
											</fo:table-cell>
										</fo:table-row>

										<fo:table-row>
											<fo:table-cell>
												<fo:block>
													<xsl:call-template name="line">
														<xsl:with-param name="width" select="'3.5cm'" />
														<xsl:with-param name="weight" select="'0.6pt'" />
														<xsl:with-param name="space-before" select="'1.0cm'" />
													</xsl:call-template>
													<xsl:if test="@with_stamp">
														<fo:table start-indent="1cm" table-layout="fixed" width="100%" space-before="-3cm">
															<fo:table-column column-width="0.0cm" />
															<fo:table-column column-width="4.0cm" />
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-body>
																<fo:table-row>
																	<fo:table-cell>
																		<fo:block></fo:block>
																	</fo:table-cell>
																	<fo:table-cell number-columns-spanned="2">
																		<fo:block>
																			<fo:external-graphic src="webroot/stamp.gif"
																				width="4.1cm" height="3.85cm" content-height="3.85cm"
																				content-width="4.1cm" space-before="1.2cm" />
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
													</xsl:if>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell>
												<fo:block>
													<xsl:call-template name="line">
														<xsl:with-param name="width" select="'3.5cm'" />
														<xsl:with-param name="weight" select="'0.6pt'" />
														<xsl:with-param name="space-before" select="'1.0cm'" />
													</xsl:call-template>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										
										<fo:table-row>
											<fo:table-cell>
												<fo:block xsl:use-attribute-sets="table_text7_left">
													<xsl:value-of select="/data/inline_params/@name" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell>
												<fo:block xsl:use-attribute-sets="table_text7_left">
													<xsl:value-of select="/data/bill/attributes/@face" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>

								<xsl:variable name="dateD" select="substring(@date,1,2)" />

								<fo:block xsl:use-attribute-sets="text7" space-before="0.4cm">
									Подписан <xsl:value-of select="substring(@date,1,2)" />
									&#xA0;
									<xsl:call-template name="month2">
										<xsl:with-param name="month" select="number(substring(@date,4,2))-1" />
									</xsl:call-template>
									&#xA0;<xsl:value-of select="substring(@date,7)" />
									г. в двух экземплярах по одному для каждой из сторон
								</fo:block>
								<xsl:call-template name="line">
									<xsl:with-param name="width" select="'100%'" />
									<xsl:with-param name="weight" select="'0.7pt'" />
									<xsl:with-param name="space-before" select="'0.3cm'" />
								</xsl:call-template>

								<fo:block xsl:use-attribute-sets="text7">Уважаемые партнеры!</fo:block>
								<fo:block xsl:use-attribute-sets="text7">Просим Вас второй экземпляр акта, заверенный с Вашей стороны, отправить на почтовый адрес</fo:block>
								<fo:block xsl:use-attribute-sets="text_bold"><xsl:value-of select="$postal_address" /></fo:block>
								<fo:block xsl:use-attribute-sets="text7">Заранее благодарим,</fo:block>
								<fo:block xsl:use-attribute-sets="text7">Администрация <xsl:value-of select="$title" /></fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>

				<fo:block-container height="2cm" width="20cm"
					top="28cm" left="0mm" position="absolute">
					<fo:block xsl:use-attribute-sets="text7" text-align="left">
						Адрес доставки: <xsl:value-of select="/data/bill/contract_params/parameter[@pid='330']/@value" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="text7" text-align="left">
						Маршрут: <xsl:value-of select="/data/bill/contract_params/parameter[@pid='377']/@value" />
					</fo:block>
				</fo:block-container>
			</fo:flow>
		</fo:page-sequence>
	</xsl:template>

	<xsl:template name="month">
		<xsl:param name="month" />
		<xsl:choose>
			<xsl:when test="$month = 0">Январь</xsl:when>
			<xsl:when test="$month = 1">Февраль</xsl:when>
			<xsl:when test="$month = 2">Март</xsl:when>
			<xsl:when test="$month = 3">Апрель</xsl:when>
			<xsl:when test="$month = 4">Май</xsl:when>
			<xsl:when test="$month = 5">Июнь</xsl:when>
			<xsl:when test="$month = 6">Июль</xsl:when>
			<xsl:when test="$month = 7">Август</xsl:when>
			<xsl:when test="$month = 8">Сентябрь</xsl:when>
			<xsl:when test="$month = 9">Октябрь</xsl:when>
			<xsl:when test="$month = 10">Ноябрь</xsl:when>
			<xsl:when test="$month = 11">Декабрь</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="month2">
		<xsl:param name="month" />
		<xsl:choose>
			<xsl:when test="$month = 0">Января</xsl:when>
			<xsl:when test="$month = 1">Февраля</xsl:when>
			<xsl:when test="$month = 2">Марта</xsl:when>
			<xsl:when test="$month = 3">Апреля</xsl:when>
			<xsl:when test="$month = 4">Мая</xsl:when>
			<xsl:when test="$month = 5">Июня</xsl:when>
			<xsl:when test="$month = 6">Июля</xsl:when>
			<xsl:when test="$month = 7">Августа</xsl:when>
			<xsl:when test="$month = 8">Сентября</xsl:when>
			<xsl:when test="$month = 9">Октября</xsl:when>
			<xsl:when test="$month = 10">Ноября</xsl:when>
			<xsl:when test="$month = 11">Декабря</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="line">
		<xsl:param name="width" />
		<xsl:param name="weight" />
		<xsl:param name="space-before" />

		<fo:table table-layout="fixed" width="100%">
			<xsl:attribute name="width"><xsl:value-of select="$width" /></xsl:attribute>
			<xsl:attribute name="space-before"><xsl:value-of select="$space-before" /></xsl:attribute>
			<fo:table-column column-width="proportional-column-width(1)" />
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell border-bottom-style="solid"><xsl:attribute name="border-bottom-width"><xsl:value-of select="$weight" /></xsl:attribute><fo:block></fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

</xsl:stylesheet>
