/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.LocalDateTime;
import java.util.Date;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.xml.XmlAdapters;

public class ContractNote
extends IdTitle {
    private String comment;
    private int contractId;
    private LocalDateTime dateTime;
    private int userId;
    private boolean visible = false;

    public String getComment() {
        return this.comment;
    }

    @XmlAttribute
    public int getContractId() {
        return this.contractId;
    }

    public Date getDate() {
        return this.dateTime != null ? TimeUtils.convertLocalDateTimeToDate(this.dateTime) : null;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(type=LocalDateTime.class, value=XmlAdapters.LocalDateTimeAdapter.class)
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @XmlAttribute
    public int getUserId() {
        return this.userId;
    }

    @XmlAttribute
    public boolean isVisible() {
        return this.visible;
    }

    public ContractNote setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public ContractNote setContractId(int contractId) {
        this.contractId = contractId;
        return this;
    }

    public ContractNote setDateTime(LocalDateTime time) {
        this.dateTime = time;
        return this;
    }

    @Override
    public ContractNote setId(int id) {
        super.setId(id);
        return this;
    }

    @Override
    public ContractNote setTitle(String title) {
        super.setTitle(title);
        return this;
    }

    public ContractNote setUserId(int userId) {
        this.userId = userId;
        return this;
    }

    public ContractNote setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }
}

